/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class ItextFunctions {
    public static final int ROTATECLOCKWISE = 0;
    public static final int ROTATECOUNTERCLOCKWISE = 1;
    public static final int ROTATE180 = 2;
    public static final int ORDER_ACROSS = 3;
    public static final int ORDER_DOWN = 4;
    public static final int ORDER_STACK = 5;
    public static final int REPEAT_NONE = 6;
    public static final int REPEAT_AUTO = 7;
    public static final int REPEAT_SPECIFIED = 8;
    private final String separator = System.getProperty("file.separator");
    private String fileName = "";
    private GUIFactory currentGUI;
    private String selectedFile;
    private PdfDecoder dPDF;

    public ItextFunctions(SwingGUI swingGUI, String string, PdfDecoder pdfDecoder) {
        String string2 = new File(string).getName();
        if (string2.lastIndexOf(46) != -1) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        this.fileName = string2.replaceAll("%20", " ");
        this.currentGUI = swingGUI;
        this.selectedFile = string;
        this.dPDF = pdfDecoder;
    }

    public void saveFormsData(String string) {
        try {
            AcroRenderer acroRenderer = this.dPDF.getFormRenderer();
            if (acroRenderer == null) {
                return;
            }
            PdfReader pdfReader = new PdfReader(this.selectedFile);
            PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(string));
            AcroFields acroFields = pdfStamper.getAcroFields();
            List list = acroRenderer.getComponentNameList();
            block13: for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                Component[] componentArray = (Component[])acroRenderer.getComponentsByName(string2);
                int n = acroFields.getFieldType(string2);
                String string3 = "";
                switch (n) {
                    case 2: {
                        JComponent jComponent;
                        if (componentArray.length == 1) {
                            int n2;
                            jComponent = (JCheckBox)componentArray[0];
                            string3 = jComponent.getName();
                            if (string3 != null && (n2 = string3.indexOf("-(")) != -1) {
                                string3 = string3.substring(n2 + 2, string3.length() - 1);
                            }
                            if (string3.length() == 0) {
                                string3 = "On";
                            }
                            if (((AbstractButton)jComponent).isSelected()) {
                                acroFields.setField(string2, string3);
                                continue block13;
                            }
                            acroFields.setField(string2, "Off");
                            continue block13;
                        }
                        for (int j = 0; j < componentArray.length; ++j) {
                            int n3;
                            JCheckBox jCheckBox = (JCheckBox)componentArray[j];
                            if (!jCheckBox.isSelected()) continue;
                            string3 = jCheckBox.getName();
                            if (string3 == null || (n3 = string3.indexOf("-(")) == -1) continue block13;
                            string3 = string3.substring(n3 + 2, string3.length() - 1);
                            acroFields.setField(string2, string3);
                            continue block13;
                        }
                        continue block13;
                    }
                    case 6: {
                        JComponent jComponent = (JComboBox)componentArray[0];
                        string3 = (String)((JComboBox)jComponent).getSelectedItem();
                        if (string3 == null) {
                            string3 = "";
                        }
                        acroFields.setField(string2, string3);
                        continue block13;
                    }
                    case 5: {
                        JList jList = (JList)componentArray[0];
                        string3 = (String)jList.getSelectedValue();
                        if (string3 == null) {
                            string3 = "";
                        }
                        acroFields.setField(string2, string3);
                        continue block13;
                    }
                    case 0: {
                        continue block13;
                    }
                    case 1: {
                        continue block13;
                    }
                    case 3: {
                        for (int j = 0; j < componentArray.length; ++j) {
                            int n4;
                            JRadioButton jRadioButton = (JRadioButton)componentArray[j];
                            if (!jRadioButton.isSelected()) continue;
                            string3 = jRadioButton.getName();
                            if (string3 == null || (n4 = string3.indexOf("-(")) == -1) continue block13;
                            string3 = string3.substring(n4 + 2, string3.length() - 1);
                            acroFields.setField(string2, string3);
                            continue block13;
                        }
                        continue block13;
                    }
                    case 7: {
                        continue block13;
                    }
                    case 4: {
                        JTextComponent jTextComponent = (JTextComponent)componentArray[0];
                        string3 = jTextComponent.getText();
                        acroFields.setField(string2, string3);
                        continue block13;
                    }
                }
            }
            pdfStamper.close();
        }
        catch (ClassCastException classCastException) {
            System.out.println("Expected component does not match actual component");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void extractPagesToNewPDF(SavePDF savePDF) {
        final boolean bl = savePDF.getExportType();
        final int[] nArray = savePDF.getExportPages();
        if (nArray == null) {
            return;
        }
        final int n = nArray.length;
        final String string = savePDF.getRootDir() + this.separator + this.fileName + this.separator + "PDFs" + this.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.GeneratingPdfs"), "", 0, n);
        SwingWorker swingWorker = new SwingWorker(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object construct() {
                if (!bl) {
                    try {
                        int n4;
                        PdfReader pdfReader = new PdfReader(ItextFunctions.this.selectedFile);
                        File file = new File(string + "export_" + ItextFunctions.this.fileName + ".pdf");
                        if (file.exists() && (n4 = ItextFunctions.this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), false)) != 0) {
                            return null;
                        }
                        Document document = new Document();
                        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(file.getAbsolutePath()));
                        document.open();
                        for (int i = 0; i < n; ++i) {
                            int n2 = nArray[i];
                            PdfImportedPage pdfImportedPage = pdfCopy.getImportedPage(pdfReader, n2);
                            pdfCopy.addPage(pdfImportedPage);
                        }
                        PRAcroForm pRAcroForm = pdfReader.getAcroForm();
                        if (pRAcroForm != null) {
                            pdfCopy.copyAcroForm(pdfReader);
                        }
                        List list = SimpleBookmark.getBookmark((PdfReader)pdfReader);
                        pdfCopy.setOutlines(list);
                        document.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    boolean bl2 = false;
                    for (int i = 0; i < n; ++i) {
                        int n5 = nArray[i];
                        if (progressMonitor.isCanceled()) {
                            ItextFunctions.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + i + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                            return null;
                        }
                        try {
                            PdfReader pdfReader = new PdfReader(ItextFunctions.this.selectedFile);
                            File file = new File(string + ItextFunctions.this.fileName + "_pg_" + n5 + ".pdf");
                            if (file.exists() && !bl2) {
                                int n3;
                                if (nArray.length > 1) {
                                    n3 = ItextFunctions.this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), true);
                                    if (n3 != 0) {
                                        if (n3 == 1) {
                                            bl2 = true;
                                        } else {
                                            if (n3 != 2) {
                                                ItextFunctions.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.UserStoppedExport") + i + ' ' + Messages.getMessage("PdfViewerError.ReportNumberOfPagesExported"));
                                                progressMonitor.close();
                                                return null;
                                            }
                                            progressMonitor.setProgress(n5);
                                            continue;
                                        }
                                    }
                                } else {
                                    n3 = ItextFunctions.this.currentGUI.showOverwriteDialog(file.getAbsolutePath(), false);
                                    if (n3 != 0) {
                                        return null;
                                    }
                                }
                            }
                            Document document = new Document();
                            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(file));
                            document.open();
                            PdfImportedPage pdfImportedPage = pdfCopy.getImportedPage(pdfReader, n5);
                            pdfCopy.addPage(pdfImportedPage);
                            PRAcroForm pRAcroForm = pdfReader.getAcroForm();
                            if (pRAcroForm != null) {
                                pdfCopy.copyAcroForm(pdfReader);
                            }
                            document.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        progressMonitor.setProgress(i + 1);
                    }
                }
                progressMonitor.close();
                ItextFunctions.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.PagesSavedAsPdfTo") + ' ' + string);
                return null;
            }
        };
        swingWorker.start();
    }

    public void nup(int n, PdfPageData pdfPageData, ExtractPDFPagesNup extractPDFPagesNup) {
        try {
            int n2;
            int n3;
            int n4;
            int[] nArray = extractPDFPagesNup.getPages();
            if (nArray == null) {
                return;
            }
            String string = extractPDFPagesNup.getRootDir() + this.separator + this.fileName + this.separator + "PDFs" + this.separator;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Integer(nArray[i]));
            }
            PdfReader pdfReader = new PdfReader(this.selectedFile);
            File file2 = new File(string + "export_" + this.fileName + ".pdf");
            if (file2.exists() && (n4 = this.currentGUI.showOverwriteDialog(file2.getAbsolutePath(), false)) != 0) {
                return;
            }
            n4 = extractPDFPagesNup.getLayoutRows();
            int n5 = extractPDFPagesNup.getLayoutColumns();
            int n6 = extractPDFPagesNup.getPaperWidth();
            int n7 = extractPDFPagesNup.getPaperHeight();
            Rectangle rectangle = new Rectangle((float)n6, (float)n7);
            String string2 = extractPDFPagesNup.getPaperOrientation();
            Rectangle rectangle2 = null;
            if (string2.equals(Messages.getMessage("PdfViewerNUPOption.Auto"))) {
                rectangle2 = n5 > n4 ? new Rectangle(rectangle.getHeight(), rectangle.getWidth()) : new Rectangle(rectangle.getWidth(), rectangle.getHeight());
            } else if (string2.equals("Portrait")) {
                rectangle2 = new Rectangle(rectangle.getWidth(), rectangle.getHeight());
            } else if (string2.equals("Landscape")) {
                rectangle2 = new Rectangle(rectangle.getHeight(), rectangle.getWidth());
            }
            String string3 = extractPDFPagesNup.getScale();
            float f = extractPDFPagesNup.getLeftRightMargin();
            float f2 = extractPDFPagesNup.getTopBottomMargin();
            float f3 = extractPDFPagesNup.getHorizontalSpacing();
            float f4 = extractPDFPagesNup.getVerticalSpacing();
            Rectangle rectangle3 = null;
            if (string3.equals("Auto")) {
                float f5 = (float)(n5 - 1) * f3;
                n3 = (int)(rectangle2.getWidth() - f * 2.0f - f5);
                n2 = n3 / n5;
                float f6 = (float)(n4 - 1) * f4;
                int n8 = (int)(rectangle2.getHeight() - f2 * 2.0f - f6);
                int n9 = n8 / n4;
                rectangle3 = new Rectangle((float)n2, (float)n9);
            } else if (string3.equals("Use Original Size")) {
                rectangle3 = null;
            } else if (string3.equals("Specified")) {
                rectangle3 = new Rectangle(extractPDFPagesNup.getScaleWidth(), extractPDFPagesNup.getScaleHeight());
            }
            int n10 = extractPDFPagesNup.getPageOrdering();
            n3 = n4 * n5;
            n2 = 1;
            if (extractPDFPagesNup.getRepeat() == 7) {
                n2 = n5 * n4;
            } else if (extractPDFPagesNup.getRepeat() == 8) {
                n2 = extractPDFPagesNup.getCopies();
            }
            Document document = new Document(rectangle2, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            float f7 = 0.0f;
            float f8 = 0.0f;
            int n11 = 0;
            int n12 = 0;
            boolean bl = extractPDFPagesNup.isScaleProportional();
            for (int i = 1; i <= n; ++i) {
                if (!arrayList.contains(new Integer(i))) continue;
                for (int j = 0; j < n2; ++j) {
                    float f9;
                    int n13 = n12 % n3;
                    if (n13 == 0) {
                        document.newPage();
                        ++n11;
                    }
                    Rectangle rectangle4 = pdfReader.getPageSizeWithRotation(i);
                    if (rectangle3 == null) {
                        rectangle3 = rectangle4;
                    }
                    int n14 = 0;
                    int n15 = 0;
                    if (n10 == 4) {
                        n14 = n13 / n4;
                        n15 = n13 % n4;
                        f7 = rectangle3.getWidth() * (float)n14;
                        f8 = rectangle2.getHeight() - rectangle3.getHeight() * (float)(n15 + 1);
                    } else if (n10 == 3) {
                        n14 = n13 % n5;
                        n15 = n13 / n5;
                        f7 = rectangle3.getWidth() * (float)n14;
                        f8 = rectangle2.getHeight() - rectangle3.getHeight() * (float)(n13 / n5 + 1);
                    }
                    float f10 = f9 = Math.min(rectangle3.getWidth() / rectangle4.getWidth(), rectangle3.getHeight() / rectangle4.getHeight());
                    float f11 = f9;
                    if (!bl) {
                        f10 = rectangle3.getWidth() / rectangle4.getWidth();
                        f11 = rectangle3.getHeight() / rectangle4.getHeight();
                    } else {
                        f7 += (rectangle3.getWidth() - rectangle4.getWidth() * f9) / 2.0f;
                        f8 += (rectangle3.getHeight() - rectangle4.getHeight() * f9) / 2.0f;
                    }
                    f7 += f3 * (float)n14 + f;
                    f8 -= f4 * (float)n15 + f2;
                    PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, i);
                    double d = (double)rectangle4.getRotation() * Math.PI / 180.0;
                    int n16 = -pdfPageData.getMediaBoxX(i);
                    int n17 = -pdfPageData.getMediaBoxY(i);
                    switch (rectangle4.getRotation()) {
                        case 0: {
                            float f12 = f10;
                            float f13 = 0.0f;
                            float f14 = 0.0f;
                            float f15 = f11;
                            float f16 = f7 + (float)n16 * f10;
                            float f17 = f8 + (float)n17 * f11;
                            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f12, f13, f14, f15, f16, f17);
                            break;
                        }
                        case 90: {
                            float f12 = 0.0f;
                            float f13 = (float)(Math.sin(d) * (double)(-f11));
                            float f14 = (float)(Math.sin(d) * (double)f10);
                            float f15 = 0.0f;
                            float f16 = f7 + (float)n17 * f10;
                            float f17 = rectangle4.getHeight() * f11 + f8 - (float)n16 * f11;
                            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f12, f13, f14, f15, f16, f17);
                            break;
                        }
                        case 180: {
                            float f12 = (float)(Math.cos(d) * (double)f10);
                            float f13 = 0.0f;
                            float f14 = 0.0f;
                            float f15 = (float)(Math.cos(d) * (double)f11);
                            float f16 = f7 + rectangle4.getWidth() * f10 - (float)n16 * f10;
                            float f17 = rectangle4.getHeight() * f11 + f8 - (float)n17 * f11;
                            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f12, f13, f14, f15, f16, f17);
                            break;
                        }
                        case 270: {
                            float f12 = 0.0f;
                            float f13 = (float)(Math.sin(d) * (double)(-f11));
                            float f14 = (float)(Math.sin(d) * (double)f10);
                            float f15 = 0.0f;
                            float f16 = f7 + rectangle4.getWidth() * f10 - (float)n17 * f10;
                            float f17 = f8 + (float)n16 * f11;
                            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f12, f13, f14, f15, f16, f17);
                        }
                    }
                    ++n12;
                }
            }
            document.close();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.PagesSavedAsPdfTo") + ' ' + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handouts(String string) {
        try {
            File file = new File(this.selectedFile);
            File file2 = new File(string);
            int n = 4;
            float f = 30.0f;
            float f2 = 280.0f;
            float f3 = 320.0f;
            float f4 = 565.0f;
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            float f5 = (778.0f - 20.0f * (float)(n - 1)) / (float)n;
            fArray[0] = 812.0f;
            fArray2[0] = 812.0f - f5;
            for (int i = 1; i < n; ++i) {
                fArray[i] = fArray2[i - 1] - 20.0f;
                fArray2[i] = fArray[i] - f5;
            }
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            int n2 = pdfReader.getNumberOfPages();
            Document document = new Document(PageSize.A4);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file2));
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                float f6;
                Rectangle rectangle;
                float f7;
                float f8 = (f7 = (f2 - f) / (rectangle = pdfReader.getPageSizeWithRotation(++n3)).getWidth()) < (f6 = (fArray[n4] - fArray2[n4]) / rectangle.getHeight()) ? f7 : f6;
                float f9 = f7 == f8 ? 0.0f : (f2 - f - rectangle.getWidth() * f8) / 2.0f;
                float f10 = f6 == f8 ? 0.0f : (fArray[n4] - fArray2[n4] - rectangle.getHeight() * f8) / 2.0f;
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n3);
                int n5 = pdfReader.getPageRotation(n3);
                if (n5 == 90 || n5 == 270) {
                    pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, 0.0f, -f8, f8, 0.0f, f + f9, fArray2[n4] + f10 + rectangle.getHeight() * f8);
                } else {
                    pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f8, 0.0f, 0.0f, f8, f + f9, fArray2[n4] + f10);
                }
                pdfContentByte.setRGBColorStroke(192, 192, 192);
                pdfContentByte.rectangle(f3 - 5.0f, fArray2[n4] - 5.0f, f4 - f3 + 10.0f, fArray[n4] - fArray2[n4] + 10.0f);
                for (float f11 = fArray[n4] - 19.0f; f11 > fArray2[n4]; f11 -= 16.0f) {
                    pdfContentByte.moveTo(f3, f11);
                    pdfContentByte.lineTo(f4, f11);
                }
                pdfContentByte.rectangle(f + f9, fArray2[n4] + f10, rectangle.getWidth() * f8, rectangle.getHeight() * f8);
                pdfContentByte.stroke();
                if (++n4 != n) continue;
                n4 = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(int n, PdfPageData pdfPageData, InsertBlankPDFPage insertBlankPDFPage) {
        File file = null;
        try {
            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
        }
        catch (Exception exception) {
            return;
        }
        int n2 = insertBlankPDFPage.getInsertBefore();
        boolean bl = false;
        if (n2 == -1) {
            return;
        }
        if (n2 == -2) {
            bl = true;
        }
        try {
            try {
                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                if (bl) {
                    pdfStamper.insertPage(n + 1, pdfReader.getPageSizeWithRotation(n));
                } else {
                    pdfStamper.insertPage(n2, pdfReader.getPageSizeWithRotation(n2));
                }
                pdfStamper.close();
            }
            catch (Exception exception) {
                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                exception.printStackTrace();
                Object var10_12 = null;
                file.delete();
                return;
            }
            Object var10_11 = null;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            file.delete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rotate(int n, PdfPageData pdfPageData, RotatePDFPages rotatePDFPages) {
        File file;
        block16: {
            block15: {
                block14: {
                    file = null;
                    try {
                        file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
                        ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        return;
                    }
                    try {
                        try {
                            int n2;
                            int[] nArray = rotatePDFPages.getRotatedPages();
                            if (nArray == null) {
                                Object var13_8 = null;
                                file.delete();
                                return;
                            }
                            int n3 = -1;
                            n3 = nArray.length == 1 ? this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerMessage.ConfirmRotatePages"), Messages.getMessage("PdfViewerMessage.Confirm"), 0) : this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerMessage.ConfirmRotatePages"), Messages.getMessage("PdfViewerMessage.Confirm"), 0);
                            if (n3 != 0) {
                                break block14;
                            }
                            if (nArray == null) {
                                break block15;
                            }
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                arrayList.add(new Integer(nArray[n2]));
                            }
                            n2 = rotatePDFPages.getDirection();
                            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                            for (int i = 1; i <= n; ++i) {
                                if (!arrayList.contains(new Integer(i))) continue;
                                int n4 = pdfPageData.getRotation(i);
                                if (n2 == 0) {
                                    pdfReader.getPageN(i).put(PdfName.ROTATE, (PdfObject)new PdfNumber((n4 + 90) % 360));
                                    continue;
                                }
                                if (n2 == 1) {
                                    pdfReader.getPageN(i).put(PdfName.ROTATE, (PdfObject)new PdfNumber((n4 - 90) % 360));
                                    continue;
                                }
                                if (n2 != 2) throw new Exception("invalid desired rotation");
                                pdfReader.getPageN(i).put(PdfName.ROTATE, (PdfObject)new PdfNumber((n4 + 180) % 360));
                            }
                            PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                            pdfStamper.close();
                            break block16;
                        }
                        catch (Exception exception) {
                            ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                            exception.printStackTrace();
                            Object var13_12 = null;
                            file.delete();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        file.delete();
                        throw throwable;
                    }
                }
                Object var13_9 = null;
                file.delete();
                return;
            }
            Object var13_10 = null;
            file.delete();
            return;
        }
        Object var13_11 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCrop(int n, PdfPageData pdfPageData, CropPDFPages cropPDFPages) {
        File file = null;
        try {
            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
        }
        catch (Exception exception) {
            return;
        }
        try {
            try {
                int[] nArray = cropPDFPages.getPages();
                if (nArray == null) {
                    Object var16_8 = null;
                    file.delete();
                    return;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(new Integer(nArray[i]));
                }
                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                boolean bl = cropPDFPages.applyToCurrentCrop();
                for (int i = 1; i <= n; ++i) {
                    if (!arrayList.contains(new Integer(i))) continue;
                    float f = pdfPageData.getCropBoxX(i);
                    float f2 = pdfPageData.getCropBoxY(i);
                    float f3 = (float)pdfPageData.getCropBoxWidth(i) + f;
                    float f4 = (float)pdfPageData.getCropBoxHeight(i) + f2;
                    float[] fArray = cropPDFPages.getCrop();
                    if (bl) {
                        fArray[0] = f + fArray[0];
                        fArray[1] = f2 + fArray[1];
                        fArray[2] = f3 - fArray[2];
                        fArray[3] = f4 - fArray[3];
                    } else {
                        fArray[2] = pdfReader.getPageSize(i).getWidth() - fArray[2];
                        fArray[3] = pdfReader.getPageSize(i).getHeight() - fArray[3];
                    }
                    pdfReader.getPageN(i).put(PdfName.CROPBOX, (PdfObject)new PdfArray(fArray));
                }
                PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                pdfStamper.close();
            }
            catch (Exception exception) {
                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                exception.printStackTrace();
                Object var16_10 = null;
                file.delete();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            file.delete();
            throw throwable;
        }
        Object var16_9 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(int n, PdfPageData pdfPageData, DeletePDFPages deletePDFPages) {
        File file;
        block17: {
            block16: {
                block15: {
                    block14: {
                        file = null;
                        try {
                            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
                            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            return;
                        }
                        try {
                            try {
                                int[] nArray = deletePDFPages.getDeletedPages();
                                if (nArray == null) {
                                    Object var16_8 = null;
                                    file.delete();
                                    return;
                                }
                                int n2 = -1;
                                n2 = nArray.length == 1 ? this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerMessage.ConfirmDeletePage"), Messages.getMessage("PdfViewerMessage.Confirm"), 0) : this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerMessage.ConfirmDeletePage"), Messages.getMessage("PdfViewerMessage.Confirm"), 0);
                                if (n2 != 0) {
                                    break block14;
                                }
                                if (nArray == null) {
                                    break block15;
                                }
                                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                                for (int i = 0; i < nArray.length; ++i) {
                                    arrayList.add(new Integer(nArray[i]));
                                }
                                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                                List list = SimpleBookmark.getBookmark((PdfReader)pdfReader);
                                SimpleBookmark.shiftPageNumbers((List)list, (int)-1, (int[])new int[]{5, 5});
                                boolean bl = false;
                                for (int i = 1; i <= n; ++i) {
                                    if (arrayList.contains(new Integer(i))) continue;
                                    bl = true;
                                    i = n;
                                }
                                if (!bl) {
                                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.PageWillNotDelete"));
                                    break block16;
                                }
                                Document document = new Document();
                                PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream(this.selectedFile));
                                document.open();
                                for (int i = 1; i <= n; ++i) {
                                    if (arrayList.contains(new Integer(i))) continue;
                                    PdfImportedPage pdfImportedPage = pdfCopy.getImportedPage(pdfReader, i);
                                    pdfCopy.addPage(pdfImportedPage);
                                    bl = true;
                                }
                                pdfCopy.setOutlines(list);
                                document.close();
                                break block17;
                            }
                            catch (Exception exception) {
                                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                                exception.printStackTrace();
                                Object var16_13 = null;
                                file.delete();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_14 = null;
                            file.delete();
                            throw throwable;
                        }
                    }
                    Object var16_9 = null;
                    file.delete();
                    return;
                }
                Object var16_10 = null;
                file.delete();
                return;
            }
            Object var16_11 = null;
            file.delete();
            return;
        }
        Object var16_12 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stampImage(int n, PdfPageData pdfPageData, StampImageToPDFPages stampImageToPDFPages) {
        File file;
        block12: {
            block11: {
                file = null;
                try {
                    file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
                    ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
                }
                catch (Exception exception) {
                    return;
                }
                try {
                    try {
                        int[] nArray = stampImageToPDFPages.getPages();
                        if (nArray == null) {
                            Object var27_8 = null;
                            file.delete();
                            return;
                        }
                        File file2 = new File(stampImageToPDFPages.getImageLocation());
                        if (!file2.exists()) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerError.ImageDoesNotExist"));
                            break block11;
                        }
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList.add(new Integer(nArray[i]));
                        }
                        PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                        int n2 = pdfReader.getNumberOfPages();
                        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                        Image image = Image.getInstance((String)file2.getAbsolutePath());
                        int n3 = stampImageToPDFPages.getWidthScale();
                        int n4 = stampImageToPDFPages.getHeightScale();
                        image.scalePercent((float)n3, (float)n4);
                        String string = stampImageToPDFPages.getPlacement();
                        int n5 = stampImageToPDFPages.getRotation();
                        image.setRotationDegrees((float)n5);
                        String string2 = stampImageToPDFPages.getHorizontalPosition();
                        String string3 = stampImageToPDFPages.getVerticalPosition();
                        float f = stampImageToPDFPages.getHorizontalOffset();
                        float f2 = stampImageToPDFPages.getVerticalOffset();
                        for (int i = 0; i <= n2; ++i) {
                            if (!arrayList.contains(new Integer(i))) continue;
                            PdfContentByte pdfContentByte = string.equals("Overlay") ? pdfStamper.getOverContent(i) : pdfStamper.getUnderContent(i);
                            int n6 = pdfPageData.getRotation(i);
                            Rectangle rectangle = n6 == 90 || n6 == 270 ? pdfReader.getPageSize(i).rotate() : pdfReader.getPageSize(i);
                            float f3 = string3.equals("From the top") ? rectangle.getHeight() - image.getHeight() * (float)(n4 / 100) / 2.0f : (string3.equals("Centered") ? rectangle.getHeight() / 2.0f - image.getHeight() * (float)(n4 / 100) / 2.0f : 0.0f);
                            float f4 = string2.equals("From the left") ? 0.0f : (string2.equals("Centered") ? rectangle.getWidth() / 2.0f - image.getWidth() * (float)(n3 / 100) / 2.0f : rectangle.getWidth() - image.getWidth() * (float)(n3 / 100) / 2.0f);
                            image.setAbsolutePosition(f4 + f, f3 + f2);
                            pdfContentByte.addImage(image);
                        }
                        pdfStamper.close();
                        break block12;
                    }
                    catch (Exception exception) {
                        ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                        exception.printStackTrace();
                        Object var27_11 = null;
                        file.delete();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var27_12 = null;
                    file.delete();
                    throw throwable;
                }
            }
            Object var27_9 = null;
            file.delete();
            return;
        }
        Object var27_10 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stampText(int n, PdfPageData pdfPageData, StampTextToPDFPages stampTextToPDFPages) {
        File file = null;
        try {
            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
        }
        catch (Exception exception) {
            return;
        }
        try {
            try {
                int[] nArray = stampTextToPDFPages.getPages();
                if (nArray == null) {
                    Object var27_8 = null;
                    file.delete();
                    return;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(new Integer(nArray[i]));
                }
                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                for (int i = 1; i <= n; ++i) {
                    String string;
                    if (!arrayList.contains(new Integer(i)) || (string = stampTextToPDFPages.getText()).length() == 0) continue;
                    String string2 = stampTextToPDFPages.getFontName();
                    Color color = stampTextToPDFPages.getFontColor();
                    int n2 = stampTextToPDFPages.getFontSize();
                    int n3 = stampTextToPDFPages.getRotation();
                    String string3 = stampTextToPDFPages.getPlacement();
                    String string4 = stampTextToPDFPages.getHorizontalPosition();
                    String string5 = stampTextToPDFPages.getVerticalPosition();
                    float f = stampTextToPDFPages.getHorizontalOffset();
                    float f2 = stampTextToPDFPages.getVerticalOffset();
                    BaseFont baseFont = BaseFont.createFont((String)string2, (String)"Cp1252", (boolean)false);
                    PdfContentByte pdfContentByte = string3.equals("Overlay") ? pdfStamper.getOverContent(i) : pdfStamper.getUnderContent(i);
                    pdfContentByte.beginText();
                    pdfContentByte.setColorFill(color);
                    pdfContentByte.setFontAndSize(baseFont, (float)n2);
                    int n4 = pdfPageData.getRotation(i);
                    Rectangle rectangle = n4 == 90 || n4 == 270 ? pdfReader.getPageSize(i).rotate() : pdfReader.getPageSize(i);
                    float f3 = string5.equals("From the top") ? rectangle.getHeight() : (string5.equals("Centered") ? rectangle.getHeight() / 2.0f : 0.0f);
                    float f4 = string4.equals("From the left") ? 0.0f : (string4.equals("Centered") ? rectangle.getWidth() / 2.0f : rectangle.getWidth());
                    pdfContentByte.showTextAligned(1, string, f4 + f, f3 + f2, (float)n3);
                    pdfContentByte.endText();
                }
                pdfStamper.close();
            }
            catch (Exception exception) {
                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                exception.printStackTrace();
                Object var27_10 = null;
                file.delete();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var27_11 = null;
            file.delete();
            throw throwable;
        }
        Object var27_9 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHeaderFooter(int n, PdfPageData pdfPageData, AddHeaderFooterToPDFPages addHeaderFooterToPDFPages) {
        File file = null;
        try {
            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
        }
        catch (Exception exception) {
            return;
        }
        try {
            try {
                int[] nArray = addHeaderFooterToPDFPages.getPages();
                if (nArray == null) {
                    Object var28_8 = null;
                    file.delete();
                    return;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(new Integer(nArray[i]));
                }
                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(this.selectedFile));
                String string = addHeaderFooterToPDFPages.getFontName();
                Color color = addHeaderFooterToPDFPages.getFontColor();
                int n2 = addHeaderFooterToPDFPages.getFontSize();
                float f = addHeaderFooterToPDFPages.getLeftRightMargin();
                float f2 = addHeaderFooterToPDFPages.getTopBottomMargin();
                String[] stringArray = new String[]{addHeaderFooterToPDFPages.getLeftHeader(), addHeaderFooterToPDFPages.getCenterHeader(), addHeaderFooterToPDFPages.getRightHeader(), addHeaderFooterToPDFPages.getLeftFooter(), addHeaderFooterToPDFPages.getCenterFooter(), addHeaderFooterToPDFPages.getRightFooter()};
                Date date = new Date();
                String string2 = DateFormat.getDateInstance(3).format(date);
                String string3 = DateFormat.getDateInstance(1).format(date);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss a");
                String string4 = simpleDateFormat.format(date);
                simpleDateFormat = new SimpleDateFormat("HH.mm.ss");
                String string5 = simpleDateFormat.format(date);
                String string6 = new File(this.selectedFile).getName();
                BaseFont baseFont = BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
                for (int i = 1; i <= n; ++i) {
                    if (!arrayList.contains(new Integer(i))) continue;
                    String[] stringArray2 = new String[stringArray.length];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    for (int j = 0; j < 6; ++j) {
                        stringArray2[j] = stringArray2[j].replaceAll("<d>", string2);
                        stringArray2[j] = stringArray2[j].replaceAll("<D>", string3);
                        stringArray2[j] = stringArray2[j].replaceAll("<t>", string4);
                        stringArray2[j] = stringArray2[j].replaceAll("<T>", string5);
                        stringArray2[j] = stringArray2[j].replaceAll("<f>", string6);
                        stringArray2[j] = stringArray2[j].replaceAll("<F>", this.selectedFile);
                        stringArray2[j] = stringArray2[j].replaceAll("<p>", String.valueOf(i));
                        stringArray2[j] = stringArray2[j].replaceAll("<P>", String.valueOf(n));
                    }
                    PdfContentByte pdfContentByte = pdfStamper.getOverContent(i);
                    pdfContentByte.beginText();
                    pdfContentByte.setColorFill(color);
                    pdfContentByte.setFontAndSize(baseFont, (float)n2);
                    Rectangle rectangle = pdfReader.getPageSizeWithRotation(i);
                    pdfContentByte.showTextAligned(0, stringArray2[0], f, rectangle.getHeight() - f2, 0.0f);
                    pdfContentByte.showTextAligned(1, stringArray2[1], rectangle.getWidth() / 2.0f, rectangle.getHeight() - f2, 0.0f);
                    pdfContentByte.showTextAligned(2, stringArray2[2], rectangle.getWidth() - f, rectangle.getHeight() - f2, 0.0f);
                    pdfContentByte.showTextAligned(0, stringArray2[3], f, f2, 0.0f);
                    pdfContentByte.showTextAligned(1, stringArray2[4], rectangle.getWidth() / 2.0f, f2, 0.0f);
                    pdfContentByte.showTextAligned(2, stringArray2[5], rectangle.getWidth() - f, f2, 0.0f);
                    pdfContentByte.endText();
                }
                pdfStamper.close();
            }
            catch (Exception exception) {
                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                exception.printStackTrace();
                Object var28_10 = null;
                file.delete();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var28_11 = null;
            file.delete();
            throw throwable;
        }
        Object var28_9 = null;
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encrypt(int n, PdfPageData pdfPageData, EncryptPDFDocument encryptPDFDocument) {
        String string = encryptPDFDocument.getPermissions();
        int n2 = encryptPDFDocument.getEncryptionLevel();
        String string2 = encryptPDFDocument.getUserPassword();
        String string3 = encryptPDFDocument.getMasterPassword();
        int[] nArray = new int[]{2052, 8, 16, 32, 256};
        int n3 = 0;
        for (int i = 0; i < string.length(); n3 |= string.charAt(i) == '0' ? 0 : nArray[i], ++i) {
        }
        File file = null;
        try {
            file = File.createTempFile("temp", null, new File(ObjectStore.temp_dir));
            ObjectStore.copy(this.selectedFile, file.getAbsolutePath());
        }
        catch (Exception exception) {
            return;
        }
        try {
            try {
                PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
                PdfEncryptor.encrypt((PdfReader)pdfReader, (OutputStream)new FileOutputStream(this.selectedFile), (byte[])string2.getBytes(), (byte[])string3.getBytes(), (int)n3, (n2 == 0 ? 1 : 0) != 0);
            }
            catch (Exception exception) {
                ObjectStore.copy(file.getAbsolutePath(), this.selectedFile);
                exception.printStackTrace();
                Object var13_16 = null;
                file.delete();
                return;
            }
            Object var13_15 = null;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            file.delete();
            throw throwable;
        }
    }
}

