/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static Map undeletedFiles = new HashMap();
    public static boolean isMultiThreaded = false;
    private static final boolean debugCache = false;
    private static boolean checkedThisSession = false;
    private static final String separator = System.getProperty("file.separator");
    private String currentFilename = "";
    private String currentFilePath = "";
    public static String temp_dir = "";
    private String cmyk_dir = temp_dir + "cmyk" + separator;
    private String key = "jpedal" + Math.random() + '_';
    private Map image_type = new Hashtable();
    private Map tempFileNames = new HashMap();
    public static final Integer IMAGE_WIDTH = new Integer(1);
    public static final Integer IMAGE_HEIGHT = new Integer(2);
    public static final Integer IMAGE_pX = new Integer(3);
    public static final Integer IMAGE_pY = new Integer(4);
    public static long time = 14400000L;
    public String fullFileName;
    private static Map pagesOnDisk = new HashMap();
    private static Map pagesOnDiskAsBytes = new HashMap();
    private Map imagesOnDiskAsBytes = new HashMap();
    private Map imagesOnDiskAsBytesW = new HashMap();
    private Map imagesOnDiskAsBytesH = new HashMap();
    private Map imagesOnDiskAsBytespX = new HashMap();
    private Map imagesOnDiskAsBytespY = new HashMap();

    public ObjectStore() {
        try {
            if (temp_dir.length() == 0) {
                temp_dir = System.getProperty("java.io.tmpdir");
            }
            if (isMultiThreaded) {
                temp_dir = temp_dir + separator + "jpedal-" + System.currentTimeMillis() + separator;
            } else if (temp_dir.length() == 0) {
                temp_dir = temp_dir + separator + "jpedal" + separator;
            } else if (!temp_dir.endsWith(separator)) {
                temp_dir = temp_dir + separator;
            }
            File file = new File(temp_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (isMultiThreaded) {
                file.deleteOnExit();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir);
        }
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public String getCurrentFilepath() {
        return this.currentFilePath;
    }

    public final void storeFileName(String string) {
        this.fullFileName = string;
        int n = this.fullFileName.lastIndexOf("/");
        int n2 = this.fullFileName.lastIndexOf("\\");
        if (n2 > n) {
            n = n2;
        }
        this.currentFilePath = n > 0 ? this.fullFileName.substring(0, n + 1) : "";
        int n3 = string.indexOf(92);
        if (n3 == -1) {
            n3 = string.indexOf(47);
        }
        while (n3 != -1) {
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(92)) != -1) continue;
            n3 = string.indexOf(47);
        }
        int n4 = string.lastIndexOf(46);
        if (n4 != -1) {
            string = string.substring(0, n4);
        }
        string = Strip.stripAllSpaces(string);
        this.currentFilename = string.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] byArray, String string) {
        boolean bl = true;
        File file = new File(this.cmyk_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.cmyk_dir + string + ".jpg");
            this.tempFileNames.put(this.cmyk_dir + string + ".jpg", "#");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to save CMYK jpeg " + string);
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean saveStoredImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2, String string2) {
        boolean bl3 = false;
        int n = bufferedImage.getType();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (string2.indexOf("tif") != -1) {
            if (n == 1 | n == 2 && string.indexOf("HIRES_") == -1) {
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 5);
            }
            if (!bl) {
                this.image_type.put(string, "tif");
            }
            bl3 = this.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("jpg") != -1) {
            if (!bl) {
                this.image_type.put(string, "jpg");
            }
            bl3 = this.saveStoredJPEGImage(string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("png") != -1) {
            if (!bl) {
                this.image_type.put(string, "png");
            }
            bl3 = this.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, bl, bl2);
        }
        bufferedImage = null;
        return bl3;
    }

    public final String getImageType(String string) {
        return (String)this.image_type.get(string);
    }

    public final void init(String string) {
        this.key = string + System.currentTimeMillis();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final synchronized BufferedImage loadStoredImage(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.image_type.get(string);
        BufferedImage bufferedImage = null;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("tif")) {
            bufferedImage = this.loadStoredImage(string, ".tif");
        } else if (string2.equals("jpg")) {
            bufferedImage = this.loadStoredJPEGImage(string);
        } else if (string2.equals("png")) {
            bufferedImage = this.loadStoredImage(string, ".png");
        }
        return bufferedImage;
    }

    public final synchronized boolean isImageCached(String string) {
        String string2 = (String)this.image_type.get(string);
        if (string2 == null) {
            return false;
        }
        String string3 = temp_dir + this.key + string + '.' + string2;
        File file = new File(string3);
        return file.exists();
    }

    public final synchronized void flush() {
        Object object;
        Object object2;
        Iterator iterator = this.imagesOnDiskAsBytes.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 == null || !(object = new File((String)this.imagesOnDiskAsBytes.get(object2))).exists()) continue;
            object.delete();
        }
        this.imagesOnDiskAsBytes.clear();
        this.imagesOnDiskAsBytesW.clear();
        this.imagesOnDiskAsBytesH.clear();
        this.imagesOnDiskAsBytespX.clear();
        this.imagesOnDiskAsBytespY.clear();
        iterator = this.tempFileNames.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (((String)object2).indexOf(this.key) == -1) continue;
            object = new File((String)object2);
            if (object.delete()) {
                iterator.remove();
                continue;
            }
            undeletedFiles.put(this.key, "x");
        }
        try {
            if (!checkedThisSession && temp_dir.length() > 2) {
                checkedThisSession = true;
                object2 = new File(temp_dir);
                object = ((File)object2).list();
                File[] fileArray = ((File)object2).listFiles();
                if (object != null) {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        boolean bl;
                        if (object[i].indexOf(this.key) != -1) {
                            File file = new File(temp_dir + object[i]);
                            file.delete();
                        }
                        if (!(bl = true) || System.currentTimeMillis() - fileArray[i].lastModified() < time) continue;
                        fileArray[i].delete();
                    }
                }
            }
            if (((File)(object2 = new File(this.cmyk_dir))).exists()) {
                ((File)object2).delete();
                object2 = null;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " flushing files");
        }
    }

    public void copyCMYKimages(String string) {
        File file = new File(this.cmyk_dir);
        if (file.exists()) {
            String[] stringArray = file.list();
            if (stringArray.length > 0) {
                File file2;
                if (!string.endsWith(separator)) {
                    string = string + separator;
                }
                if (!(file2 = new File(string)).exists()) {
                    file2.mkdirs();
                }
                file2 = null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(this.cmyk_dir + stringArray[i]);
                File file4 = new File(string + stringArray[i]);
                file3.renameTo(file4);
            }
        }
        file = null;
    }

    private final synchronized boolean saveStoredJPEGImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        JPEGImageEncoder jPEGImageEncoder;
        BufferedOutputStream bufferedOutputStream;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            string2 = temp_dir + this.key + string;
            string3 = temp_dir + this.key + 'R' + string;
            this.image_type.put('R' + string, this.image_type.get(string));
        }
        if (!string2.toLowerCase().endsWith(".jpg") & !string2.toLowerCase().endsWith(".jpeg")) {
            string2 = string2 + ".jpg";
            string3 = string3 + ".jpg";
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            this.tempFileNames.put(string2, "#");
            bufferedOutputStream.close();
            bl4 = true;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage + " as " + string2);
        }
        if (!bl4) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
                this.tempFileNames.put(string2, "#");
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                bl3 = true;
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
        }
        if (bl2) {
            ObjectStore.saveCopy(string2, string3);
            this.tempFileNames.put(string3, "#");
        }
        return bl3;
    }

    public String getFileForCachedImage(String string) {
        return temp_dir + this.key + string + '.' + this.image_type.get(string);
    }

    private final synchronized BufferedImage loadStoredImage(String string, String string2) {
        String string3 = temp_dir + this.key + string + string2;
        BufferedImage bufferedImage = null;
        if (JAIHelper.isJAIused()) {
            try {
                JAIHelper.confirmJAIOnClasspath();
                bufferedImage = JAI.create((String)"fileload", (Object)string3).getAsBufferedImage();
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                throw new RuntimeException("Error " + error + " loading " + string + " with JAI");
            }
        } else {
            try {
                bufferedImage = ImageIO.read(new File(string3));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Error error) {
                throw new RuntimeException("Error " + error + " loading " + string + " with JAI");
            }
        }
        return bufferedImage;
    }

    private static final void saveCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
        bufferedOutputStream = null;
        bufferedInputStream = null;
    }

    public final void saveAsCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        String string3 = temp_dir + this.key + string;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    public static final void copy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        ObjectStore.copy(bufferedInputStream, bufferedOutputStream);
    }

    public static void copy(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        try {
            int n;
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    private final synchronized BufferedImage loadStoredJPEGImage(String string) {
        String string2 = temp_dir + this.key + string + ".jpg";
        BufferedImage bufferedImage = null;
        File file = new File(string2);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                bufferedImage = ImageIO.read(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + string);
            }
        } else {
            bufferedImage = new BufferedImage(100, 100, 1);
        }
        return bufferedImage;
    }

    private final synchronized boolean saveStoredImage(String string, String string2, String string3, String string4, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string5 = string4;
        String string6 = "";
        if (!bl) {
            string5 = temp_dir + this.key + string4;
            string6 = temp_dir + this.key + 'R' + string4;
            this.image_type.put('R' + string4, this.image_type.get(string4));
        }
        if (!string5.toLowerCase().endsWith(string2) & !string5.toLowerCase().endsWith(string3)) {
            string5 = string5 + string2;
            string6 = string6 + string2;
        }
        try {
            Object object;
            if (JAIHelper.isJAIused()) {
                JAIHelper.confirmJAIOnClasspath();
                JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)string);
            } else {
                ImageIO.setUseCache(false);
                object = new FileOutputStream(string5);
                if (string.equals("TIFF")) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)object);
                } else {
                    ImageIO.write((RenderedImage)bufferedImage, string, (OutputStream)object);
                }
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            object = new File(string5);
            if (((File)object).length() == 0L) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                if (JAIHelper.isJAIused()) {
                    JAIHelper.confirmJAIOnClasspath();
                    JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)string);
                } else {
                    ImageIO.setUseCache(false);
                    FileOutputStream fileOutputStream = new FileOutputStream(string5);
                    if (string.equals("TIFF")) {
                        ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
                    } else {
                        ImageIO.write((RenderedImage)bufferedImage, string, fileOutputStream);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            this.tempFileNames.put(string5, "#");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog(" Exception " + exception + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
            bufferedImage = null;
        }
        if (bl2) {
            ObjectStore.saveCopy(string5, string6);
            this.tempFileNames.put(string6, "#");
        }
        return bl3;
    }

    public static synchronized void flushPages() {
        try {
            File file;
            Object k;
            Iterator iterator = pagesOnDisk.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                if (k == null || !(file = new File((String)pagesOnDisk.get(k))).exists()) continue;
                file.delete();
            }
            pagesOnDisk.clear();
            iterator = pagesOnDiskAsBytes.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                if (k == null || !(file = new File((String)pagesOnDiskAsBytes.get(k))).exists()) continue;
                file.delete();
            }
            pagesOnDiskAsBytes.clear();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " flushing files");
        }
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.flush();
        Iterator iterator = undeletedFiles.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file = new File(string);
            if (!file.delete()) continue;
            undeletedFiles.remove(string);
        }
    }

    public static DynamicVectorRenderer getCachedPage(Integer n) {
        DynamicVectorRenderer dynamicVectorRenderer = null;
        Object v = pagesOnDisk.get(n);
        if (v != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                File file = new File((String)v);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
                dynamicVectorRenderer = new DynamicVectorRenderer(byArray, new HashMap());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return dynamicVectorRenderer;
    }

    public static void cachePage(Integer n, DynamicVectorRenderer dynamicVectorRenderer) {
        try {
            File file = File.createTempFile("page", ".bin", new File(temp_dir));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(dynamicVectorRenderer.serializeToByteArray(null));
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            pagesOnDisk.put(n, file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static byte[] getCachedPageAsBytes(String string) {
        byte[] byArray = null;
        Object v = pagesOnDiskAsBytes.get(string);
        if (v != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                File file = new File((String)v);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public static void cachePageAsBytes(String string, byte[] byArray) {
        try {
            File file = File.createTempFile("bytes", ".bin", new File(temp_dir));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            pagesOnDiskAsBytes.put(string, file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception " + exception);
        }
    }

    public void saveRawImageData(String string, byte[] byArray, int n, int n2, int n3, int n4) {
        try {
            File file = File.createTempFile("image", ".bin", new File(temp_dir));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            Integer n5 = new Integer(string);
            this.imagesOnDiskAsBytes.put(n5, file.getAbsolutePath());
            this.imagesOnDiskAsBytesW.put(n5, new Integer(n));
            this.imagesOnDiskAsBytesH.put(n5, new Integer(n2));
            this.imagesOnDiskAsBytespX.put(n5, new Integer(n3));
            this.imagesOnDiskAsBytespY.put(n5, new Integer(n4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception " + exception);
        }
    }

    public boolean isRawImageDataSaved(String string) {
        return this.imagesOnDiskAsBytes.get(new Integer(string)) != null;
    }

    public byte[] getRawImageData(String string) {
        byte[] byArray = null;
        Object v = this.imagesOnDiskAsBytes.get(new Integer(string));
        if (v != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                File file = new File((String)v);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public Object getRawImageDataParameter(String string, Integer n) {
        if (n.equals(IMAGE_WIDTH)) {
            return this.imagesOnDiskAsBytesW.get(new Integer(string));
        }
        if (n.equals(IMAGE_HEIGHT)) {
            return this.imagesOnDiskAsBytesH.get(new Integer(string));
        }
        if (n.equals(IMAGE_pX)) {
            return this.imagesOnDiskAsBytespX.get(new Integer(string));
        }
        if (n.equals(IMAGE_pY)) {
            return this.imagesOnDiskAsBytespY.get(new Integer(string));
        }
        return null;
    }
}

