/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StructuredContentHandler {
    private boolean addCoordinates = false;
    private Map markedContentProperties;
    private int markedContentLevel = 0;
    private StringBuffer markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted = false;
    private String currentKey;
    private Map keys;
    private Map values;
    private Map dictionaries;
    PdfObjectReader currentPdfFile;
    boolean buildDirectly = false;
    Document doc;
    Element root;
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public StructuredContentHandler(Object object) {
        if (object instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)object;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)object;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuffer();
        this.currentKey = "";
        this.keys = new HashMap();
        this.dictionaries = new HashMap();
    }

    public void MP() {
    }

    public void DP(PdfObject pdfObject) {
    }

    public void BDC(PdfObject pdfObject) {
        int n;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        ++this.markedContentLevel;
        if (this.buildDirectly) {
            pdfObject.setIntNumber(487790868, -1);
        }
        if ((n = pdfObject.getInt(487790868)) != -1) {
            this.keys.put(new Integer(this.markedContentLevel), "" + n);
        }
        this.dictionaries.put(String.valueOf(this.markedContentLevel), pdfObject);
    }

    public void BMC(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        this.markedContentProperties.put(new Integer(this.markedContentLevel), string);
        ++this.markedContentLevel;
        this.keys.put(new Integer(this.markedContentLevel), string);
        if (this.buildDirectly && string != null) {
            Element element = (Element)this.root.getElementsByTagName(string).item(0);
            if (element == null) {
                element = this.doc.createElement(string);
                this.root.appendChild(element);
            }
            this.root = element;
        }
    }

    public void EMC() {
        this.contentExtracted = true;
        this.currentKey = (String)this.keys.get(new Integer(this.markedContentLevel));
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
        if (this.buildDirectly) {
            boolean bl;
            PdfObject pdfObject = (PdfObject)this.dictionaries.get(this.currentKey);
            boolean bl2 = bl = pdfObject == null;
            if (bl) {
                if (this.currentKey != null) {
                    Node node;
                    Text text = this.doc.createTextNode(this.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild(text);
                    if (this.addCoordinates) {
                        this.root.setAttribute("x1", String.valueOf((int)this.x1));
                        this.root.setAttribute("y1", String.valueOf((int)this.y1));
                        this.root.setAttribute("x2", String.valueOf((int)this.x2));
                        this.root.setAttribute("y2", String.valueOf((int)this.y2));
                    }
                    if ((node = this.root.getParentNode()) instanceof Element) {
                        this.root = (Element)node;
                    }
                }
            } else {
                String string = "p";
                System.out.println("dict=" + pdfObject.getObjectRefAsString());
                if (string == null) {
                    string = "p";
                }
                Element element = this.doc.createElement(string);
                this.root.appendChild(element);
                if (this.addCoordinates) {
                    element.setAttribute("x1", String.valueOf((int)this.x1));
                    element.setAttribute("y1", String.valueOf((int)this.y1));
                    element.setAttribute("x2", String.valueOf((int)this.x2));
                    element.setAttribute("y2", String.valueOf((int)this.y2));
                }
                Text text = this.doc.createTextNode(this.markedContentSequence.toString());
                element.appendChild(text);
            }
            this.markedContentSequence = new StringBuffer();
        } else {
            String string = this.markedContentSequence.toString();
            PdfObject pdfObject = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
            int n = -1;
            if (pdfObject != null) {
                n = pdfObject.getInt(487790868);
            }
            if (n != -1) {
                this.values.put("" + n, string);
                this.markedContentSequence = new StringBuffer();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    public void setText(StringBuffer stringBuffer, float f, float f2, float f3, float f4) {
        if (this.markedContentSequence.length() == 0) {
            this.markedContentSequence = stringBuffer;
            if (this.markedContentSequence.length() > 0 && this.markedContentSequence.charAt(0) == ' ') {
                this.markedContentSequence.deleteCharAt(0);
            }
        } else {
            int n;
            int n2 = 32;
            int n3 = 32;
            if (stringBuffer.length() > 0) {
                n2 = stringBuffer.charAt(0);
            }
            if ((n = this.markedContentSequence.length() - 1) > 0) {
                n3 = this.markedContentSequence.charAt(n);
            }
            if (n3 != 45 && n2 != 45 && n2 != 46) {
                this.markedContentSequence.append(' ');
            }
            this.markedContentSequence.append(stringBuffer);
        }
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
    }

    private String stripEscapeChars(Object object) {
        int n = 32;
        StringBuffer stringBuffer = new StringBuffer((String)object);
        int n2 = stringBuffer.length();
        for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\\' && n != 92) {
                stringBuffer.deleteCharAt(i);
                --n2;
            }
            n = c;
        }
        return stringBuffer.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

