/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.BookmarkType;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class ActionsDialog
extends JDialog {
    private Bookmark bookmark;
    private ArrayList<Bookmark> actions = null;
    private final Prefs userPrefs;
    private final boolean useThousandths;
    private ActionsListModel model;
    private boolean modified = false;
    private JList actionsList;
    private JButton btnCancel;
    private JButton btnDelete;
    private JButton btnDown;
    private JButton btnOk;
    private JButton btnUp;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ActionsDialog(Frame frame, boolean bl, Bookmark bookmark) {
        super(frame, bl);
        this.initComponents();
        this.setTitle("JPdfBookmarks - " + bookmark.getTitle());
        this.userPrefs = new Prefs();
        this.useThousandths = this.userPrefs.getUseThousandths();
        this.bookmark = bookmark;
        this.actionsList.removeAll();
        this.actions = new ArrayList();
        Bookmark bookmark2 = new Bookmark();
        bookmark2.cloneDestination(this.bookmark);
        this.actions.add(bookmark2);
        this.setActionsArrayRecursive(this.bookmark);
        this.model = new ActionsListModel();
        this.actionsList.setModel(this.model);
    }

    private void setActionsArrayRecursive(Bookmark bookmark) {
        for (Bookmark bookmark2 : bookmark.getChainedBookmarks()) {
            Bookmark bookmark3 = new Bookmark();
            bookmark3.cloneDestination(bookmark2);
            this.actions.add(bookmark3);
            this.setActionsArrayRecursive(bookmark2);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.actionsList = new JList();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.btnDelete = new JButton();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("ACTIONS_PANEL_TITLE")));
        this.actionsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.actionsList);
        this.btnUp.setMnemonic(ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText").getString("UP").charAt(0));
        this.btnUp.setText(resourceBundle.getString("UP"));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog.this.btnUpActionPerformed(actionEvent);
            }
        });
        this.btnDown.setMnemonic(ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText").getString("DOWN").charAt(0));
        this.btnDown.setText(resourceBundle.getString("DOWN"));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog.this.btnDownActionPerformed(actionEvent);
            }
        });
        this.btnDelete.setMnemonic(Res.mnemonicFromRes("DELETE_MNEMONIC"));
        this.btnDelete.setText(resourceBundle.getString("ACTION_DELETE"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog.this.btnDeleteActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 348, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.btnUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 153, Short.MAX_VALUE).addComponent(this.btnDelete))).addContainerGap()));
        groupLayout.linkSize(0, this.btnDelete, this.btnDown, this.btnUp);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 195, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnUp).addComponent(this.btnDown).addComponent(this.btnDelete)).addContainerGap()));
        this.btnCancel.setMnemonic(ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText").getString("CANCEL").charAt(0));
        this.btnCancel.setText(resourceBundle.getString("CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog.this.btnCancelActionPerformed(actionEvent);
            }
        });
        this.btnOk.setMnemonic(ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText").getString("OK").charAt(0));
        this.btnOk.setText(resourceBundle.getString("OK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog.this.btnOkActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        groupLayout2.linkSize(0, this.btnCancel, this.btnOk);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void btnDeleteActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.actionsList.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.actions.remove(nArray[i]);
        }
        this.modified = true;
        this.actionsList.clearSelection();
        this.actionsList.repaint();
    }

    private void moveSelectedElements(boolean bl) {
        int[] nArray = this.actionsList.getSelectedIndices();
        if (bl) {
            int n;
            for (n = nArray.length - 1; n >= 0; --n) {
                int n2 = nArray[n];
                if (n2 >= this.actions.size() - 1) {
                    return;
                }
                Bookmark bookmark = this.actions.get(n2 + 1);
                this.actions.remove(n2 + 1);
                this.actions.add(n2, bookmark);
                this.modified = true;
            }
            n = nArray.length - 1;
            while (n >= 0) {
                int n3 = n--;
                nArray[n3] = nArray[n3] + 1;
            }
        } else {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                int n4 = nArray[n];
                if (n4 <= 0) {
                    return;
                }
                Bookmark bookmark = this.actions.get(n4);
                this.actions.remove(n4);
                this.actions.add(n4 - 1, bookmark);
                this.modified = true;
            }
            n = nArray.length - 1;
            while (n >= 0) {
                int n5 = n--;
                nArray[n5] = nArray[n5] - 1;
            }
        }
        this.actionsList.setSelectedIndices(nArray);
    }

    public boolean isBookmarkModified() {
        return this.modified;
    }

    private void btnDownActionPerformed(ActionEvent actionEvent) {
        this.moveSelectedElements(true);
        this.actionsList.repaint();
    }

    private void btnUpActionPerformed(ActionEvent actionEvent) {
        this.moveSelectedElements(false);
        this.actionsList.repaint();
    }

    private void btnCancelActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent actionEvent) {
        if (this.modified) {
            if (!this.actions.isEmpty()) {
                this.bookmark.cloneDestination(this.actions.get(0));
                this.actions.remove(0);
                this.bookmark.setChainedBookmarks(this.actions);
            } else {
                this.bookmark.setPageNumber(-1);
                this.bookmark.setType(BookmarkType.Unknown);
            }
        }
        this.dispose();
    }

    private class ActionsListModel
    extends DefaultListModel {
        @Override
        public int getSize() {
            return ActionsDialog.this.actions.size();
        }

        @Override
        public Object getElementAt(int n) {
            return ((Bookmark)ActionsDialog.this.actions.get(n)).getDescription(ActionsDialog.this.useThousandths);
        }
    }
}

