/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.mousedraggabletree.MouseDraggableTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class BookmarksTree
extends MouseDraggableTree
implements CellEditorListener {
    private Bookmark lastFollowedBookmark;
    private CellTextField editor = new CellTextField();

    public BookmarksTree() {
        BookmarkRenderer bookmarkRenderer = new BookmarkRenderer();
        this.setCellRenderer((TreeCellRenderer)((Object)bookmarkRenderer));
        CustomCellEditor customCellEditor = new CustomCellEditor(bookmarkRenderer, this.editor);
        this.setCellEditor(customCellEditor);
    }

    public void setLastFollowedBookmark(Bookmark bookmark) {
        this.lastFollowedBookmark = bookmark;
    }

    public Bookmark getLastFollowedBookmark() {
        return this.lastFollowedBookmark;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Bookmark bookmark = this.getSelectedBookmark();
        if (bookmark != null) {
            bookmark.setTitle(this.editor.getText());
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    private Bookmark getSelectedBookmark() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Bookmark bookmark = null;
        try {
            bookmark = (Bookmark)treePath.getLastPathComponent();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return bookmark;
    }

    private class BookmarkRenderer
    extends MouseDraggableTree.CustomRenderer {
        public BookmarkRenderer() {
            super((MouseDraggableTree)BookmarksTree.this);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Bookmark bookmark = null;
            if (object instanceof Bookmark) {
                bookmark = (Bookmark)object;
                int n2 = 0;
                if (bookmark.isItalic()) {
                    n2 |= 2;
                }
                if (bookmark.isBold()) {
                    n2 |= 1;
                }
                Font font = new Font(this.getFont().getFamily(), n2, this.getFont().getSize());
                this.setFont(font);
                if (bookmark.equals(BookmarksTree.this.lastFollowedBookmark)) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
                this.setForeground(bookmark.getColor());
                this.setText(bookmark.getTitle() + " ");
            }
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return component;
        }
    }

    private class CustomCellEditor
    extends DefaultCellEditor {
        private BookmarkRenderer renderer;

        public CustomCellEditor(BookmarkRenderer bookmarkRenderer, JTextField jTextField) {
            super(jTextField);
            this.renderer = bookmarkRenderer;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            JTextField jTextField = (JTextField)super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            FlowLayout flowLayout = new FlowLayout(0, 0, 0);
            JPanel jPanel = new JPanel(flowLayout);
            JLabel jLabel = new JLabel();
            if (defaultMutableTreeNode.isLeaf()) {
                jLabel.setIcon(defaultTreeCellRenderer.getLeafIcon());
            } else if (jTree.isCollapsed(treePath)) {
                jLabel.setIcon(defaultTreeCellRenderer.getClosedIcon());
            } else if (jTree.isExpanded(treePath)) {
                jLabel.setIcon(defaultTreeCellRenderer.getOpenIcon());
            }
            jPanel.setOpaque(false);
            Border border = UIManager.getBorder("Tree.editorBorder");
            jTextField.setBorder(new CompoundBorder(border, BorderFactory.createEmptyBorder(0, this.renderer.getIconTextGap(), 0, 0)));
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            return jPanel;
        }
    }

    private class CellTextField
    extends JTextField {
        private CellTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width < 100) {
                dimension.width = 100;
            }
            return dimension;
        }
    }
}

