/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.utilities.Ut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class ConnectionOptionsPanel
extends JPanel {
    Prefs userPrefs;
    ButtonGroup proxyTypeGroup = new ButtonGroup();
    private JCheckBox checkConfirmWebAccess;
    private JCheckBox checkUpdatesOnStart;
    private JCheckBox checkUseProxy;
    private JLabel lblPort;
    private JLabel lblProxyAddress;
    private JSpinner portSpinner;
    private JPanel proxyPanel;
    private JRadioButton radioHttp;
    private JRadioButton radioSocks;
    private JTextField txtProxyAddress;

    public ConnectionOptionsPanel(Prefs prefs) {
        this.userPrefs = prefs;
        this.initComponents();
        this.proxyTypeGroup.add(this.radioHttp);
        this.proxyTypeGroup.add(this.radioSocks);
        this.checkUseProxy.setSelected(prefs.getUseProxy());
        Ut.enableComponents((boolean)this.checkUseProxy.isSelected(), (JComponent[])new JComponent[]{this.radioHttp, this.radioSocks, this.txtProxyAddress, this.portSpinner, this.lblProxyAddress, this.lblPort});
        String string = prefs.getProxyType();
        if (string.equals("SOCKS")) {
            this.radioSocks.setSelected(true);
        } else {
            this.radioHttp.setSelected(true);
        }
        this.txtProxyAddress.setText(prefs.getProxyAddress());
        this.portSpinner.setValue(prefs.getProxyPort());
        this.checkUpdatesOnStart.setSelected(prefs.getCheckUpdatesOnStart());
        this.checkConfirmWebAccess.setSelected(prefs.getNeverAskWebAccess());
    }

    public boolean checkUpdatesOnStart() {
        return this.checkUpdatesOnStart.isSelected();
    }

    public boolean neverAskWebAccess() {
        return this.checkConfirmWebAccess.isSelected();
    }

    public boolean useProxy() {
        return this.checkUseProxy.isSelected();
    }

    public String getProxyType() {
        if (this.radioSocks.isSelected()) {
            return "SOCKS";
        }
        return "HTTP";
    }

    public String getProxyAddress() {
        return this.txtProxyAddress.getText().trim();
    }

    public int getProxyPort() {
        return (Integer)this.portSpinner.getValue();
    }

    private void initComponents() {
        this.checkUpdatesOnStart = new JCheckBox();
        this.proxyPanel = new JPanel();
        this.checkUseProxy = new JCheckBox();
        this.lblProxyAddress = new JLabel();
        this.txtProxyAddress = new JTextField();
        this.lblPort = new JLabel();
        this.portSpinner = new JSpinner();
        this.radioSocks = new JRadioButton();
        this.radioHttp = new JRadioButton();
        this.checkConfirmWebAccess = new JCheckBox();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.checkUpdatesOnStart.setText(resourceBundle.getString("CHECK_UPDATES_ON_START"));
        this.proxyPanel.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("PROXY_SETTINGS")));
        this.checkUseProxy.setText(resourceBundle.getString("USE_PROXY"));
        this.checkUseProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionOptionsPanel.this.checkUseProxyActionPerformed(actionEvent);
            }
        });
        this.lblProxyAddress.setText(resourceBundle.getString("PROXY_ADDRESS"));
        this.lblPort.setText(resourceBundle.getString("PROXY_PORT"));
        this.portSpinner.setModel(new SpinnerNumberModel(80, 0, 65535, 1));
        this.radioSocks.setText("SOCKS");
        this.radioHttp.setText("HTTP");
        GroupLayout groupLayout = new GroupLayout(this.proxyPanel);
        this.proxyPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.checkUseProxy)).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblProxyAddress).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.radioHttp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioSocks)).addGroup(groupLayout.createSequentialGroup().addComponent(this.txtProxyAddress, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portSpinner, -2, 96, -2))))).addContainerGap(19, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.checkUseProxy).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioHttp).addComponent(this.radioSocks)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProxyAddress).addComponent(this.txtProxyAddress, -2, -1, -2).addComponent(this.lblPort).addComponent(this.portSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.checkConfirmWebAccess.setText(resourceBundle.getString("CONFIRM_WEB_ACCESS"));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkConfirmWebAccess).addComponent(this.proxyPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent(this.checkUpdatesOnStart))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.proxyPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkUpdatesOnStart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkConfirmWebAccess).addContainerGap()));
    }

    private void checkUseProxyActionPerformed(ActionEvent actionEvent) {
        Ut.enableComponents((boolean)this.checkUseProxy.isSelected(), (JComponent[])new JComponent[]{this.radioHttp, this.radioSocks, this.txtProxyAddress, this.portSpinner, this.lblProxyAddress, this.lblPort});
    }
}

