/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.ConnectionOptionsPanel;
import it.flavianopetrocchi.jpdfbookmarks.GeneralOptionsPanel;
import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarksGui;
import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.SeparatorsPanel;
import it.flavianopetrocchi.jpdfbookmarks.ToolbarsOptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public class OptionsDlg
extends JDialog {
    public static final int GENERAL_PANEL = 0;
    public static final int PROXY_PANEL = 1;
    public static final int TOOLBARS_PANEL = 2;
    private Prefs userPrefs = new Prefs();
    private SeparatorsPanel separatorsOptions = new SeparatorsPanel(this.userPrefs);
    private ConnectionOptionsPanel connectionOptions = new ConnectionOptionsPanel(this.userPrefs);
    private ToolbarsOptionsPanel toolbarsOptions = new ToolbarsOptionsPanel(this.userPrefs);
    private GeneralOptionsPanel generalOptions = new GeneralOptionsPanel(this.userPrefs);
    private JPdfBookmarksGui gui;
    private JButton btnCancel;
    private JButton btnOk;
    private JPanel buttonsPanel;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JTabbedPane mainTabPane;
    private JPanel tabsPanel;

    public OptionsDlg(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.gui = (JPdfBookmarksGui)frame;
        this.mainTabPane.addTab(Res.getString("TAB_GENERAL_OPTIONS"), this.generalOptions);
        this.mainTabPane.setMnemonicAt(0, Res.mnemonicFromRes("TAB_GENERAL_OPTIONS_MNEMONIC"));
        this.mainTabPane.addTab(Res.getString("TAB_SEPARATOR_OPTIONS"), this.separatorsOptions);
        this.mainTabPane.setMnemonicAt(0, Res.mnemonicFromRes("TAB_SEPARATOR_OPTIONS_MNEMONIC"));
        this.mainTabPane.addTab(Res.getString("TAB_CONNECTION_OPTIONS"), this.connectionOptions);
        this.mainTabPane.setMnemonicAt(0, Res.mnemonicFromRes("TAB_CONNECTION_OPTIONS_MNEMONIC"));
        this.mainTabPane.add(Res.getString("TAB_TOOLBARS_MANAGER"), this.toolbarsOptions);
        this.pack();
    }

    public void setVisibleTab(int n) {
        this.mainTabPane.setSelectedIndex(n);
    }

    private boolean checkDifferentValuesAndEmptyValues() {
        String string = this.separatorsOptions.getPageSeparator();
        String string2 = this.separatorsOptions.getIndentationString();
        String string3 = this.separatorsOptions.getAttributesSeparator();
        if (string.equals(string2) || string.equals(string3) || string2.equals(string3)) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_DUPLICATED_VALUES"), "JPdfBookmarks", 2);
            return false;
        }
        if (string.isEmpty() || string3.isEmpty() || string2.isEmpty()) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_EMPTY_FIELD"), "JPdfBookmarks", 2);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.tabsPanel = new JPanel();
        this.mainTabPane = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("JPdfBookmarks");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setLayout(new BorderLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        this.btnCancel.setText(resourceBundle.getString("CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.btnCancelActionPerformed(actionEvent);
            }
        });
        this.btnOk.setText(resourceBundle.getString("OK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg.this.btnOkActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(475, 475, 475).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addContainerGap()));
        groupLayout.linkSize(0, this.btnCancel, this.btnOk);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainPanel.add((Component)this.buttonsPanel, "Last");
        this.tabsPanel.setLayout(new BorderLayout());
        this.tabsPanel.add((Component)this.mainTabPane, "Center");
        this.mainPanel.add((Component)this.tabsPanel, "Center");
        this.jScrollPane1.setViewportView(this.mainPanel);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent actionEvent) {
        if (!this.checkDifferentValuesAndEmptyValues()) {
            return;
        }
        String string = this.separatorsOptions.getPageSeparator();
        String string2 = this.separatorsOptions.getIndentationString();
        String string3 = this.separatorsOptions.getAttributesSeparator();
        this.userPrefs.setPageSeparator(string);
        this.userPrefs.setIndentationString(string2);
        this.userPrefs.setAttributesSeparator(string3);
        this.userPrefs.setConvertNamedDestinations(this.generalOptions.convertNamedDestinations());
        this.userPrefs.setUseThousandths(this.generalOptions.useThousandths());
        this.userPrefs.setCharsetEncoding(this.generalOptions.getCharsetEncoding());
        this.userPrefs.setNumClicks(this.generalOptions.getNumClicks());
        this.userPrefs.setUseProxy(this.connectionOptions.useProxy());
        this.userPrefs.setProxyType(this.connectionOptions.getProxyType());
        this.userPrefs.setProxyAddress(this.connectionOptions.getProxyAddress());
        this.userPrefs.setProxyPort(this.connectionOptions.getProxyPort());
        this.userPrefs.setCheckUpdatesOnStart(this.connectionOptions.checkUpdatesOnStart());
        this.userPrefs.setNeverAskWebAccess(this.connectionOptions.neverAskWebAccess());
        this.toolbarsOptions.saveToolbarPreferences();
        this.gui.updateToolbars();
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

