/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Res;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.nio.charset.Charset;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

public class Prefs {
    private Preferences userPrefs = Preferences.userNodeForPackage(this.getClass());
    private final String GPL_ACCEPTED = "GPL_ACCEPTED";
    private final String WINDOW_STATE = "WINDOW_STATE";
    private final String MAXIMIZED = "MAXIMIZED";
    private final String LAF = "LAF";
    private final String LOCATION_X = "LOCATION_X";
    private final String LOCATION_Y = "LOCATION_Y";
    private final String SPLITTER_POS = "SPLITTER_POS";
    private final String COLLAPSING_PANEL_STATE = "COLLAPSING_PANEL_STATE";
    private final String SIZE_WIDTH = "SIZE_WIDTH";
    private final String SIZE_HEIGHT = "SIZE_HEIGHT";
    private final String LAST_DIRECTORY = "LAST_DIRECTORY";
    private final String CONVERT_NAMED_DEST = "CONVERT_NAMED_DEST";
    private final String USE_THOUSANDTHS = "USE_THOUSANDTHS";
    private final String PAGE_SEPARATOR = "PAGE_SEPARATOR";
    private final String INDENT_STRING = "INDENT_STRING";
    private final String ATTRIBUTES_SEPARATOR = "ATTRIBUTES_SEPARATOR";
    private final String RECENT = "RECENT";
    private final int RECENT_FILES_NUM = 10;
    private final String PROXY_ADDRESS = "PROXY_ADDRESS";
    private final String PROXY_PORT = "PROXY_PORT";
    private final String PROXY_TYPE = "PROXY_TYPE";
    private final String USE_PROXY = "USE_PROXY";
    private final String CHECK_UPDATES_ON_START = "CHECK_UPDATES_ON_START";
    private final String CONFIRM_WEB_ACCESS = "CONFIRM_WEB_ACCESS";
    private final String PANEL_TO_SHOW = "PANEL_TO_SHOW";
    public static final String SHOW_FILE_TB = "SHOW_FILE_TB";
    public static final String SHOW_FITTYPE_TB = "SHOW_FITTYPE_TB";
    public static final String SHOW_ZOOM_TB = "SHOW_ZOOM_TB";
    public static final String SHOW_NAVIGATION_TB = "SHOW_NAVIGATION_TB";
    public static final String SHOW_OTHERS_TB = "SHOW_OTHERS_TB";
    public static final String SHOW_WEB_TB = "SHOW_WEB_TB";
    public static final String SHOW_ADD_TB = "SHOW_ADD_TB";
    public static final String SHOW_CHANGE_TB = "SHOW_CHANGE_TB";
    public static final String SHOW_STYLE_TB = "SHOW_STYLE_TB";
    public static final String SHOW_UNDO_TB = "SHOW_UNDO_TB";
    public static final String SHOW_SETDEST_TB = "SHOW_SETDEST_TB";
    public static final String CHARSET_ENCODING = "CHARSET_ENCODING";
    public static final String NUM_CLICKS = "NUM_CLICKS";
    private Dimension screenSize = null;

    Prefs() {
    }

    public String getPanelToShow() {
        return this.userPrefs.get("PANEL_TO_SHOW", Res.getString("BOOKMARKS_TAB_TITLE"));
    }

    public void setPanelToShow(String string) {
        this.userPrefs.put("PANEL_TO_SHOW", string);
    }

    public int getCollapsingPanelState() {
        return this.userPrefs.getInt("COLLAPSING_PANEL_STATE", 1);
    }

    public void setCollapsingPanelState(int n) {
        this.userPrefs.putInt("COLLAPSING_PANEL_STATE", n);
    }

    public String getCharsetEncoding() {
        return this.userPrefs.get(CHARSET_ENCODING, Charset.defaultCharset().displayName());
    }

    public void setCharsetEncoding(String string) {
        this.userPrefs.put(CHARSET_ENCODING, string);
    }

    public boolean getShowToolbar(String string) {
        return this.userPrefs.getBoolean(string, true);
    }

    public void setShowToolbar(String string, boolean bl) {
        this.userPrefs.putBoolean(string, bl);
    }

    public boolean getGplAccepted() {
        return this.userPrefs.getBoolean("GPL_ACCEPTED", false);
    }

    public void setGplAccepted(boolean bl) {
        this.userPrefs.putBoolean("GPL_ACCEPTED", bl);
    }

    public boolean getUseProxy() {
        return this.userPrefs.getBoolean("USE_PROXY", false);
    }

    public void setUseProxy(boolean bl) {
        this.userPrefs.putBoolean("USE_PROXY", bl);
    }

    public boolean getNeverAskWebAccess() {
        return this.userPrefs.getBoolean("CONFIRM_WEB_ACCESS", false);
    }

    public void setNeverAskWebAccess(boolean bl) {
        this.userPrefs.putBoolean("CONFIRM_WEB_ACCESS", bl);
    }

    public boolean getCheckUpdatesOnStart() {
        return this.userPrefs.getBoolean("CHECK_UPDATES_ON_START", true);
    }

    public void setCheckUpdatesOnStart(boolean bl) {
        this.userPrefs.putBoolean("CHECK_UPDATES_ON_START", bl);
    }

    public String getProxyType() {
        return this.userPrefs.get("PROXY_TYPE", "HTTP");
    }

    public void setProxyType(String string) {
        this.userPrefs.put("PROXY_TYPE", string);
    }

    public String getProxyAddress() {
        return this.userPrefs.get("PROXY_ADDRESS", "");
    }

    public void setProxyAddress(String string) {
        this.userPrefs.put("PROXY_ADDRESS", string);
    }

    public int getProxyPort() {
        return this.userPrefs.getInt("PROXY_PORT", 80);
    }

    public void setProxyPort(int n) {
        this.userPrefs.putInt("PROXY_PORT", n);
    }

    public String getIndentationString() {
        return this.userPrefs.get("INDENT_STRING", "\t");
    }

    public void setIndentationString(String string) {
        this.userPrefs.put("INDENT_STRING", string);
    }

    public String getPageSeparator() {
        return this.userPrefs.get("PAGE_SEPARATOR", "/");
    }

    public void setPageSeparator(String string) {
        this.userPrefs.put("PAGE_SEPARATOR", string);
    }

    public String getAttributesSeparator() {
        return this.userPrefs.get("ATTRIBUTES_SEPARATOR", ",");
    }

    public void setAttributesSeparator(String string) {
        this.userPrefs.put("ATTRIBUTES_SEPARATOR", string);
    }

    public void addRecentFile(String string) {
        int n;
        String[] stringArray = this.getRecentFiles();
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equals(stringArray[n])) continue;
            return;
        }
        this.userPrefs.put("RECENT0", string);
        for (n = 1; n < stringArray.length; ++n) {
            this.userPrefs.put("RECENT" + String.valueOf(n), stringArray[n - 1]);
        }
    }

    public String[] getRecentFiles() {
        String[] stringArray = new String[10];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.userPrefs.get("RECENT" + String.valueOf(i), "");
        }
        return stringArray;
    }

    public boolean getConvertNamedDestinations() {
        return this.userPrefs.getBoolean("CONVERT_NAMED_DEST", true);
    }

    public void setConvertNamedDestinations(boolean bl) {
        this.userPrefs.putBoolean("CONVERT_NAMED_DEST", bl);
    }

    public boolean getUseThousandths() {
        return this.userPrefs.getBoolean("USE_THOUSANDTHS", true);
    }

    public void setUseThousandths(boolean bl) {
        this.userPrefs.putBoolean("USE_THOUSANDTHS", bl);
    }

    public void setMaximized(boolean bl) {
        this.userPrefs.putBoolean("MAXIMIZED", bl);
    }

    public boolean getMaximized() {
        return this.userPrefs.getBoolean("MAXIMIZED", false);
    }

    public int getSplitterLocation() {
        return this.userPrefs.getInt("SPLITTER_POS", -1);
    }

    public void setSplitterLocation(int n) {
        this.userPrefs.putInt("SPLITTER_POS", n);
    }

    public String getLAF() {
        String string = UIManager.getSystemLookAndFeelClassName();
        return this.userPrefs.get("LAF", string);
    }

    public void setLAF(String string) {
        this.userPrefs.put("LAF", string);
    }

    public String getLastDirectory() {
        String string = System.getProperty("user.home");
        String string2 = this.userPrefs.get("LAST_DIRECTORY", string);
        return string2;
    }

    public void setLastDirectory(String string) {
        this.userPrefs.put("LAST_DIRECTORY", string);
    }

    public Point getLocation() {
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.userPrefs.getInt("LOCATION_X", (int)((double)this.screenSize.width * 0.1));
        int n2 = this.userPrefs.getInt("LOCATION_Y", (int)((double)this.screenSize.height * 0.1));
        return new Point(n, n2);
    }

    public void setLocation(Point point) {
        if (point == null) {
            this.userPrefs.remove("LOCATION_X");
            this.userPrefs.remove("LOCATION_Y");
        } else {
            this.userPrefs.putInt("LOCATION_X", point.x);
            this.userPrefs.putInt("LOCATION_Y", point.y);
        }
    }

    public void setWindowState(int n) {
        this.userPrefs.putInt("WINDOW_STATE", n);
    }

    public int getWindowState() {
        return this.userPrefs.getInt("WINDOW_STATE", 0);
    }

    public Dimension getSize() {
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.userPrefs.getInt("SIZE_WIDTH", (int)((double)this.screenSize.width * 0.8));
        int n2 = this.userPrefs.getInt("SIZE_HEIGHT", (int)((double)this.screenSize.height * 0.8));
        return new Dimension(n, n2);
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            this.userPrefs.remove("SIZE_WIDTH");
            this.userPrefs.remove("SIZE_HEIGHT");
        } else {
            this.userPrefs.putInt("SIZE_WIDTH", dimension.width);
            this.userPrefs.putInt("SIZE_HEIGHT", dimension.height);
        }
    }

    int getNumClicks() {
        return this.userPrefs.getInt(NUM_CLICKS, 2);
    }

    void setNumClicks(int n) {
        this.userPrefs.putInt(NUM_CLICKS, n);
    }
}

