/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class UnboablePageOffset
extends AbstractUndoableEdit {
    private DefaultTreeModel treeModel;
    TreePath[] paths;
    private int offset;

    public UnboablePageOffset(DefaultTreeModel defaultTreeModel, TreePath[] treePathArray, int n) {
        this.treeModel = defaultTreeModel;
        this.paths = treePathArray;
        this.offset = n;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (TreePath treePath : this.paths) {
            Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
            bookmark.setPageNumber(bookmark.getPageNumber() - this.offset);
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doEdit();
    }

    public void doEdit() {
        for (TreePath treePath : this.paths) {
            Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
            bookmark.setPageNumber(this.offset + bookmark.getPageNumber());
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
    }
}

