/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class UndoableDeleteBookmark
extends AbstractUndoableEdit {
    private DefaultTreeModel treeModel;
    private HashMap<Bookmark, ArrayList<Bookmark>> parentsMap = new HashMap();

    public UndoableDeleteBookmark(DefaultTreeModel defaultTreeModel, ArrayList<Bookmark> arrayList) {
        this.treeModel = defaultTreeModel;
        for (Bookmark bookmark : arrayList) {
            Bookmark bookmark2 = (Bookmark)bookmark.getParent();
            int n = bookmark2.getIndex((TreeNode)bookmark);
            ArrayList<Object> arrayList2 = null;
            if (this.parentsMap.containsKey(bookmark2)) {
                arrayList2 = this.parentsMap.get(bookmark2);
            } else {
                arrayList2 = new ArrayList();
                this.parentsMap.put(bookmark2, arrayList2);
            }
            if (n >= arrayList2.size()) {
                for (int i = arrayList2.size(); i < n; ++i) {
                    arrayList2.add(i, null);
                }
                arrayList2.add(n, bookmark);
                continue;
            }
            arrayList2.set(n, bookmark);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (Map.Entry<Bookmark, ArrayList<Bookmark>> entry : this.parentsMap.entrySet()) {
            Bookmark bookmark = entry.getKey();
            ArrayList<Bookmark> arrayList = entry.getValue();
            for (int i = 0; i < arrayList.size(); ++i) {
                Bookmark bookmark2 = arrayList.get(i);
                if (bookmark2 == null) continue;
                bookmark.insert((MutableTreeNode)bookmark2, i);
            }
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doEdit();
    }

    public void doEdit() {
        for (Map.Entry<Bookmark, ArrayList<Bookmark>> entry : this.parentsMap.entrySet()) {
            Bookmark bookmark = entry.getKey();
            ArrayList<Bookmark> arrayList = entry.getValue();
            for (Bookmark bookmark2 : arrayList) {
                if (bookmark2 == null) continue;
                bookmark2.removeFromParent();
            }
        }
        this.treeModel.nodeStructureChanged((TreeNode)this.treeModel.getRoot());
    }
}

