/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks.bookmark;

import it.flavianopetrocchi.colors.Colors;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.BookmarkType;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import it.flavianopetrocchi.utilities.Ut;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bookmark
extends DefaultMutableTreeNode
implements Serializable {
    protected static final String NEWLINE = System.getProperty("line.separator");
    private ArrayList<Bookmark> chainedBookmarks = new ArrayList();
    private static final int PAGE = 0;
    private static final int COLOR = 1;
    private static final int BOLD = 2;
    private static final int ITALIC = 3;
    private static final int OPEN = 4;
    private static String defaultTitle = "Bookmark";
    private String title = null;
    private static String sPage = "Page";
    private static String parseError = "PARSE ERROR:";
    private int pageNumber = -1;
    private boolean bold = false;
    private boolean italic = false;
    private Color color = Color.black;
    private int top = -1;
    private int left = -1;
    private int right = -1;
    private int bottom = -1;
    float zoom = 0.0f;
    private int thousandthsTop = -1;
    private int thousandthsLeft = -1;
    private int thousandthsBottom = -1;
    private int thousandthsRight = -1;
    private BookmarkType type = BookmarkType.FitWidth;
    private String pageSep = "/";
    private String attributeSep = ",";
    private String namedDestination = "";
    private Bookmark namedTarget;
    private boolean opened = false;
    private float pageHeight = Float.NaN;
    private float pageWidth = Float.NaN;
    private String uri;
    private String remoteFilePath;
    private String fileToLaunch;
    private boolean newWindow = true;
    private boolean remoteDestination = false;
    private boolean namedAsName = false;
    private String fieldNameToHide = null;
    private boolean hide = true;

    public Bookmark() {
        this.title = defaultTitle;
    }

    public String getFieldNameToHide() {
        return this.fieldNameToHide;
    }

    public void setFieldNameToHide(String fieldNameToHide) {
        this.fieldNameToHide = fieldNameToHide;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public static void localizeStrings(String defTitle, String page, String parseErr) {
        if (defTitle != null) {
            defaultTitle = defTitle;
        }
        if (page != null) {
            sPage = page;
        }
        if (parseError != null) {
            parseError = parseErr;
        }
    }

    public void addChainedBookmark(Bookmark bookmark) {
        this.chainedBookmarks.add(bookmark);
    }

    public boolean isNamedAsName() {
        return this.namedAsName;
    }

    public Bookmark getNamedTarget() {
        return this.namedTarget;
    }

    public void setNamedTarget(Bookmark namedTarget) {
        this.namedTarget = namedTarget;
    }

    public void setNamedAsName(boolean namedAsName) {
        this.namedAsName = namedAsName;
    }

    public boolean isRemoteDestination() {
        return this.remoteDestination;
    }

    public void setRemoteDestination(boolean remoteDestination) {
        this.remoteDestination = remoteDestination;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public void setNewWindow(boolean newWindow) {
        this.newWindow = newWindow;
    }

    public String getFileToLaunchOsDep() {
        String sys = System.getProperty("os.name");
        StringBuilder s = new StringBuilder(this.fileToLaunch);
        if (sys.startsWith("Windows") && this.fileToLaunch.startsWith("/")) {
            while (s.charAt(0) == '/') {
                s.deleteCharAt(0);
            }
            if (s.charAt(1) == '/') {
                s.insert(1, ":");
            }
        }
        return s.toString();
    }

    public String getFileToLaunch() {
        if (this.fileToLaunch == null) {
            return null;
        }
        return this.getFileToLaunchOsDep();
    }

    public void setFileToLaunch(String fileToLaunch) {
        this.fileToLaunch = fileToLaunch;
    }

    public String getRemoteFilePath() {
        return this.remoteFilePath;
    }

    public void setRemoteFilePath(String remoteFilePath) {
        this.remoteFilePath = remoteFilePath;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(float pageHeight) {
        this.pageHeight = pageHeight;
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(float pageWidth) {
        this.pageWidth = pageWidth;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public String getNamedDestination() {
        return this.namedDestination;
    }

    public void setNamedDestination(String namedDestination) {
        this.namedDestination = namedDestination;
    }

    public int getThousandthsLeft() {
        return this.thousandthsLeft;
    }

    public void setThousandthsLeft(int thousandthsLeft) {
        this.thousandthsLeft = thousandthsLeft;
    }

    public int getThousandthsTop() {
        return this.thousandthsTop;
    }

    public void setThousandthsTop(int thousandthsTop) {
        this.thousandthsTop = thousandthsTop;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public BookmarkType getType() {
        return this.type;
    }

    public void setType(BookmarkType fitType) {
        this.type = fitType;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = defaultTitle;
        }
        return this.title;
    }

    public void setTitle(String title) {
        title = title.replaceAll("\n", " ");
        title = title.replaceAll("\r", " ");
        this.title = title = title.trim();
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void clearChainedBookmarks() {
        this.chainedBookmarks.clear();
    }

    public static Bookmark cloneBookmark(Bookmark bookmarkToClone, boolean copyChildren) {
        Bookmark clonedBookmark = new Bookmark();
        clonedBookmark.cloneAppearance(bookmarkToClone);
        clonedBookmark.cloneDestination(bookmarkToClone);
        if (copyChildren) {
            Bookmark.cloneBookmarkWithChildren(clonedBookmark, bookmarkToClone);
        }
        return clonedBookmark;
    }

    private static void cloneBookmarkWithChildren(Bookmark father, Bookmark bookmarkToClone) {
        Enumeration<TreeNode> e = bookmarkToClone.children();
        while (e.hasMoreElements()) {
            Bookmark child = (Bookmark)e.nextElement();
            Bookmark clonedChild = new Bookmark();
            clonedChild.cloneAppearance(child);
            clonedChild.cloneDestination(child);
            father.add(clonedChild);
            Bookmark.cloneBookmarkWithChildren(clonedChild, child);
        }
    }

    public void cloneAppearance(Bookmark bookmark) {
        this.setTitle(bookmark.getTitle());
        this.setColor(bookmark.getColor());
        this.setItalic(bookmark.isItalic());
        this.setBold(bookmark.isBold());
        this.setOpened(bookmark.isOpened());
    }

    public void cloneDestination(Bookmark bookmark) {
        this.setType(bookmark.getType());
        this.setPageNumber(bookmark.getPageNumber());
        this.setTop(bookmark.getTop());
        this.setLeft(bookmark.getLeft());
        this.setRight(bookmark.getRight());
        this.setBottom(bookmark.getBottom());
        this.setZoom(bookmark.getZoom());
        this.setFileToLaunch(bookmark.getFileToLaunch());
        this.setNamedAsName(bookmark.isNamedAsName());
        this.setNamedDestination(bookmark.getNamedDestination());
        Bookmark target = bookmark.getNamedTarget();
        if (target != null) {
            Bookmark copiedTarget = Bookmark.cloneBookmark(target, false);
            this.setNamedTarget(copiedTarget);
        }
        this.setNewWindow(bookmark.isNewWindow());
        this.setRemoteDestination(bookmark.isRemoteDestination());
        this.setRemoteFilePath(bookmark.getRemoteFilePath());
        this.setUri(bookmark.getUri());
        this.setThousandthsBottom(bookmark.getThousandthsBottom());
        this.setThousandthsRight(bookmark.getThousandthsRight());
        this.setThousandthsTop(bookmark.getThousandthsTop());
        this.setThousandthsLeft(bookmark.getThousandthsLeft());
        this.setFieldNameToHide(bookmark.getFieldNameToHide());
        this.setHide(bookmark.isHide());
        this.chainedBookmarks.clear();
        ArrayList<Bookmark> chainedBookmarksToCopy = bookmark.getChainedBookmarks();
        this.chainedBookmarks.ensureCapacity(chainedBookmarksToCopy.size());
        for (Bookmark b : chainedBookmarksToCopy) {
            Bookmark copy = new Bookmark();
            copy.cloneDestination(b);
            this.chainedBookmarks.add(copy);
        }
    }

    public String getDescription(boolean useThousandths) {
        String extendedDescr = this.getExtendedDescription(null, null, null, useThousandths);
        StringBuilder buffer = new StringBuilder(extendedDescr);
        int firstNewLineIndex = buffer.indexOf(NEWLINE);
        if (firstNewLineIndex != -1) {
            buffer.delete(firstNewLineIndex, buffer.length());
        }
        if (this.isRemoteDestination()) {
            String filePath = this.getRemoteFilePath();
            int filePathIndex = buffer.lastIndexOf(filePath);
            buffer = new StringBuilder(buffer.substring(0, filePathIndex));
        }
        int pageSepIndex = Bookmark.findPageSepIndex(buffer.toString(), this.attributeSep, this.pageSep);
        StringTokenizer tokenizer = new StringTokenizer(buffer.substring(pageSepIndex + this.pageSep.length()), this.attributeSep);
        String[] attributes = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            attributes[i] = tokenizer.nextToken();
            ++i;
        }
        buffer = new StringBuilder(sPage).append(" ").append(attributes[0]).append("  ");
        boolean goToFileReached = false;
        for (int i2 = 5; i2 < attributes.length; ++i2) {
            buffer.append(attributes[i2]).append(" ");
            if (!attributes[i2].equalsIgnoreCase("GoToFile")) continue;
            goToFileReached = true;
            break;
        }
        if (goToFileReached) {
            buffer.append('\"');
            buffer.append(this.getRemoteFilePath());
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public String getExtendedDescriptionNoTitle(String prepend, String pageSeparator, String attributeSeparator, boolean useThousandths) {
        if (pageSeparator == null) {
            pageSeparator = this.pageSep;
        }
        if (attributeSeparator == null) {
            attributeSeparator = this.attributeSep;
        }
        StringBuilder buffer = new StringBuilder(pageSeparator);
        buffer.append(this.pageNumber);
        buffer.append(attributeSeparator);
        buffer.append(Colors.colorToString((Color)this.color));
        buffer.append(attributeSeparator);
        if (this.bold) {
            buffer.append("bold");
        } else {
            buffer.append("notBold");
        }
        buffer.append(attributeSeparator);
        if (this.italic) {
            buffer.append("italic");
        } else {
            buffer.append("notItalic");
        }
        buffer.append(attributeSeparator);
        if (this.opened) {
            buffer.append("open");
        } else {
            buffer.append("closed");
        }
        buffer.append(attributeSeparator);
        buffer.append((Object)this.type);
        if (this.type != BookmarkType.FitPage && this.type != BookmarkType.Unknown && this.type != BookmarkType.FitContent) {
            buffer.append(attributeSeparator);
        }
        if (this.type == BookmarkType.FitWidth) {
            if (useThousandths) {
                buffer.append(this.thousandthsTop);
            } else {
                buffer.append(this.top);
            }
        } else if (this.type == BookmarkType.FitContentWidth) {
            if (useThousandths) {
                buffer.append(this.thousandthsTop);
            } else {
                buffer.append(this.top);
            }
        } else if (this.type == BookmarkType.FitHeight) {
            if (useThousandths) {
                buffer.append(this.thousandthsLeft);
            } else {
                buffer.append(this.left);
            }
        } else if (this.type == BookmarkType.FitContentHeight) {
            if (useThousandths) {
                buffer.append(this.thousandthsLeft);
            } else {
                buffer.append(this.left);
            }
        } else if (this.type == BookmarkType.TopLeft) {
            if (useThousandths) {
                buffer.append(this.thousandthsTop);
                buffer.append(attributeSeparator);
                buffer.append(this.thousandthsLeft);
            } else {
                buffer.append(this.top);
                buffer.append(attributeSeparator);
                buffer.append(this.left);
            }
        } else if (this.type == BookmarkType.TopLeftZoom) {
            if (useThousandths) {
                buffer.append(this.thousandthsTop);
                buffer.append(attributeSeparator);
                buffer.append(this.thousandthsLeft);
            } else {
                buffer.append(this.top);
                buffer.append(attributeSeparator);
                buffer.append(this.left);
            }
            buffer.append(attributeSeparator);
            buffer.append(this.zoom);
        } else if (this.type == BookmarkType.FitRect) {
            if (useThousandths) {
                buffer.append(this.thousandthsTop);
                buffer.append(attributeSeparator);
                buffer.append(this.thousandthsLeft);
                buffer.append(attributeSeparator);
                buffer.append(this.thousandthsBottom);
                buffer.append(attributeSeparator);
                buffer.append(this.thousandthsRight);
            } else {
                buffer.append(this.top);
                buffer.append(this.left);
                buffer.append(this.bottom);
                buffer.append(this.right);
            }
        } else if (this.type == BookmarkType.Named) {
            buffer.append(this.namedDestination);
        } else if (this.type == BookmarkType.Uri) {
            buffer.append(this.uri);
        } else if (this.type == BookmarkType.Launch) {
            buffer.append(this.getFileToLaunch());
        } else if (this.type == BookmarkType.Hide) {
            buffer.append(this.getFieldNameToHide());
            buffer.append(attributeSeparator);
            buffer.append(this.isHide());
        } else if (this.type == BookmarkType.GoToFile) {
            // empty if block
        }
        if (this.isRemoteDestination()) {
            buffer.append(attributeSeparator);
            buffer.append(BookmarkType.GoToFile.toString());
            buffer.append(attributeSeparator);
            buffer.append(this.remoteFilePath);
        }
        if (!this.chainedBookmarks.isEmpty()) {
            String newLine = System.getProperty("line.separator");
            for (Bookmark b : this.chainedBookmarks) {
                buffer.append(newLine);
                buffer.append(prepend);
                buffer.append(b.getExtendedDescriptionNoTitle(prepend, pageSeparator, attributeSeparator, useThousandths));
            }
        }
        return buffer.toString();
    }

    public ArrayList<Bookmark> getChainedBookmarks() {
        return this.chainedBookmarks;
    }

    public void setChainedBookmarks(ArrayList<Bookmark> chained) {
        this.chainedBookmarks = chained;
    }

    public String getExtendedDescription(String indentationForHierarchy, String pageSeparator, String attributeSeparator, boolean useThousandths) {
        StringBuilder indentToAlignChainedBookmark = new StringBuilder();
        if (indentationForHierarchy != null) {
            indentToAlignChainedBookmark.append(indentationForHierarchy);
        }
        for (int i = 0; i < this.title.length(); ++i) {
            indentToAlignChainedBookmark.append(" ");
        }
        return this.title + this.getExtendedDescriptionNoTitle(indentToAlignChainedBookmark.toString(), pageSeparator, attributeSeparator, useThousandths);
    }

    private static boolean isBetweenAttributesSeparator(String line, String token, int tokenIndex, String attributesSeparator) {
        char c;
        int i;
        boolean betweenAttributesSeparator = false;
        for (i = tokenIndex + token.length(); i < line.length(); ++i) {
            c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (!line.substring(i, i + attributesSeparator.length()).equals(attributesSeparator)) break;
            betweenAttributesSeparator = true;
            break;
        }
        for (i = tokenIndex; i >= 0; --i) {
            c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (!line.substring(i - attributesSeparator.length() + 1, i).equals(attributesSeparator)) break;
            betweenAttributesSeparator = true;
            break;
        }
        return betweenAttributesSeparator;
    }

    private static int findProblematicBookmarksTypesIndex(String line, String attributesSeparator) {
        String type;
        String[] types = new String[]{BookmarkType.GoToFile.toString(), BookmarkType.Launch.toString(), BookmarkType.Uri.toString()};
        int typeIndex = -1;
        String[] arr$ = types;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (typeIndex = line.lastIndexOf(type = arr$[i$])) != -1 && Bookmark.isBetweenAttributesSeparator(line, type, typeIndex, attributesSeparator)); ++i$) {
            typeIndex = -1;
        }
        return typeIndex;
    }

    private static int findPageSepIndex(String line, String attributesSeparator, String pageSeparator) {
        int lastCharToScan = Bookmark.findProblematicBookmarksTypesIndex(line, attributesSeparator);
        int pageSepIndex = lastCharToScan != -1 ? line.substring(0, lastCharToScan).lastIndexOf(pageSeparator) : line.lastIndexOf(pageSeparator);
        return pageSepIndex;
    }

    public static Bookmark bookmarkFromString(Bookmark chainedBookmarkFather, IBookmarksConverter converter, String line, String indentation, String pageSeparator, String attributesSeparator) {
        boolean wellFormed = true;
        Bookmark bookmark = new Bookmark();
        StringBuilder sbLine = new StringBuilder(line);
        while (line.startsWith(indentation)) {
            sbLine.delete(0, indentation.length());
            line = sbLine.toString();
        }
        int pageSepIndex = Bookmark.findPageSepIndex(line, attributesSeparator, pageSeparator);
        String title = line;
        String attributes = null;
        if (pageSepIndex != -1) {
            title = line.substring(0, pageSepIndex);
            attributes = line.substring(pageSepIndex + pageSeparator.length());
        } else {
            wellFormed = false;
        }
        bookmark.setTitle(title.trim());
        if (attributes == null) {
            return bookmark;
        }
        StringTokenizer tokenizer = new StringTokenizer(attributes, attributesSeparator);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        try {
            bookmark.setPageNumber(Integer.parseInt(tokens[0]));
        }
        catch (Exception e) {
            wellFormed = false;
        }
        if (tokens.length < 2) {
            return bookmark;
        }
        boolean shortFormat = false;
        BookmarkType type = BookmarkType.FitWidth;
        try {
            type = BookmarkType.valueOf(tokens[1].trim());
            shortFormat = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        int typeIndex = 1;
        if (!shortFormat) {
            try {
                bookmark.setColor(Colors.stringToColor((String)tokens[1].trim()));
                bookmark.setBold(tokens[2].trim().equalsIgnoreCase("bold"));
                bookmark.setItalic(tokens[3].trim().equalsIgnoreCase("italic"));
                bookmark.setOpened(tokens[4].trim().equalsIgnoreCase("open"));
                type = BookmarkType.valueOf(tokens[5].trim());
            }
            catch (Exception e) {
                wellFormed = false;
            }
            typeIndex = 5;
        }
        bookmark.setType(type);
        switch (type) {
            case FitWidth: 
            case FitContentWidth: {
                try {
                    bookmark.setThousandthsTop(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setTop(Bookmark.verticalFromThousandths(bookmark.getThousandthsTop(), converter.getPageHeight(bookmark.getPageNumber())));
                }
                catch (NumberFormatException e) {
                    wellFormed = false;
                }
                catch (Exception e) {}
                break;
            }
            case FitHeight: 
            case FitContentHeight: {
                try {
                    bookmark.setThousandthsLeft(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setLeft(Bookmark.horizontalFromThousandths(bookmark.getThousandthsLeft(), converter.getPageWidth(bookmark.getPageNumber())));
                }
                catch (NumberFormatException e) {
                    wellFormed = false;
                }
                catch (Exception e) {}
                break;
            }
            case TopLeft: 
            case TopLeftZoom: {
                try {
                    bookmark.setThousandthsTop(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setTop(Bookmark.verticalFromThousandths(bookmark.getThousandthsTop(), converter.getPageHeight(bookmark.getPageNumber())));
                    bookmark.setThousandthsLeft(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setLeft(Bookmark.horizontalFromThousandths(bookmark.getThousandthsLeft(), converter.getPageWidth(bookmark.getPageNumber())));
                    bookmark.setZoom(Float.parseFloat(tokens[++typeIndex]));
                }
                catch (NumberFormatException e) {
                    wellFormed = false;
                }
                catch (Exception e) {}
                break;
            }
            case FitRect: {
                try {
                    bookmark.setThousandthsTop(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setTop(Bookmark.verticalFromThousandths(bookmark.getThousandthsTop(), converter.getPageHeight(bookmark.getPageNumber())));
                    bookmark.setThousandthsLeft(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setLeft(Bookmark.horizontalFromThousandths(bookmark.getThousandthsLeft(), converter.getPageWidth(bookmark.getPageNumber())));
                    bookmark.setThousandthsBottom(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setBottom(Bookmark.verticalFromThousandths(bookmark.getThousandthsBottom(), converter.getPageHeight(bookmark.getPageNumber())));
                    bookmark.setThousandthsRight(Integer.parseInt(tokens[++typeIndex]));
                    bookmark.setRight(Bookmark.horizontalFromThousandths(bookmark.getThousandthsRight(), converter.getPageWidth(bookmark.getPageNumber())));
                }
                catch (NumberFormatException e) {
                    wellFormed = false;
                }
                catch (Exception e) {}
                break;
            }
            case Named: {
                try {
                    bookmark.setNamedDestination(tokens[++typeIndex].trim());
                }
                catch (Exception e) {
                    wellFormed = false;
                }
                break;
            }
            case Uri: {
                try {
                    bookmark.setUri(tokens[++typeIndex].trim());
                }
                catch (Exception e) {
                    wellFormed = false;
                }
                break;
            }
            case Launch: {
                try {
                    bookmark.setFileToLaunch(tokens[++typeIndex].trim());
                }
                catch (Exception e) {
                    wellFormed = false;
                }
                break;
            }
            case Hide: {
                try {
                    bookmark.setFieldNameToHide(tokens[++typeIndex].trim());
                    bookmark.setHide(!tokens[++typeIndex].trim().equalsIgnoreCase("false"));
                    break;
                }
                catch (Exception e) {
                    wellFormed = false;
                }
            }
        }
        try {
            if (tokens[++typeIndex].trim().equalsIgnoreCase(BookmarkType.GoToFile.toString())) {
                bookmark.setRemoteDestination(true);
                StringBuilder remotePath = new StringBuilder();
                remotePath.append(tokens[++typeIndex]);
                for (int i2 = ++typeIndex; i2 < tokens.length; ++i2) {
                    remotePath.append(attributesSeparator);
                    remotePath.append(tokens[i2]);
                }
                bookmark.setRemoteFilePath(remotePath.toString().trim());
                IBookmarksConverter remoteFileConverter = Bookmark.getBookmarksConverter();
                if (remoteFileConverter != null) {
                    try {
                        File absoluteRemoteFile = Ut.createAbsolutePath((File)new File(converter.getOpenedFilePath()), (File)new File(bookmark.getRemoteFilePath()));
                        remoteFileConverter.open(absoluteRemoteFile.getAbsolutePath());
                        bookmark.setTop(Bookmark.verticalFromThousandths(bookmark.getThousandthsTop(), remoteFileConverter.getPageHeight(bookmark.getPageNumber())));
                        bookmark.setBottom(Bookmark.verticalFromThousandths(bookmark.getThousandthsBottom(), remoteFileConverter.getPageHeight(bookmark.getPageNumber())));
                        bookmark.setLeft(Bookmark.horizontalFromThousandths(bookmark.getThousandthsLeft(), remoteFileConverter.getPageWidth(bookmark.getPageNumber())));
                        bookmark.setRight(Bookmark.horizontalFromThousandths(bookmark.getThousandthsRight(), remoteFileConverter.getPageWidth(bookmark.getPageNumber())));
                        remoteFileConverter.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!wellFormed) {
            bookmark.setColor(Color.red);
            bookmark.setTitle(parseError + " " + bookmark.getTitle());
        }
        if (bookmark.getTitle().isEmpty() && chainedBookmarkFather != null) {
            chainedBookmarkFather.addChainedBookmark(bookmark);
            return null;
        }
        return bookmark;
    }

    public static Bookmark outlineFromFile(IBookmarksConverter converter, String bookmarksFile, String indentation, String pageSeparator, String attributesSeparator, String charset) throws FileNotFoundException, IOException {
        String line;
        ArrayList<Bookmark> fathers = new ArrayList<Bookmark>(8);
        Bookmark newOutline = new Bookmark();
        fathers.add(newOutline);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bookmarksFile), charset));
        int fatherIndex = 0;
        int newFatherIndex = 1;
        Bookmark current = null;
        Bookmark father = null;
        Bookmark chainedBookmarkFather = null;
        int numLine = 0;
        while ((line = br.readLine()) != null) {
            ++numLine;
            if ((line = Ut.rtrim((String)line)).isEmpty() || (current = Bookmark.bookmarkFromString(chainedBookmarkFather, converter, line, indentation, pageSeparator, attributesSeparator)) == null) continue;
            fatherIndex = line.lastIndexOf(indentation) <= 0 ? line.lastIndexOf(indentation) + 1 : line.lastIndexOf(indentation) / indentation.length() + 1;
            newFatherIndex = fatherIndex + 1;
            father = fatherIndex >= fathers.size() ? (Bookmark)fathers.get(fathers.size() - 1) : (Bookmark)fathers.get(fatherIndex);
            father.add(current);
            chainedBookmarkFather = current;
            if (newFatherIndex < fathers.size()) {
                fathers.remove(newFatherIndex);
                fathers.add(newFatherIndex, current);
                continue;
            }
            fathers.add(current);
        }
        br.close();
        return newOutline;
    }

    public static IBookmarksConverter getBookmarksConverter() {
        ServiceLoader<IBookmarksConverter> s = ServiceLoader.load(IBookmarksConverter.class);
        Iterator<IBookmarksConverter> i = s.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public static Bookmark outlineFromBufferedReader(IBookmarksConverter converter, BufferedReader br, String indentation, String pageSeparator, String attributesSeparator) throws IOException {
        String line;
        ArrayList<Bookmark> fathers = new ArrayList<Bookmark>(8);
        Bookmark newOutline = new Bookmark();
        fathers.add(newOutline);
        int fatherIndex = 0;
        int newFatherIndex = 1;
        Bookmark current = null;
        Bookmark father = null;
        int numLine = 0;
        while ((line = br.readLine()) != null) {
            ++numLine;
            if ((line = Ut.rtrim((String)line)).isEmpty()) continue;
            fatherIndex = line.lastIndexOf(indentation) <= 0 ? line.lastIndexOf(indentation) + 1 : line.lastIndexOf(indentation) / indentation.length() + 1;
            newFatherIndex = fatherIndex + 1;
            current = Bookmark.bookmarkFromString(current, converter, line, indentation, pageSeparator, attributesSeparator);
            father = fatherIndex >= fathers.size() ? (Bookmark)fathers.get(fathers.size() - 1) : (Bookmark)fathers.get(fatherIndex);
            father.add(current);
            if (newFatherIndex < fathers.size()) {
                fathers.remove(newFatherIndex);
                fathers.add(newFatherIndex, current);
                continue;
            }
            fathers.add(current);
        }
        br.close();
        return newOutline;
    }

    public static Bookmark outlineFromString(IBookmarksConverter converter, String bookmarks, String indentation, String pageSeparator, String attributesSeparator) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(bookmarks));
        return Bookmark.outlineFromBufferedReader(converter, br, indentation, pageSeparator, attributesSeparator);
    }

    @Override
    public String toString() {
        return this.title;
    }

    public void setThousandthsRight(int thousandthsHorizontal) {
        this.thousandthsRight = thousandthsHorizontal;
    }

    public void setThousandthsBottom(int thousandthsVertical) {
        this.thousandthsBottom = thousandthsVertical;
    }

    private int getThousandthsBottom() {
        return this.thousandthsBottom;
    }

    private int getThousandthsRight() {
        return this.thousandthsRight;
    }

    public static int thousandthsHorizontal(int x, float width) {
        int thousandths = -1;
        if (x != -1) {
            try {
                thousandths = (int)((float)x * 1000.0f / width);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return thousandths;
    }

    public static int thousandthsVertical(int y, float height) {
        int thousandths = -1;
        if (y != -1) {
            try {
                thousandths = 1000 - Math.round((float)y * 1000.0f / height);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return thousandths;
    }

    public static int verticalFromThousandths(int thousandths, float height) {
        return thousandths == -1 ? -1 : Math.round((float)(1000 - thousandths) * height / 1000.0f);
    }

    public static int horizontalFromThousandths(int thousandths, float width) {
        return thousandths == -1 ? -1 : Math.round((float)thousandths * width / 1000.0f);
    }

    public void setRemoteFilePathWithChildren(File file) {
        String path = Ut.onWindowsReplaceBackslashWithSlash((String)file.getPath());
        Enumeration<TreeNode> e = this.preorderEnumeration();
        while (e.hasMoreElements()) {
            Bookmark b = (Bookmark)e.nextElement();
            this.setRemoteTarget(b, path);
        }
    }

    private void setRemoteTarget(Bookmark b, String path) {
        if (b.type != BookmarkType.Launch && b.type != BookmarkType.Uri && !b.isRemoteDestination()) {
            b.setRemoteDestination(true);
            b.setRemoteFilePath(path);
        }
        for (Bookmark chained : b.getChainedBookmarks()) {
            this.setRemoteTarget(chained, path);
        }
    }
}

