/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks.itextbookmarksconverter;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.BookmarkType;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import it.flavianopetrocchi.utilities.Ut;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class iTextBookmarksConverter
implements IBookmarksConverter {
    private PdfReader reader;
    private PdfStamper stamper;
    private Bookmark rootBookmark;
    private String filePath;
    private List outline;
    private boolean showOnOpen = false;
    private HashMap namesAsString;
    private HashMap namesAsName;
    private IntHashtable pages;

    public iTextBookmarksConverter() {
    }

    public iTextBookmarksConverter(String string) throws IOException {
        this.open(string);
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
        this.stamper = null;
        this.outline = null;
        this.rootBookmark = null;
        this.filePath = null;
        this.namesAsString = null;
    }

    public Bookmark getRootBookmark(boolean convertNamedDestinations) {
        if (this.rootBookmark == null) {
            if (convertNamedDestinations) {
                this.reader.consolidateNamedDestinations();
            }
            this.rootBookmark = this.getBookmark();
        }
        return this.rootBookmark;
    }

    public boolean isEncryped() {
        return this.reader.isEncrypted();
    }

    public final void open(String pdfPath) throws IOException {
        this.open(pdfPath, null);
    }

    public void open(String pdfPath, byte[] password) throws IOException {
        if (this.reader != null) {
            this.close();
        }
        this.filePath = pdfPath;
        this.reader = password != null ? new PdfReader(pdfPath, password) : new PdfReader(pdfPath);
        int preferences = this.reader.getSimpleViewerPreferences();
        this.showOnOpen = (preferences & 0x80) != 0;
    }

    public boolean isBookmarksEditingPermitted() {
        return this.reader.isOpenedWithFullPermissions();
    }

    public void rebuildBookmarksFromTreeNodes(Bookmark root) {
        Bookmark current;
        try {
            current = (Bookmark)root.getFirstChild();
        }
        catch (Exception exc) {
            current = null;
        }
        this.outline = new ArrayList();
        while (current != null) {
            this.outline.add(this.rebuildBookmarksRecursive(current));
            current = (Bookmark)current.getNextSibling();
        }
    }

    private HashMap rebuildBookmarksRecursive(Bookmark node) {
        Bookmark current;
        HashMap bookmarkMap = this.bookmarkToHashMap(node);
        try {
            current = (Bookmark)node.getFirstChild();
        }
        catch (Exception exc) {
            current = null;
        }
        ArrayList<HashMap> kids = new ArrayList<HashMap>();
        while (current != null) {
            HashMap childMap = this.rebuildBookmarksRecursive(current);
            if (childMap != null) {
                kids.add(childMap);
            }
            current = (Bookmark)current.getNextSibling();
        }
        if (!kids.isEmpty()) {
            bookmarkMap.put("Kids", kids);
        }
        return bookmarkMap;
    }

    private HashMap bookmarkToHashMap(Bookmark bookmark) {
        BookmarkType type;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", bookmark.getTitle().trim());
        if (bookmark.isOpened()) {
            map.put("Open", "true");
        } else {
            map.put("Open", "false");
        }
        if (!bookmark.getColor().equals(Color.black)) {
            float[] rgb = bookmark.getColor().getRGBColorComponents(null);
            map.put("Color", String.valueOf(rgb[0]) + " " + String.valueOf(rgb[1]) + " " + String.valueOf(rgb[2]));
        }
        String style = "";
        if (bookmark.isBold()) {
            style = style + "bold ";
        }
        if (bookmark.isItalic()) {
            style = style + "italic ";
        }
        if (!style.isEmpty()) {
            map.put("Style", style.trim());
        }
        if ((type = bookmark.getType()) == BookmarkType.Launch) {
            map.put("Action", "Launch");
            map.put("File", bookmark.getFileToLaunch());
        } else if (type == BookmarkType.Uri) {
            map.put("Action", "URI");
            map.put("URI", bookmark.getUri());
        } else if (type == BookmarkType.Hide) {
            map.put("Action", "Hide");
            map.put("FieldName", bookmark.getFieldNameToHide());
            map.put("Hide", String.valueOf(bookmark.isHide()));
        } else if (type != BookmarkType.Unknown) {
            if (bookmark.isRemoteDestination()) {
                map.put("Action", "GoToR");
                String path = Ut.onWindowsReplaceBackslashWithSlash((String)bookmark.getRemoteFilePath());
                map.put("File", path);
                map.put("NewWindow", String.valueOf(bookmark.isNewWindow()));
            } else {
                map.put("Action", "GoTo");
            }
            if (type == BookmarkType.Named) {
                if (bookmark.isNamedAsName()) {
                    map.put("NamedN", bookmark.getNamedDestination());
                } else {
                    map.put("Named", bookmark.getNamedDestination());
                }
            } else {
                StringBuilder pageDest = new StringBuilder();
                if (bookmark.isRemoteDestination()) {
                    pageDest.append(String.valueOf(bookmark.getPageNumber() - 1));
                } else {
                    pageDest.append(String.valueOf(bookmark.getPageNumber()));
                }
                int left = bookmark.getLeft();
                int right = bookmark.getRight();
                int top = bookmark.getTop();
                int bottom = bookmark.getBottom();
                float zoom = bookmark.getZoom();
                if (type == BookmarkType.TopLeftZoom) {
                    pageDest.append(" XYZ ");
                    pageDest.append(left == -1 ? "null" : Integer.valueOf(left)).append(" ");
                    pageDest.append(top == -1 ? "null" : Integer.valueOf(top)).append(" ").append(zoom);
                } else if (type == BookmarkType.FitPage) {
                    pageDest.append(" Fit");
                } else if (type == BookmarkType.FitWidth) {
                    pageDest.append(" FitH ").append(top == -1 ? "null" : Integer.valueOf(top));
                } else if (type == BookmarkType.FitHeight) {
                    pageDest.append(" FitV ").append(left == -1 ? "null" : Integer.valueOf(left));
                } else if (type == BookmarkType.FitRect) {
                    pageDest.append(" FitR ").append(left == -1 ? "null" : Integer.valueOf(left)).append(" ").append(bottom == -1 ? "null" : Integer.valueOf(bottom)).append(" ").append(right == -1 ? "null" : Integer.valueOf(right)).append(" ").append(top == -1 ? "null" : Integer.valueOf(top));
                } else if (type == BookmarkType.FitContent) {
                    pageDest.append(" FitB");
                } else if (type == BookmarkType.FitContentWidth) {
                    pageDest.append(" FitBH ").append(top == -1 ? "null" : Integer.valueOf(top));
                } else if (type == BookmarkType.FitContentHeight) {
                    pageDest.append(" FitBV ").append(left == -1 ? "null" : Integer.valueOf(left));
                }
                map.put("Page", pageDest.toString());
            }
        }
        ArrayList chainedBookmarks = bookmark.getChainedBookmarks();
        if (!chainedBookmarks.isEmpty()) {
            ArrayList<HashMap> chainedBookmarksMap = new ArrayList<HashMap>();
            for (Bookmark b : chainedBookmarks) {
                chainedBookmarksMap.add(this.bookmarkToHashMap(b));
            }
            map.put("Next", chainedBookmarksMap);
        }
        return map;
    }

    public void createUnencryptedCopy(File tmpFile) throws IOException {
        try {
            PdfStamper tmpStamper = new PdfStamper(this.reader, (OutputStream)new FileOutputStream(tmpFile));
            tmpStamper.close();
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public void save(String filePath) throws IOException {
        this.save(filePath, null);
    }

    public void save(String filePath, byte[] ownerPassword) throws IOException {
        this.save(filePath, null, null);
    }

    public void save(String path, byte[] userPassword, byte[] ownerPassword) throws IOException {
        try {
            File tmp = File.createTempFile("jpdf", ".pdf");
            tmp.deleteOnExit();
            Ut.copyFile((String)this.filePath, (String)tmp.getPath());
            PdfReader tmpReader = ownerPassword != null ? new PdfReader(tmp.getPath(), ownerPassword) : (userPassword != null ? new PdfReader(tmp.getPath(), userPassword) : new PdfReader(tmp.getPath()));
            this.stamper = new PdfStamper(tmpReader, (OutputStream)new FileOutputStream(path));
            if (this.outline != null) {
                this.stamper.setOutlines(this.outline);
            }
            int preferences = this.reader.getSimpleViewerPreferences();
            preferences = this.showOnOpen ? (preferences |= 0x80) : (preferences &= 0xFFFFFF7F);
            this.stamper.setViewerPreferences(preferences);
            if (ownerPassword != null || userPassword != null) {
                if (ownerPassword == null && userPassword != null) {
                    ownerPassword = userPassword;
                }
                this.stamper.setEncryption(userPassword, ownerPassword, tmpReader.getPermissions(), tmpReader.getCryptoMode());
            }
            this.stamper.close();
            tmp.delete();
        }
        catch (DocumentException ex) {
            // empty catch block
        }
    }

    private void initPages() {
        this.pages = new IntHashtable();
        int numPages = this.reader.getNumberOfPages();
        for (int k = 1; k <= numPages; ++k) {
            this.pages.put(this.reader.getPageOrigRef(k).getNumber(), k);
            this.reader.releasePage(k);
        }
    }

    private Bookmark getBookmark() {
        PdfDictionary catalog = this.reader.getCatalog();
        PdfObject obj = PdfReader.getPdfObjectRelease((PdfObject)catalog.get(PdfName.OUTLINES));
        if (obj == null || !obj.isDictionary()) {
            return null;
        }
        PdfDictionary outlines = (PdfDictionary)obj;
        this.initPages();
        Bookmark root = new Bookmark();
        root.setTitle("Root Bookmark");
        this.bookmarkDepth(root, (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)outlines.get(PdfName.FIRST)));
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActionInBookmark(Bookmark bookmark, PdfDictionary action) {
        if (PdfName.GOTO.equals((Object)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.S)))) {
            PdfObject dest = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.D));
            if (dest != null) {
                this.mapGotoBookmark(bookmark, dest);
            }
        } else if (PdfName.URI.equals((Object)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.S)))) {
            bookmark.setType(BookmarkType.Uri);
            bookmark.setUri(((PdfString)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.URI))).toUnicodeString());
        } else if (PdfName.GOTOR.equals((Object)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.S)))) {
            PdfObject newWindow;
            PdfObject dest;
            bookmark.setRemoteDestination(true);
            PdfObject file = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.F));
            if (file != null) {
                if (file.isString()) {
                    String path = Ut.onWindowsReplaceBackslashWithSlash((String)((PdfString)file).toUnicodeString());
                    bookmark.setRemoteFilePath(path);
                } else if (file.isDictionary() && (file = PdfReader.getPdfObject((PdfObject)((PdfDictionary)file).get(PdfName.F))).isString()) {
                    bookmark.setRemoteFilePath(((PdfString)file).toUnicodeString());
                }
            }
            if ((dest = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.D))) != null) {
                if (dest.isString()) {
                    bookmark.setNamedDestination(dest.toString());
                } else if (dest.isName()) {
                    bookmark.setNamedDestination(PdfName.decodeName((String)dest.toString()));
                    bookmark.setNamedAsName(true);
                } else if (dest.isArray()) {
                    PdfArray arr = (PdfArray)dest;
                    try {
                        File remoteFile = Ut.createAbsolutePath((File)new File(this.filePath), (File)new File(bookmark.getRemoteFilePath()));
                        PdfReader remoteReader = new PdfReader(remoteFile.getCanonicalPath());
                        this.makeBookmarkParam(remoteReader, bookmark, arr, null);
                        remoteReader.close();
                    }
                    catch (IOException ex) {}
                }
            }
            if ((newWindow = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.NEWWINDOW))) != null) {
                bookmark.setNewWindow(((PdfBoolean)newWindow).booleanValue());
            }
        } else if (PdfName.LAUNCH.equals((Object)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.S)))) {
            bookmark.setType(BookmarkType.Launch);
            PdfObject file = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.F));
            if (file == null) {
                file = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.WIN));
            }
            if (file != null) {
                if (file.isString()) {
                    bookmark.setFileToLaunch(((PdfString)file).toUnicodeString());
                } else if (file.isDictionary() && (file = PdfReader.getPdfObjectRelease((PdfObject)((PdfDictionary)file).get(PdfName.F))).isString()) {
                    bookmark.setFileToLaunch(((PdfString)file).toUnicodeString());
                }
            }
        } else if (PdfName.HIDE.equals((Object)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.S)))) {
            PdfBoolean hide;
            bookmark.setType(BookmarkType.Hide);
            PdfObject annotation = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.T));
            if (annotation != null && !annotation.isDictionary() && !annotation.isArray() && annotation.isString()) {
                bookmark.setFieldNameToHide(((PdfString)annotation).toUnicodeString());
            }
            if ((hide = (PdfBoolean)PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.H))) != null) {
                bookmark.setHide(hide.booleanValue());
            }
        } else {
            bookmark.setType(BookmarkType.Unknown);
        }
    }

    private void setActionsRecursive(Bookmark bookmark, PdfDictionary action) {
        this.setActionInBookmark(bookmark, action);
        PdfObject next = PdfReader.getPdfObjectRelease((PdfObject)action.get(PdfName.NEXT));
        if (next != null) {
            if (next.isArray()) {
                PdfArray actions = (PdfArray)next;
                for (int i = 0; i < actions.size(); ++i) {
                    Bookmark b = new Bookmark();
                    action = actions.getAsDict(i);
                    this.setActionsRecursive(b, action);
                    bookmark.addChainedBookmark(b);
                }
            } else if (next.isDictionary()) {
                Bookmark b = new Bookmark();
                action = (PdfDictionary)next;
                this.setActionsRecursive(b, action);
                bookmark.addChainedBookmark(b);
            }
        }
    }

    private Bookmark bookmarkFromDictionary(PdfDictionary outline) {
        PdfNumber count;
        PdfNumber style;
        if (outline == null) {
            return null;
        }
        Bookmark bookmark = new Bookmark();
        PdfString title = (PdfString)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.TITLE));
        bookmark.setTitle(title.toUnicodeString());
        PdfArray color = (PdfArray)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.C));
        if (color != null && color.size() == 3) {
            ByteBuffer out = new ByteBuffer();
            out.append(color.getAsNumber(0).floatValue()).append(' ');
            out.append(color.getAsNumber(1).floatValue()).append(' ');
            out.append(color.getAsNumber(2).floatValue());
            bookmark.setColor(new Color(color.getAsNumber(0).floatValue(), color.getAsNumber(1).floatValue(), color.getAsNumber(2).floatValue()));
        }
        if ((style = (PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.F))) != null) {
            int f = style.intValue();
            if ((f & 1) != 0) {
                bookmark.setItalic(true);
            }
            if ((f & 2) != 0) {
                bookmark.setBold(true);
            }
        }
        if ((count = (PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.COUNT))) != null && count.intValue() < 0) {
            bookmark.setOpened(false);
        } else {
            bookmark.setOpened(true);
        }
        try {
            PdfObject dest = PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.DEST));
            if (dest != null) {
                this.mapGotoBookmark(bookmark, dest);
            } else {
                PdfDictionary action = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.A));
                if (action != null) {
                    this.setActionsRecursive(bookmark, action);
                } else {
                    bookmark.setType(BookmarkType.Unknown);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return bookmark;
    }

    private void bookmarkDepth(Bookmark father, PdfDictionary outline) {
        Bookmark bookmark = null;
        while (outline != null) {
            bookmark = this.bookmarkFromDictionary(outline);
            PdfDictionary first = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.FIRST));
            if (first != null) {
                this.bookmarkDepth(bookmark, first);
            }
            father.add((MutableTreeNode)bookmark);
            outline = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)outline.get(PdfName.NEXT));
        }
    }

    private void mapGotoBookmark(Bookmark bookmark, PdfObject dest) {
        if (dest.isString()) {
            if (this.namesAsString == null) {
                this.namesAsString = this.reader.getNamedDestinationFromStrings();
            }
            bookmark.setType(BookmarkType.Named);
            bookmark.setNamedDestination(dest.toString());
            PdfArray namedDest = this.getNamedDestination(this.reader, dest.toString(), false);
            Bookmark namedTarget = new Bookmark();
            namedTarget.setTitle(dest.toString());
            this.makeBookmarkParam(this.reader, namedTarget, namedDest, this.pages);
            bookmark.setNamedTarget(namedTarget);
        } else if (dest.isName()) {
            if (this.namesAsName == null) {
                this.namesAsName = this.reader.getNamedDestinationFromNames();
            }
            bookmark.setType(BookmarkType.Named);
            String name = PdfName.decodeName((String)dest.toString());
            bookmark.setNamedDestination(name);
            bookmark.setNamedAsName(true);
            PdfArray namedDest = this.getNamedDestination(this.reader, name, true);
            Bookmark namedTarget = new Bookmark();
            namedTarget.setTitle(name);
            this.makeBookmarkParam(this.reader, namedTarget, namedDest, this.pages);
            bookmark.setNamedTarget(namedTarget);
        } else if (dest.isArray()) {
            this.makeBookmarkParam(this.reader, bookmark, (PdfArray)dest, this.pages);
        }
    }

    private PdfArray getNamedDestination(PdfReader reader, String dest, boolean fromNames) {
        PdfArray arr = null;
        for (Map.Entry entry : this.namesAsString.entrySet()) {
            String key = (String)entry.getKey();
            if (fromNames) {
                if (!dest.equals(key)) continue;
                arr = (PdfArray)entry.getValue();
                break;
            }
            if (!dest.equals(key)) continue;
            arr = (PdfArray)entry.getValue();
            break;
        }
        return arr;
    }

    private String makeBookmarkParam(PdfReader reader, Bookmark bookmark, PdfArray dest, IntHashtable pages) {
        int k;
        StringBuilder s = new StringBuilder();
        PdfObject obj = dest.getPdfObject(0);
        if (obj.isNumber()) {
            s.append(((PdfNumber)obj).intValue() + 1);
            bookmark.setPageNumber(((PdfNumber)obj).intValue() + 1);
        } else {
            if (pages == null) {
                this.initPages();
            }
            if (pages != null) {
                s.append(pages.get(iTextBookmarksConverter.getNumber((PdfIndirectReference)obj)));
                bookmark.setPageNumber(pages.get(iTextBookmarksConverter.getNumber((PdfIndirectReference)obj)));
            }
        }
        Rectangle pageSize = null;
        pageSize = reader.getPageSize(bookmark.getPageNumber());
        if (pageSize != null) {
            bookmark.setPageWidth(pageSize.getWidth());
            bookmark.setPageHeight(pageSize.getHeight());
        }
        String destType = dest.getPdfObject(1).toString();
        PdfObject[] params = new PdfObject[dest.size()];
        for (k = 2; k < dest.size(); ++k) {
            params[k - 2] = dest.getPdfObject(k);
        }
        if (destType.equals("/XYZ")) {
            bookmark.setType(BookmarkType.TopLeftZoom);
            if (!params[0].isNull()) {
                bookmark.setLeft(((PdfNumber)params[0]).intValue());
            }
            if (!params[1].isNull()) {
                bookmark.setTop(((PdfNumber)params[1]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsLeft(iTextBookmarksConverter.thousandthsHorizontal(bookmark.getLeft(), pageSize));
                bookmark.setThousandthsTop(iTextBookmarksConverter.thousandthsVertical(bookmark.getTop(), pageSize));
            }
            if (!params[2].isNull()) {
                bookmark.setZoom(((PdfNumber)params[2]).floatValue());
            }
        } else if (destType.equals("/FitH")) {
            bookmark.setType(BookmarkType.FitWidth);
            if (!params[0].isNull()) {
                bookmark.setTop(((PdfNumber)params[0]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsTop(iTextBookmarksConverter.thousandthsVertical(bookmark.getTop(), pageSize));
            }
        } else if (destType.equals("/FitV")) {
            bookmark.setType(BookmarkType.FitHeight);
            if (!params[0].isNull()) {
                bookmark.setLeft(((PdfNumber)params[0]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsLeft(iTextBookmarksConverter.thousandthsHorizontal(bookmark.getLeft(), pageSize));
            }
        } else if (destType.equals("/FitBH")) {
            bookmark.setType(BookmarkType.FitContentWidth);
            if (!params[0].isNull()) {
                bookmark.setTop(((PdfNumber)params[0]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsTop(iTextBookmarksConverter.thousandthsVertical(bookmark.getTop(), pageSize));
            }
        } else if (destType.equals("/FitBV")) {
            bookmark.setType(BookmarkType.FitContentHeight);
            if (!params[0].isNull()) {
                bookmark.setLeft(((PdfNumber)params[0]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsLeft(iTextBookmarksConverter.thousandthsHorizontal(bookmark.getLeft(), pageSize));
            }
        } else if (destType.equals("/Fit")) {
            bookmark.setType(BookmarkType.FitPage);
        } else if (destType.equals("/FitB")) {
            bookmark.setType(BookmarkType.FitContent);
        } else if (destType.equals("/FitR")) {
            bookmark.setType(BookmarkType.FitRect);
            if (!params[0].isNull()) {
                bookmark.setLeft(((PdfNumber)params[0]).intValue());
            }
            if (!params[1].isNull()) {
                bookmark.setBottom(((PdfNumber)params[1]).intValue());
            }
            if (!params[2].isNull()) {
                bookmark.setRight(((PdfNumber)params[2]).intValue());
            }
            if (!params[3].isNull()) {
                bookmark.setTop(((PdfNumber)params[3]).intValue());
            }
            if (pageSize != null) {
                bookmark.setThousandthsLeft(iTextBookmarksConverter.thousandthsHorizontal(bookmark.getLeft(), pageSize));
                bookmark.setThousandthsTop(iTextBookmarksConverter.thousandthsVertical(bookmark.getTop(), pageSize));
                bookmark.setThousandthsRight(iTextBookmarksConverter.thousandthsHorizontal(bookmark.getRight(), pageSize));
                bookmark.setThousandthsBottom(iTextBookmarksConverter.thousandthsVertical(bookmark.getBottom(), pageSize));
            }
        }
        s.append(' ').append(dest.getPdfObject(1).toString().substring(1));
        for (k = 2; k < dest.size(); ++k) {
            s.append(' ').append(dest.getPdfObject(k).toString());
        }
        return s.toString();
    }

    private static int getNumber(PdfIndirectReference indirect) {
        PdfDictionary pdfObj = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)indirect);
        if (pdfObj.contains(PdfName.TYPE) && pdfObj.get(PdfName.TYPE).equals(PdfName.PAGES) && pdfObj.contains(PdfName.KIDS)) {
            PdfArray kids = (PdfArray)pdfObj.get(PdfName.KIDS);
            indirect = (PdfIndirectReference)kids.getPdfObject(0);
        }
        return indirect.getNumber();
    }

    public static int thousandthsHorizontal(int x, Rectangle pageRect) {
        int thousandths = -1;
        if (x != -1) {
            try {
                thousandths = (int)((float)x * 1000.0f / pageRect.getWidth());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return thousandths;
    }

    public static int thousandthsVertical(int y, Rectangle pageRect) {
        int thousandths = -1;
        if (y != -1) {
            try {
                thousandths = 1000 - Math.round((float)y * 1000.0f / pageRect.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return thousandths;
    }

    public boolean showBookmarksOnOpen() {
        return this.showOnOpen;
    }

    public void setShowBookmarksOnOpen(boolean show) {
        this.showOnOpen = show;
    }

    public float getPageWidth(int pageNumber) {
        Rectangle pageSize = this.reader.getPageSize(pageNumber);
        return pageSize.getWidth();
    }

    public float getPageHeight(int pageNumber) {
        Rectangle pageSize = this.reader.getPageSize(pageNumber);
        return pageSize.getHeight();
    }

    public int getCountOfPages() {
        return this.reader.getNumberOfPages();
    }

    public String getOpenedFilePath() {
        return this.filePath;
    }

    public ArrayList<IBookmarksConverter.AnnotationRect> getLinks(int currentPage, boolean convertNamedDestinations) {
        ArrayList<IBookmarksConverter.AnnotationRect> bookmarkLinks = new ArrayList<IBookmarksConverter.AnnotationRect>();
        ArrayList links = null;
        if (this.reader != null) {
            if (convertNamedDestinations) {
                this.reader.consolidateNamedDestinations();
            }
            links = this.reader.getAnnotations(currentPage);
            for (int i = 0; i < links.size(); ++i) {
                IBookmarksConverter.AnnotationRect annoRect = new IBookmarksConverter.AnnotationRect();
                Bookmark bookmark = new Bookmark();
                PdfDictionary annot = (PdfDictionary)links.get(i);
                try {
                    PdfObject dest = PdfReader.getPdfObjectRelease((PdfObject)annot.get(PdfName.DEST));
                    if (dest != null) {
                        this.mapGotoBookmark(bookmark, dest);
                    } else {
                        PdfDictionary action = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)annot.get(PdfName.A));
                        if (action != null) {
                            this.setActionsRecursive(bookmark, action);
                        } else {
                            bookmark.setType(BookmarkType.Unknown);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                PdfObject obj = annot.get(PdfName.RECT);
                if (obj instanceof PdfArray) {
                    PdfArray rc = (PdfArray)obj;
                    annoRect.llx = (int)rc.getAsNumber(0).floatValue();
                    annoRect.lly = (int)rc.getAsNumber(1).floatValue();
                    annoRect.urx = (int)rc.getAsNumber(2).floatValue();
                    annoRect.ury = (int)rc.getAsNumber(3).floatValue();
                }
                annoRect.bookmark = bookmark;
                bookmarkLinks.add(annoRect);
            }
        }
        return bookmarkLinks;
    }
}

