/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.google.common.base.Optional;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.remote.JabRefMessageHandler;
import net.sf.jabref.remote.RemotePreferences;
import net.sf.jabref.remote.RemoteUtil;

public class AdvancedTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences preferences;
    HelpDialog helpDiag;
    JPanel pan = new JPanel();
    JLabel lab;
    private final JCheckBox useDefault;
    private final JCheckBox useRemoteServer;
    private final JCheckBox useNativeFileDialogOnMac;
    private final JCheckBox filechooserDisableRename;
    private final JCheckBox useIEEEAbrv;
    private final JCheckBox biblatexMode;
    private final JComboBox className;
    private final JTextField remoteServerPort;
    JPanel p1 = new JPanel();
    private String oldLnf = "";
    private boolean oldUseDef;
    private boolean oldBiblMode = false;
    private int oldPort = -1;
    public static final String PREF_IMPORT_CONVERT_TO_EQUATION = "importFileConvertToEquation";
    public static final String PREF_IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    private final JCheckBox useConvertToEquation;
    private final JCheckBox useCaseKeeperOnSearch;
    private final JCheckBox useUnitFormatterOnSearch;
    private final JabRef jabRef;
    private RemotePreferences remotePreferences;

    public AdvancedTab(JabRefPreferences jabRefPreferences, HelpDialog helpDialog, JabRef jabRef) {
        JComponent jComponent;
        this.jabRef = jabRef;
        this.preferences = jabRefPreferences;
        this.remotePreferences = new RemotePreferences(this.preferences);
        HelpAction helpAction = new HelpAction(helpDialog, "RemoteHelp.html", "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.useDefault = new JCheckBox(Globals.lang("Use other look and feel"));
        this.useRemoteServer = new JCheckBox(Globals.lang("Listen for remote operation on port") + ':');
        this.useNativeFileDialogOnMac = new JCheckBox(Globals.lang("Use native file dialog"));
        this.filechooserDisableRename = new JCheckBox(Globals.lang("Disable file renaming in non-native file dialog"));
        this.useIEEEAbrv = new JCheckBox(Globals.lang("Use IEEE LaTeX abbreviations"));
        this.biblatexMode = new JCheckBox(Globals.lang("BibLaTeX mode"));
        this.remoteServerPort = new JTextField();
        String[] stringArray = new String[]{UIManager.getSystemLookAndFeelClassName(), UIManager.getCrossPlatformLookAndFeelClassName(), "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "javax.swing.plaf.mac.MacLookAndFeel"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            try {
                Class.forName(string);
                arrayList.add(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.className = new JComboBox<String>(arrayList.toArray(new String[arrayList.size()]));
        this.className.setEditable(true);
        final JComboBox jComboBox = this.className;
        this.useDefault.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jComboBox.setEnabled(((JCheckBox)changeEvent.getSource()).isSelected());
            }
        });
        this.useConvertToEquation = new JCheckBox(Globals.lang("Prefer converting subscripts and superscripts to equations rather than text"));
        this.useCaseKeeperOnSearch = new JCheckBox(Globals.lang("Add {} to specified title words on search to keep the correct case"));
        this.useUnitFormatterOnSearch = new JCheckBox(Globals.lang("Format units by adding non-breaking separators and keeping the correct case on search"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        if (!Globals.ON_MAC) {
            defaultFormBuilder.appendSeparator(Globals.lang("Look and feel"));
            jComponent = new JLabel(Globals.lang("Default look and feel") + ": " + UIManager.getSystemLookAndFeelClassName());
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            defaultFormBuilder.append(this.useDefault);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            JPanel jPanel2 = new JPanel();
            jComponent = new JLabel(Globals.lang("Class name") + ':');
            jPanel2.add(jComponent);
            jPanel2.add(this.className);
            defaultFormBuilder.append(jPanel2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            jComponent = new JLabel(Globals.lang("Note that you must specify the fully qualified class name for the look and feel,"));
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(jPanel);
            jComponent = new JLabel(Globals.lang("and the class must be available in your classpath next time you start JabRef."));
            defaultFormBuilder.append(jComponent);
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.appendSeparator(Globals.lang("Remote operation"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(new JLabel("<html>" + Globals.lang("This feature lets new files be opened or imported into an already running instance of JabRef<BR>instead of opening a new instance. For instance, this is useful when you open a file in JabRef<br>from your web browser.<BR>Note that this will prevent you from running more than one instance of JabRef at a time.") + "</html>"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        jComponent = new JPanel();
        jComponent.add(this.useRemoteServer);
        jComponent.add(this.remoteServerPort);
        jComponent.add(helpAction.getIconButton());
        defaultFormBuilder.append(jComponent);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("File dialog"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.useNativeFileDialogOnMac);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.filechooserDisableRename);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Search IEEEXplore"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.useIEEEAbrv);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("BibLaTeX mode"));
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.biblatexMode);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Import conversions"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.useConvertToEquation);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.useCaseKeeperOnSearch);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.useUnitFormatterOnSearch);
        JPanel jPanel3 = defaultFormBuilder.getPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "Center");
    }

    @Override
    public void setValues() {
        this.oldUseDef = this.preferences.getBoolean("useDefaultLookAndFeel");
        this.oldLnf = this.preferences.get("lookAndFeel");
        this.useDefault.setSelected(!this.oldUseDef);
        this.className.setSelectedItem(this.oldLnf);
        this.className.setEnabled(!this.oldUseDef);
        this.useRemoteServer.setSelected(this.remotePreferences.useRemoteServer());
        this.oldPort = this.remotePreferences.getPort();
        this.remoteServerPort.setText(String.valueOf(this.oldPort));
        this.useNativeFileDialogOnMac.setSelected(Globals.prefs.getBoolean("useNativeFileDialogOnMac"));
        this.filechooserDisableRename.setSelected(Globals.prefs.getBoolean("filechooserDisableRename"));
        this.useIEEEAbrv.setSelected(Globals.prefs.getBoolean("useIEEEAbrv"));
        this.oldBiblMode = Globals.prefs.getBoolean("biblatexMode");
        this.biblatexMode.setSelected(this.oldBiblMode);
        this.useConvertToEquation.setSelected(Globals.prefs.getBoolean("useConvertToEquation"));
        this.useCaseKeeperOnSearch.setSelected(Globals.prefs.getBoolean("useCaseKeeperOnSearch"));
        this.useUnitFormatterOnSearch.setSelected(Globals.prefs.getBoolean("useUnitFormatterOnSearch"));
    }

    @Override
    public void storeSettings() {
        this.preferences.putBoolean("useDefaultLookAndFeel", !this.useDefault.isSelected());
        this.preferences.put("lookAndFeel", this.className.getSelectedItem().toString());
        this.preferences.putBoolean("useNativeFileDialogOnMac", this.useNativeFileDialogOnMac.isSelected());
        this.preferences.putBoolean("filechooserDisableRename", this.filechooserDisableRename.isSelected());
        UIManager.put("FileChooser.readOnly", this.filechooserDisableRename.isSelected());
        this.preferences.putBoolean("useIEEEAbrv", this.useIEEEAbrv.isSelected());
        if (this.useIEEEAbrv.isSelected()) {
            Globals.journalAbbrev = new JournalAbbreviationRepository();
            Globals.journalAbbrev.readJournalListFromResource("/resource/IEEEJournalList.txt");
        }
        this.storeRemoteSettings();
        this.preferences.putBoolean("biblatexMode", this.biblatexMode.isSelected());
        if (this.useDefault.isSelected() == this.oldUseDef || !this.oldLnf.equals(this.className.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the look and feel setting.").concat(" ").concat(Globals.lang("You must restart JabRef for this to come into effect.")), Globals.lang("Changed look and feel settings"), 2);
        }
        if (this.biblatexMode.isSelected() != this.oldBiblMode) {
            JOptionPane.showMessageDialog(null, Globals.lang("You have toggled the BibLaTeX mode.").concat(" ").concat("You must restart JabRef for this change to come into effect."), Globals.lang("BibLaTeX mode"), 2);
        }
        this.preferences.putBoolean("useConvertToEquation", this.useConvertToEquation.isSelected());
        this.preferences.putBoolean("useCaseKeeperOnSearch", this.useCaseKeeperOnSearch.isSelected());
        this.preferences.putBoolean("useUnitFormatterOnSearch", this.useUnitFormatterOnSearch.isSelected());
    }

    public void storeRemoteSettings() {
        Optional<Integer> optional = this.getPortAsInt();
        if (optional.isPresent() && this.remotePreferences.isDifferentPort(optional.get())) {
            this.remotePreferences.setPort(optional.get());
            if (this.remotePreferences.useRemoteServer()) {
                JOptionPane.showMessageDialog(null, Globals.lang("Remote server port").concat(" ").concat("You must restart JabRef for this change to come into effect."), Globals.lang("Remote server port"), 2);
            }
        }
        this.remotePreferences.setUseRemoteServer(this.useRemoteServer.isSelected());
        if (this.remotePreferences.useRemoteServer()) {
            Globals.remoteListener.openAndStart(new JabRefMessageHandler(this.jabRef), this.remotePreferences.getPort());
        } else {
            Globals.remoteListener.stop();
        }
    }

    public Optional<Integer> getPortAsInt() {
        try {
            return Optional.of(Integer.parseInt(this.remoteServerPort.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.absent();
        }
    }

    @Override
    public boolean readyToClose() {
        try {
            int n = Integer.parseInt(this.remoteServerPort.getText());
            if (RemoteUtil.isValidPartNumber(n)) {
                return true;
            }
            throw new NumberFormatException();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the interval 1025-65535 in the text field for") + " '" + Globals.lang("Remote server port") + '\'', Globals.lang("Remote server port"), 0);
            return false;
        }
    }

    @Override
    public String getTabName() {
        return Globals.lang("Advanced");
    }
}

