/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.FontSelectorDialog;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.gui.ColorSetupPanel;

class AppearancePrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JCheckBox colorCodes;
    private final JCheckBox overrideFonts;
    private final JCheckBox showGrid;
    private final ColorSetupPanel colorPanel = new ColorSetupPanel();
    private Font font = GUIGlobals.CURRENTFONT;
    private int oldMenuFontSize;
    private boolean oldOverrideFontSize;
    private final JTextField fontSize;
    private final JTextField rowPadding;

    public AppearancePrefsTab(JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this.setLayout(new BorderLayout());
        this.fontSize = new JTextField(5);
        this.rowPadding = new JTextField(5);
        this.colorCodes = new JCheckBox(Globals.lang("Color codes for required and optional fields"));
        this.overrideFonts = new JCheckBox(Globals.lang("Override default font settings"));
        this.showGrid = new JCheckBox(Globals.lang("Show gridlines"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.leadingColumnOffset(2);
        defaultFormBuilder.appendSeparator(Globals.lang("General"));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Globals.lang("Menu and label font size") + ":");
        jPanel.add(jLabel);
        jPanel.add(this.fontSize);
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.overrideFonts);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Table appearance"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(Globals.lang("Table row height padding") + ":"));
        jPanel2.add(this.rowPadding);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.colorCodes);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.showGrid);
        defaultFormBuilder.nextLine();
        JButton jButton = new JButton(Globals.lang("Set table font"));
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Table and entry editor colors"));
        defaultFormBuilder.append(this.colorPanel);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        jPanel4.setLayout(gridBagLayout);
        jPanel5.setLayout(gridBagLayout);
        jPanel6.setLayout(gridBagLayout);
        this.overrideFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppearancePrefsTab.this.fontSize.setEnabled(AppearancePrefsTab.this.overrideFonts.isSelected());
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Font font = new FontSelectorDialog(null, GUIGlobals.CURRENTFONT).getSelectedFont();
                if (font != null) {
                    AppearancePrefsTab.this.font = font;
                }
            }
        });
        JPanel jPanel7 = defaultFormBuilder.getPanel();
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel7, "Center");
    }

    @Override
    public void setValues() {
        this.colorCodes.setSelected(this._prefs.getBoolean("tableColorCodesOn"));
        this.fontSize.setText("" + this._prefs.getInt("menuFontSize"));
        this.rowPadding.setText("" + this._prefs.getInt("tableRowPadding"));
        this.oldMenuFontSize = this._prefs.getInt("menuFontSize");
        this.overrideFonts.setSelected(this._prefs.getBoolean("overrideDefaultFonts"));
        this.oldOverrideFontSize = this.overrideFonts.isSelected();
        this.fontSize.setEnabled(this.overrideFonts.isSelected());
        this.showGrid.setSelected(this._prefs.getBoolean("tableShowGrid"));
        this.colorPanel.setValues();
    }

    @Override
    public void storeSettings() {
        int n;
        this._prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this._prefs.put("fontFamily", this.font.getFamily());
        this._prefs.putInt("fontStyle", this.font.getStyle());
        this._prefs.putInt("fontSize", this.font.getSize());
        this._prefs.putBoolean("overrideDefaultFonts", this.overrideFonts.isSelected());
        GUIGlobals.CURRENTFONT = this.font;
        this.colorPanel.storeSettings();
        this._prefs.putBoolean("tableShowGrid", this.showGrid.isSelected());
        try {
            n = Integer.parseInt(this.fontSize.getText());
            if (this.overrideFonts.isSelected() != this.oldOverrideFontSize || n != this.oldMenuFontSize) {
                this._prefs.putInt("menuFontSize", n);
                JOptionPane.showMessageDialog(null, Globals.lang("You have changed the menu and label font size.").concat(" ").concat(Globals.lang("You must restart JabRef for this to come into effect.")), Globals.lang("Changed font settings"), 2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        try {
            n = Integer.parseInt(this.rowPadding.getText());
            this._prefs.putInt("tableRowPadding", n);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    private boolean validateIntegerField(String string, String string2, String string3) {
        try {
            Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the text field for") + " '" + Globals.lang(string) + "'", Globals.lang(string3), 0);
            return false;
        }
        return true;
    }

    @Override
    public boolean readyToClose() {
        if (!this.validateIntegerField("Menu and label font size", this.fontSize.getText(), "Changed font settings")) {
            return false;
        }
        return this.validateIntegerField("Table row height padding", this.rowPadding.getText(), "Changed table appearance settings");
    }

    @Override
    public String getTabName() {
        return Globals.lang("Appearance");
    }
}

