/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.CallBack;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;
import spin.Spin;

public class DuplicateSearch
implements Runnable {
    private final BasePanel panel;
    private BibtexEntry[] bes;
    private final Vector<BibtexEntry[]> duplicates = new Vector();

    public DuplicateSearch(BasePanel basePanel) {
        this.panel = basePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        final NamedCompound namedCompound = new NamedCompound(Globals.lang("duplicate removal"));
        int n = 0;
        boolean bl = false;
        this.panel.output(Globals.lang("Searching for duplicates..."));
        Object[] objectArray = this.panel.database.getKeySet().toArray();
        if (objectArray.length < 2) {
            return;
        }
        this.bes = new BibtexEntry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.bes[i] = this.panel.database.getEntryById((String)objectArray[i]);
        }
        SearcherRunnable searcherRunnable = new SearcherRunnable();
        JabRefExecutorService.INSTANCE.executeWithLowPriorityInOwnThread(searcherRunnable, "Searcher");
        int n2 = 0;
        final ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        while (true) {
            BibtexEntry[] bibtexEntryArray;
            if (searcherRunnable.finished() && n2 >= this.duplicates.size()) {
                final int n3 = n;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!arrayList.isEmpty()) {
                            for (BibtexEntry bibtexEntry : arrayList) {
                                ((DuplicateSearch)DuplicateSearch.this).panel.database.removeEntry(bibtexEntry.getId());
                                namedCompound.addEdit(new UndoableRemoveEntry(((DuplicateSearch)DuplicateSearch.this).panel.database, bibtexEntry, DuplicateSearch.this.panel));
                            }
                            DuplicateSearch.this.panel.markBaseChanged();
                        }
                        DuplicateSearch.this.panel.output(Globals.lang("Duplicate pairs found") + ": " + DuplicateSearch.this.duplicates.size() + ' ' + Globals.lang("pairs processed") + ": " + n3);
                        namedCompound.end();
                        ((DuplicateSearch)DuplicateSearch.this).panel.undoManager.addEdit(namedCompound);
                    }
                });
                return;
            }
            if (n2 >= this.duplicates.size()) {
                bibtexEntryArray = this.duplicates;
                // MONITORENTER : this.duplicates
                try {
                    this.duplicates.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
            bibtexEntryArray = this.duplicates.get(n2);
            ++n2;
            if (arrayList.contains(bibtexEntryArray[0]) || arrayList.contains(bibtexEntryArray[1])) continue;
            boolean bl2 = false;
            if (DuplicateCheck.compareEntriesStrictly(bibtexEntryArray[0], bibtexEntryArray[1]) > 1.0) {
                if (bl) {
                    arrayList.add(bibtexEntryArray[1]);
                    ++n;
                    continue;
                }
                bl2 = true;
            }
            DuplicateCallBack duplicateCallBack = new DuplicateCallBack(this.panel.frame, bibtexEntryArray[0], bibtexEntryArray[1], bl2 ? 4 : 1);
            ((CallBack)Spin.over(duplicateCallBack)).update();
            ++n;
            int n4 = duplicateCallBack.getSelected();
            if (n4 == 1 || n4 == 3) {
                arrayList.add(bibtexEntryArray[1]);
                if (n4 != 3) continue;
                bl = true;
                continue;
            }
            if (n4 == 2) {
                arrayList.add(bibtexEntryArray[0]);
                continue;
            }
            if (n4 != 5) continue;
            searcherRunnable.setFinished();
            n2 = Integer.MAX_VALUE;
            --n;
        }
    }

    static class DuplicateCallBack
    implements CallBack {
        private int reply = -1;
        DuplicateResolverDialog diag;
        private final JabRefFrame frame;
        private final BibtexEntry one;
        private final BibtexEntry two;
        private final int dialogType;

        public DuplicateCallBack(JabRefFrame jabRefFrame, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, int n) {
            this.frame = jabRefFrame;
            this.one = bibtexEntry;
            this.two = bibtexEntry2;
            this.dialogType = n;
        }

        public int getSelected() {
            return this.reply;
        }

        @Override
        public void update() {
            this.diag = new DuplicateResolverDialog(this.frame, this.one, this.two, this.dialogType);
            this.diag.setVisible(true);
            this.diag.dispose();
            this.reply = this.diag.getSelected();
        }
    }

    class SearcherRunnable
    implements Runnable {
        private volatile boolean finished = false;

        SearcherRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < DuplicateSearch.this.bes.length - 1 && !this.finished; ++i) {
                for (int j = i + 1; j < DuplicateSearch.this.bes.length && !this.finished; ++j) {
                    boolean bl = DuplicateCheck.isDuplicate(DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j]);
                    if (!bl) continue;
                    Vector vector = DuplicateSearch.this.duplicates;
                    synchronized (vector) {
                        DuplicateSearch.this.duplicates.add(new BibtexEntry[]{DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j]});
                        DuplicateSearch.this.duplicates.notifyAll();
                        continue;
                    }
                }
            }
            this.finished = true;
            Vector vector = DuplicateSearch.this.duplicates;
            synchronized (vector) {
                DuplicateSearch.this.duplicates.notifyAll();
            }
        }

        public boolean finished() {
            return this.finished;
        }

        public void setFinished() {
            this.finished = true;
        }
    }
}

