/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.EasyDateFormat;
import net.sf.jabref.EntryContainer;
import net.sf.jabref.EntryEditorTab;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.FieldContentSelector;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JTextAreaWithHighlighting;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.SimpleUrlDragDrop;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.external.WriteXMPEntryEditorAction;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.VerticalLabelUI;
import net.sf.jabref.gui.date.DatePickerButton;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.journals.JournalAbbreviationsUtil;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.specialfields.SpecialFieldUpdateListener;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableChangeType;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryEditor
extends JPanel
implements VetoableChangeListener,
EntryContainer {
    private static final long serialVersionUID = 1L;
    private BibtexEntry entry;
    private final BibtexEntryType type;
    private final CloseAction closeAction;
    private final DeleteAction deleteAction = new DeleteAction();
    final AbstractAction nextEntryAction = new NextEntryAction();
    final AbstractAction prevEntryAction = new PrevEntryAction();
    public final StoreFieldAction storeFieldAction;
    final SwitchLeftAction switchLeftAction = new SwitchLeftAction();
    final SwitchRightAction switchRightAction = new SwitchRightAction();
    public final GenerateKeyAction generateKeyAction;
    private FileListEditor fileListEditor = null;
    private final AutoLinkAction autoLinkAction = new AutoLinkAction();
    private final AbstractAction writeXmp;
    final SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction();
    JPanel mainPanel = new JPanel();
    private final JPanel srcPanel = new JPanel();
    EntryEditorTab genPan;
    EntryEditorTab absPan;
    JTextField bibtexKey;
    FieldTextField tf;
    private JTextArea source;
    private final JTabbedPane tabbed = new JTabbedPane();
    JLabel lab;
    final JabRefFrame frame;
    final BasePanel panel;
    private final EntryEditor ths = this;
    private final HashSet<FieldContentSelector> contentSelectors = new HashSet();
    private static final Log LOGGER = LogFactory.getLog(EntryEditor.class);
    private boolean updateSource = true;
    private boolean movingToDifferentEntry = false;
    private final List<Object> tabs = new ArrayList<Object>();
    private boolean lastSourceAccepted = true;
    private String lastSourceStringAccepted = null;
    private int sourceIndex = -1;
    private final JabRefPreferences prefs;
    final HelpAction helpAction;
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final TabListener tabListener = new TabListener();

    public EntryEditor(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexEntry bibtexEntry) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.entry = bibtexEntry;
        this.prefs = Globals.prefs;
        this.type = this.entry.getType();
        this.entry.addPropertyChangeListener(this);
        this.entry.addPropertyChangeListener(SpecialFieldUpdateListener.getInstance());
        this.helpAction = new HelpAction(this.frame.helpDiag, "EntryEditorHelp.html", "Help");
        this.closeAction = new CloseAction();
        this.generateKeyAction = new GenerateKeyAction(this.frame);
        this.storeFieldAction = new StoreFieldAction();
        this.writeXmp = new WriteXMPEntryEditorAction(basePanel, this);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setupToolBar();
        this.setupFieldPanels();
        this.setupSourcePanel();
        this.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(this.tabListener);
        if (this.prefs.getBoolean("showSource") && this.prefs.getBoolean("defaultShowSource")) {
            this.tabbed.setSelectedIndex(this.sourceIndex);
        }
        this.updateAllFields();
    }

    private void setupFieldPanels() {
        String[] stringArray;
        Object object;
        this.tabbed.removeAll();
        this.tabs.clear();
        String[] stringArray2 = this.entry.getRequiredFields();
        List<String> list = null;
        if (stringArray2 != null) {
            list = Arrays.asList(stringArray2);
        }
        EntryEditorTab entryEditorTab = new EntryEditorTab(this.frame, this.panel, list, this, true, false, Globals.lang("Required fields"));
        if (entryEditorTab.fileListEditor != null) {
            this.fileListEditor = entryEditorTab.fileListEditor;
        }
        this.tabbed.addTab(Globals.lang("Required fields"), GUIGlobals.getImage("required"), entryEditorTab.getPane(), Globals.lang("Show required fields"));
        this.tabs.add(entryEditorTab);
        if (this.entry.getOptionalFields() != null && this.entry.getOptionalFields().length >= 1) {
            if (!this.prefs.getBoolean("biblatexMode")) {
                object = new EntryEditorTab(this.frame, this.panel, Arrays.asList(this.entry.getOptionalFields()), this, false, false, Globals.lang("Optional fields"));
                if (((EntryEditorTab)object).fileListEditor != null) {
                    this.fileListEditor = ((EntryEditorTab)object).fileListEditor;
                }
                this.tabbed.addTab(Globals.lang("Optional fields"), GUIGlobals.getImage("optional"), ((EntryEditorTab)object).getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(object);
            } else {
                object = new EntryEditorTab(this.frame, this.panel, Arrays.asList(this.entry.getType().getPrimaryOptionalFields()), this, false, true, Globals.lang("Optional fields"));
                if (((EntryEditorTab)object).fileListEditor != null) {
                    this.fileListEditor = ((EntryEditorTab)object).fileListEditor;
                }
                this.tabbed.addTab(Globals.lang("Optional fields"), GUIGlobals.getImage("optional"), ((EntryEditorTab)object).getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(object);
                HashSet<String> hashSet = new HashSet<String>(BibtexEntry.FieldAliasesOldToNew.keySet());
                hashSet.add("year");
                hashSet.add("month");
                stringArray = this.entry.getType().getSecondaryOptionalFields();
                String[] stringArray3 = Util.getRemainder(stringArray, hashSet.toArray(new String[hashSet.size()]));
                HashSet<String> hashSet2 = new HashSet<String>();
                for (String string : this.entry.getOptionalFields()) {
                    hashSet2.add(string);
                    if (!BibtexEntry.FieldAliasesNewToOld.containsKey(string)) continue;
                    hashSet2.add(BibtexEntry.FieldAliasesNewToOld.get(string));
                }
                HashSet<String> hashSet3 = new HashSet<String>(hashSet);
                hashSet3.retainAll(hashSet2);
                EntryEditorTab entryEditorTab2 = new EntryEditorTab(this.frame, this.panel, Arrays.asList(stringArray3), this, false, true, Globals.lang("Optional fields 2"));
                if (entryEditorTab2.fileListEditor != null) {
                    this.fileListEditor = entryEditorTab2.fileListEditor;
                }
                this.tabbed.addTab(Globals.lang("Optional fields 2"), GUIGlobals.getImage("optional"), entryEditorTab2.getPane(), Globals.lang("Show optional fields"));
                this.tabs.add(entryEditorTab2);
                if (!hashSet3.isEmpty()) {
                    EntryEditorTab entryEditorTab3 = new EntryEditorTab(this.frame, this.panel, Arrays.asList(hashSet3.toArray(new String[hashSet3.size()])), this, false, true, Globals.lang("Deprecated fields"));
                    if (entryEditorTab3.fileListEditor != null) {
                        this.fileListEditor = entryEditorTab3.fileListEditor;
                    }
                    this.tabbed.addTab(Globals.lang("Deprecated fields"), GUIGlobals.getImage("optional"), entryEditorTab3.getPane(), Globals.lang("Show deprecated bibtex fields"));
                    this.tabs.add(entryEditorTab3);
                }
            }
        }
        object = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < ((EntryEditorTabList)object).getTabCount(); ++i) {
            stringArray = new EntryEditorTab(this.frame, this.panel, ((EntryEditorTabList)object).getTabFields(i), this, false, false, ((EntryEditorTabList)object).getTabName(i));
            if (stringArray.fileListEditor != null) {
                this.fileListEditor = stringArray.fileListEditor;
            }
            this.tabbed.addTab(((EntryEditorTabList)object).getTabName(i), GUIGlobals.getImage("general"), stringArray.getPane());
            this.tabs.add(stringArray);
        }
        this.srcPanel.setName(Globals.lang("BibTeX source"));
        if (Globals.prefs.getBoolean("showSource")) {
            this.tabbed.addTab(Globals.lang("BibTeX source"), GUIGlobals.getImage("source"), this.srcPanel, Globals.lang("Show/edit BibTeX source"));
            this.tabs.add(this.srcPanel);
        }
        this.sourceIndex = this.tabs.size() - 1;
        this.srcPanel.setFocusCycleRoot(true);
    }

    public BibtexEntryType getType() {
        return this.type;
    }

    @Override
    public BibtexEntry getEntry() {
        return this.entry;
    }

    public BibtexDatabase getDatabase() {
        return this.panel.getDatabase();
    }

    private void setupToolBar() {
        Component[] componentArray;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setBorder(null);
        jToolBar.setRollover(true);
        jToolBar.setMargin(new Insets(0, 0, 0, 2));
        ActionMap actionMap = jToolBar.getActionMap();
        InputMap inputMap = jToolBar.getInputMap(2);
        inputMap.put(this.prefs.getKey("Close entry editor"), "close");
        actionMap.put("close", this.closeAction);
        inputMap.put(this.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.storeFieldAction);
        inputMap.put(this.prefs.getKey("Autogenerate BibTeX keys"), "generateKey");
        actionMap.put("generateKey", this.generateKeyAction);
        inputMap.put(this.prefs.getKey("Automatically link files"), "autoLink");
        actionMap.put("autoLink", this.autoLinkAction);
        inputMap.put(this.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.prevEntryAction);
        inputMap.put(this.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.nextEntryAction);
        inputMap.put(this.prefs.getKey("Undo"), "undo");
        actionMap.put("undo", this.undoAction);
        inputMap.put(this.prefs.getKey("Redo"), "redo");
        actionMap.put("redo", this.redoAction);
        inputMap.put(this.prefs.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(this.closeAction);
        jButton.setText(null);
        jButton.setBorder(null);
        jButton.setMargin(new Insets(8, 0, 8, 0));
        jPanel.add((Component)jButton, "North");
        jPanel.add((Component)new TypeLabel(this.entry.getType().getName()), "Center");
        TypeButton typeButton = new TypeButton(this.entry.getType().getName());
        jToolBar.add(typeButton);
        jToolBar.add(this.generateKeyAction);
        jToolBar.add(this.autoLinkAction);
        jToolBar.add(this.writeXmp);
        jToolBar.addSeparator();
        jToolBar.add(this.deleteAction);
        jToolBar.add(this.prevEntryAction);
        jToolBar.add(this.nextEntryAction);
        jToolBar.addSeparator();
        jToolBar.add(this.helpAction);
        for (Component component : componentArray = jToolBar.getComponents()) {
            ((JComponent)component).setOpaque(false);
        }
        jPanel.add((Component)jToolBar, "South");
        this.add((Component)jPanel, "West");
    }

    public void rebuildPanels() {
        this.tabbed.removeChangeListener(this.tabListener);
        this.setupFieldPanels();
        this.tabbed.addChangeListener(this.tabListener);
        this.revalidate();
        this.repaint();
    }

    public JComponent getExtra(String string, final FieldEditor fieldEditor) {
        final String string2 = fieldEditor.getFieldName();
        String string3 = BibtexFields.getFieldExtras(string);
        if (string2.equals(Globals.prefs.get("timeStampField")) || string3 != null && string3.equals("datepicker")) {
            ((JTextArea)((Object)fieldEditor)).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        String string = new EasyDateFormat().getCurrentDate();
                        fieldEditor.setText(string);
                    }
                }
            });
            if (string3 != null && string3.equals("datepicker")) {
                DatePickerButton datePickerButton = new DatePickerButton(fieldEditor);
                return datePickerButton.getDatePicker();
            }
        }
        if (string3 != null && string3.equals("external")) {
            ((JComponent)((Object)fieldEditor)).addMouseListener(new ExternalViewerListener());
            return null;
        }
        if (string3 != null && string3.equals("journalNames")) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            if (this.panel.metaData.getData("selector_" + fieldEditor.getFieldName()) != null) {
                FieldContentSelector fieldContentSelector = new FieldContentSelector(this.frame, this.panel, this.frame, fieldEditor, this.panel.metaData, this.storeFieldAction, false, ", ");
                this.contentSelectors.add(fieldContentSelector);
                jPanel.add((Component)fieldContentSelector, "North");
            }
            jPanel.add((Component)JournalAbbreviationsUtil.getNameSwitcher(this, fieldEditor, this.panel.undoManager), "South");
            return jPanel;
        }
        if (this.panel.metaData.getData("selector_" + fieldEditor.getFieldName()) != null) {
            FieldContentSelector fieldContentSelector = new FieldContentSelector(this.frame, this.panel, this.frame, fieldEditor, this.panel.metaData, this.storeFieldAction, false, fieldEditor.getFieldName().equals("author") || fieldEditor.getFieldName().equals("editor") ? " and " : ", ");
            this.contentSelectors.add(fieldContentSelector);
            return fieldContentSelector;
        }
        if (string3 != null && string3.equals("browse")) {
            JButton jButton = new JButton(Globals.lang("Browse"));
            ((JComponent)((Object)fieldEditor)).addMouseListener(new ExternalViewerListener());
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    String string22 = fieldEditor.getText();
                    if (string22.isEmpty()) {
                        string22 = EntryEditor.this.prefs.get(string2 + "_dir", "");
                    }
                    if ((string = FileDialogs.getNewFile(EntryEditor.this.frame, new File(string22), '.' + string2, 0, false)) != null) {
                        File file = new File(string);
                        fieldEditor.setText(file.getPath());
                        EntryEditor.this.prefs.put(string2 + "_dir", file.getPath());
                        EntryEditor.this.updateField(fieldEditor);
                    }
                }
            });
            return jButton;
        }
        if (string3 != null && (string3.equals("browseDoc") || string3.equals("browseDocZip"))) {
            String string4 = '.' + string2.toLowerCase();
            OpenFileFilter openFileFilter = string3.equals("browseDocZip") ? new OpenFileFilter(new String[]{string4, string4 + ".gz", string4 + ".bz2"}) : new OpenFileFilter(new String[]{string4});
            return new ExternalFilePanel(this.frame, this.panel.metaData(), this, string2, openFileFilter, fieldEditor);
        }
        if (string3 != null && string3.equals("url")) {
            ((JComponent)((Object)fieldEditor)).setDropTarget(new DropTarget((Component)((Object)fieldEditor), 0, new SimpleUrlDragDrop(fieldEditor, this.storeFieldAction)));
            return null;
        }
        if (string3 != null && string3.equals("setOwner")) {
            JButton jButton = new JButton(Globals.lang("Auto"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    fieldEditor.setText(Globals.prefs.get("defaultOwner"));
                    EntryEditor.this.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
                }
            });
            return jButton;
        }
        return null;
    }

    private void setupSourcePanel() {
        this.source = new JTextAreaWithHighlighting();
        this.frame.getSearchManager().addSearchListener((SearchTextListener)((Object)this.source));
        this.source.setEditable(true);
        this.source.setLineWrap(true);
        this.source.setTabSize(4);
        this.source.addFocusListener(new FieldEditorFocusListener());
        this.source.addFocusListener(Globals.focusListener);
        this.source.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        this.setupJTextComponent(this.source);
        this.updateSource();
        JScrollPane jScrollPane = new JScrollPane(this.source, 20, 31);
        this.srcPanel.setLayout(new BorderLayout());
        this.srcPanel.add((Component)jScrollPane, "Center");
    }

    public void updateSource() {
        if (this.updateSource) {
            StringWriter stringWriter = new StringWriter(200);
            try {
                LatexFieldFormatter latexFieldFormatter = LatexFieldFormatter.buildIgnoreHashes();
                this.entry.write(stringWriter, latexFieldFormatter, false);
                String string = stringWriter.getBuffer().toString();
                this.source.setText(string);
                this.lastSourceStringAccepted = string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                        if (n >= 0) {
                            if (EntryEditor.this.panel.mainTable.getSelectedRowCount() == 0) {
                                EntryEditor.this.panel.mainTable.setRowSelectionInterval(n, n);
                            }
                            EntryEditor.this.panel.mainTable.ensureVisible(n);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                this.source.setText(iOException.getMessage() + "\n\n" + Globals.lang("Correct the entry, and reopen editor to display/edit source."));
                this.source.setEditable(false);
            }
        }
    }

    private void setupJTextComponent(JTextComponent jTextComponent) {
        InputMap inputMap = jTextComponent.getInputMap(0);
        ActionMap actionMap = jTextComponent.getActionMap();
        inputMap.put(this.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.storeFieldAction);
        inputMap.put(this.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(this.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("right", this.switchRightAction);
        inputMap.put(this.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(this.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("left", this.switchLeftAction);
        inputMap.put(this.prefs.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        inputMap.put(this.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(0));
            hashSet.clear();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            jTextComponent.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(1));
            hashSet.clear();
            hashSet.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            jTextComponent.setFocusTraversalKeys(1, hashSet);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        jTextComponent.addFocusListener(new FieldListener());
    }

    @Override
    public void requestFocus() {
        this.activateVisible();
    }

    private void activateVisible() {
        Object object = this.tabs.get(this.tabbed.getSelectedIndex());
        if (object instanceof EntryEditorTab) {
            ((EntryEditorTab)object).activate();
        } else {
            new FocusRequester(this.source);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        for (Object object : this.tabs) {
            if (!(object instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)object).setEnabled(bl);
        }
        this.source.setEnabled(bl);
    }

    private void scrollTo(int n) {
        this.movingToDifferentEntry = true;
        this.panel.mainTable.setRowSelectionInterval(n, n);
        this.panel.mainTable.ensureVisible(n);
    }

    public void storeCurrentEdit() {
        JComponent jComponent = Globals.focusListener.getFocused();
        if (jComponent == this.source || jComponent instanceof FieldEditor && this.isAncestorOf(jComponent)) {
            if (jComponent instanceof FieldEditor) {
                ((FieldEditor)((Object)jComponent)).clearAutoCompleteSuggestion();
            }
            this.storeFieldAction.actionPerformed(new ActionEvent(jComponent, 0, ""));
        }
    }

    public int getVisiblePanel() {
        return this.tabbed.getSelectedIndex();
    }

    public String getVisiblePanelName() {
        return this.tabbed.getSelectedComponent().getName();
    }

    public void setVisiblePanel(int n) {
        this.tabbed.setSelectedIndex(Math.min(n, this.tabbed.getTabCount() - 1));
    }

    public void setVisiblePanel(String string) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (!string.equals(this.tabbed.getComponent(i).getName())) continue;
            this.tabbed.setSelectedIndex(i);
            return;
        }
        if (this.tabbed.getTabCount() > 0) {
            this.tabbed.setSelectedIndex(0);
        }
    }

    public synchronized void switchTo(BibtexEntry bibtexEntry) {
        if (this.entry == bibtexEntry) {
            this.updateSource();
            return;
        }
        this.storeCurrentEdit();
        this.entry.removePropertyChangeListener(this);
        bibtexEntry.addPropertyChangeListener(this);
        this.entry = bibtexEntry;
        this.updateAllFields();
        this.validateAllFields();
        this.updateSource();
        this.panel.newEntryShowing(bibtexEntry);
    }

    public boolean lastSourceAccepted() {
        if (this.tabbed.getSelectedComponent() == this.srcPanel) {
            this.storeSource(false);
        }
        return this.lastSourceAccepted;
    }

    private boolean storeSource(boolean bl) {
        BibtexParser bibtexParser = new BibtexParser(new StringReader(this.source.getText()));
        try {
            boolean bl2;
            ParserResult parserResult = bibtexParser.parse();
            BibtexDatabase bibtexDatabase = parserResult.getDatabase();
            if (bibtexDatabase.getEntryCount() > 1) {
                throw new Exception("More than one entry found.");
            }
            if (bibtexDatabase.getEntryCount() < 1) {
                if (parserResult.hasWarnings()) {
                    throw new Exception(parserResult.warnings()[0]);
                }
                throw new Exception("No entries found.");
            }
            NamedCompound namedCompound = new NamedCompound(Globals.lang("source edit"));
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(bibtexDatabase.getKeySet().iterator().next());
            String string = this.entry.getId();
            String string2 = bibtexEntry.getCiteKey();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = bl2 = string2 == null || string2.isEmpty();
            if (this.panel.database.setCiteKeyForEntry(string, string2)) {
                bl5 = true;
            }
            for (String string3 : this.entry.getAllFields()) {
                if (!BibtexFields.isDisplayableField(string3) || bibtexEntry.getField(string3) != null) continue;
                namedCompound.addEdit(new UndoableFieldChange(this.entry, string3, this.entry.getField(string3), null));
                this.entry.clearField(string3);
                bl3 = true;
            }
            for (String string3 : bibtexEntry.getAllFields()) {
                String string4 = this.entry.getField(string3);
                String string5 = bibtexEntry.getField(string3);
                if (string4 != null && string4.equals(string5)) continue;
                new LatexFieldFormatter().format(string5, string3);
                namedCompound.addEdit(new UndoableFieldChange(this.entry, string3, string4, string5));
                this.entry.setField(string3, string5);
                bl3 = true;
            }
            if (bibtexEntry.getType() != this.entry.getType()) {
                namedCompound.addEdit(new UndoableChangeType(this.entry, this.entry.getType(), bibtexEntry.getType()));
                this.entry.setType(bibtexEntry.getType());
                bl3 = true;
                bl4 = true;
            }
            namedCompound.end();
            if (!bl3) {
                return true;
            }
            this.panel.undoManager.addEdit(namedCompound);
            if (bl5) {
                this.warnDuplicateBibtexkey();
            } else if (bl2 && bl) {
                this.warnEmptyBibtexkey();
            } else {
                this.panel.output(Globals.lang("Stored entry") + '.');
            }
            this.lastSourceStringAccepted = this.source.getText();
            if (!bl4) {
                this.updateAllFields();
                this.lastSourceAccepted = true;
                this.updateSource = true;
            } else {
                this.panel.updateEntryEditorIfShowing();
            }
            this.panel.markBaseChanged();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                    if (n >= 0) {
                        EntryEditor.this.panel.mainTable.ensureVisible(n);
                    }
                }
            });
            return true;
        }
        catch (Throwable throwable) {
            this.updateSource = false;
            this.lastSourceAccepted = false;
            this.tabbed.setSelectedComponent(this.srcPanel);
            if (bl) {
                Object[] objectArray = new Object[]{Globals.lang("Edit"), Globals.lang("Revert to original source")};
                int n = JOptionPane.showOptionDialog(this.frame, Globals.lang("Error") + ": " + throwable.getMessage(), Globals.lang("Problem with parsing entry"), 0, 0, null, objectArray, objectArray[0]);
                if (n != 0) {
                    this.updateSource = true;
                    this.updateSource();
                }
            }
            return false;
        }
    }

    private void setField(String string, String string2) {
        for (Object object : this.tabs) {
            if (!(object instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)object).updateField(string, string2);
        }
    }

    public void updateAllFields() {
        for (Object object : this.tabs) {
            if (!(object instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)object).setEntry(this.entry);
        }
    }

    public void validateAllFields() {
        for (Object object : this.tabs) {
            if (!(object instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)object).validateAllFields();
        }
    }

    public void updateAllContentSelectors() {
        if (!this.contentSelectors.isEmpty()) {
            for (FieldContentSelector fieldContentSelector : this.contentSelectors) {
                fieldContentSelector.rebuildComboBox();
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getNewValue() != null ? propertyChangeEvent.getNewValue().toString() : "";
        this.setField(propertyChangeEvent.getPropertyName(), string);
    }

    public void updateField(Object object) {
        this.storeFieldAction.actionPerformed(new ActionEvent(object, 0, ""));
    }

    public void setMovingToDifferentEntry() {
        this.movingToDifferentEntry = true;
    }

    private void warnDuplicateBibtexkey() {
        this.panel.output(Globals.lang("Duplicate BibTeX key. Grouping may not work for this entry."));
    }

    private void warnEmptyBibtexkey() {
        this.panel.output(Globals.lang("Empty BibTeX key. Grouping may not work for this entry."));
    }

    private class AutoLinkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AutoLinkAction() {
            this.putValue("SmallIcon", GUIGlobals.getImage("autoGroup"));
            this.putValue("ShortDescription", Globals.lang("Automatically set file links for this entry") + " (Alt-F)");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileListEditor fileListEditor = EntryEditor.this.fileListEditor;
            if (fileListEditor == null) {
                LOGGER.warn("No file list editor found.");
            } else {
                fileListEditor.autoSetLinks();
            }
        }
    }

    class ChangeTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        final BibtexEntryType type;
        final BasePanel panel;

        public ChangeTypeAction(BibtexEntryType bibtexEntryType, BasePanel basePanel) {
            super(bibtexEntryType.getName());
            this.type = bibtexEntryType;
            this.panel = basePanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.changeType(EntryEditor.this.entry, this.type);
        }
    }

    private class ExternalViewerListener
    extends MouseAdapter {
        private ExternalViewerListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                FieldTextArea fieldTextArea = (FieldTextArea)mouseEvent.getSource();
                if (fieldTextArea.getText().isEmpty()) {
                    return;
                }
                fieldTextArea.selectAll();
                String string = fieldTextArea.getText();
                try {
                    Util.openExternalViewer(EntryEditor.this.panel.metaData(), string, fieldTextArea.getFieldName());
                }
                catch (IOException iOException) {
                    System.err.println("Error opening file.");
                }
            }
        }
    }

    class SaveDatabaseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveDatabaseAction() {
            super("Save database");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
            if (e instanceof EntryEditorTab) {
                EntryEditorTab entryEditorTab = (EntryEditorTab)e;
                FieldEditor fieldEditor = entryEditorTab.getActive();
                fieldEditor.clearAutoCompleteSuggestion();
                EntryEditor.this.updateField(fieldEditor);
            } else {
                EntryEditor.this.updateField(e);
            }
            try {
                EntryEditor.this.panel.runCommand("save");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EntryEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EntryEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class GenerateKeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        final JabRefFrame parent;
        BibtexEntry selectedEntry;

        public GenerateKeyAction(JabRefFrame jabRefFrame) {
            super(Globals.lang("Generate BibTeX key"), GUIGlobals.getImage("makeKey"));
            this.parent = jabRefFrame;
            this.putValue("ShortDescription", Globals.lang("Generate BibTeX key"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object;
                EntryEditor.this.storeCurrentEdit();
                String string = EntryEditor.this.entry.getField("bibtexkey");
                if (string != null) {
                    if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                        EntryEditor.this.panel.output(Globals.lang("Not overwriting existing key. To change this setting, open Options -> Prefererences -> BibTeX key generator"));
                        return;
                    }
                    if (Globals.prefs.getBoolean("warnBeforeOverwritingKey")) {
                        object = new CheckBoxMessage(Globals.lang("The current BibTeX key will be overwritten. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                        int n = JOptionPane.showConfirmDialog(EntryEditor.this.frame, object, Globals.lang("Overwrite key"), 0);
                        if (((CheckBoxMessage)object).isSelected()) {
                            Globals.prefs.putBoolean("warnBeforeOverwritingKey", false);
                        }
                        if (n == 1) {
                            return;
                        }
                    }
                }
                LabelPatternUtil.makeLabel(EntryEditor.this.panel.metaData, EntryEditor.this.panel.database, EntryEditor.this.entry);
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), string, EntryEditor.this.entry.getField("bibtexkey")));
                object = EntryEditor.this.entry.getField("bibtexkey");
                EntryEditor.this.setField("bibtexkey", (String)object);
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            }
            catch (Throwable throwable) {
                System.err.println("error setting key: " + throwable);
            }
        }
    }

    class PrevEntryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public PrevEntryAction() {
            super(Globals.lang("Previous entry"), GUIGlobals.getImage("up"));
            this.putValue("ShortDescription", Globals.lang("Previous entry"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            if (n2 - 1 >= 0) {
                n = n2 - 1;
            } else if (n2 != EntryEditor.this.panel.database.getEntryCount() - 1) {
                n = EntryEditor.this.panel.database.getEntryCount() - 1;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(n);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(n, n);
        }
    }

    class NextEntryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public NextEntryAction() {
            super(Globals.lang("Next entry"), GUIGlobals.getImage("down"));
            this.putValue("ShortDescription", Globals.lang("Next entry"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            if (n2 + 1 < EntryEditor.this.panel.database.getEntryCount()) {
                n = n2 + 1;
            } else if (n2 > 0) {
                n = 0;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(n);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(n, n);
        }
    }

    class SwitchRightAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SwitchRightAction() {
            super("Switch to the panel to the right");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(n < EntryEditor.this.tabbed.getTabCount() - 1 ? n + 1 : 0);
            EntryEditor.this.activateVisible();
        }
    }

    class SwitchLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SwitchLeftAction() {
            super("Switch to the panel to the left");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(n > 0 ? n - 1 : EntryEditor.this.tabbed.getTabCount() - 1);
            EntryEditor.this.activateVisible();
        }
    }

    public class StoreFieldAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = EntryEditor.this.movingToDifferentEntry;
            EntryEditor.this.movingToDifferentEntry = false;
            if (actionEvent.getSource() instanceof FieldTextField) {
                FieldTextField fieldTextField = (FieldTextField)actionEvent.getSource();
                String string = EntryEditor.this.entry.getCiteKey();
                String string2 = fieldTextField.getText();
                if (string2.isEmpty()) {
                    string2 = null;
                }
                if (string == null && string2 == null || string != null && string2 != null && string.equals(string2)) {
                    return;
                }
                String string3 = Util.checkLegalKey(string2);
                if (string3 != null && !string3.equals(string2)) {
                    JOptionPane.showMessageDialog(EntryEditor.this.frame, Globals.lang("Invalid BibTeX key"), Globals.lang("Error setting field"), 0);
                    fieldTextField.setInvalidBackgroundColor();
                    return;
                }
                fieldTextField.setValidBackgroundColor();
                boolean bl3 = EntryEditor.this.panel.database.setCiteKeyForEntry(EntryEditor.this.entry.getId(), string2);
                if (string2 != null) {
                    if (bl3) {
                        EntryEditor.this.warnDuplicateBibtexkey();
                    } else {
                        EntryEditor.this.panel.output(Globals.lang("BibTeX key is unique."));
                    }
                } else {
                    EntryEditor.this.warnEmptyBibtexkey();
                }
                UndoableKeyChange undoableKeyChange = new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), string, string2);
                if (Util.updateTimeStampIsSet()) {
                    NamedCompound namedCompound = Util.doUpdateTimeStamp(EntryEditor.this.entry, undoableKeyChange);
                    EntryEditor.this.panel.undoManager.addEdit(namedCompound);
                } else {
                    EntryEditor.this.panel.undoManager.addEdit(undoableKeyChange);
                }
                fieldTextField.setValidBackgroundColor();
                if (fieldTextField.getTextComponent().hasFocus()) {
                    fieldTextField.setActiveBackgroundColor();
                }
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            } else if (actionEvent.getSource() instanceof FieldEditor) {
                boolean bl4;
                String string = null;
                FieldEditor fieldEditor = (FieldEditor)actionEvent.getSource();
                String string4 = fieldEditor.getText();
                String string5 = string4.trim();
                if (!string5.isEmpty()) {
                    string = string5;
                }
                if (string == null) {
                    bl4 = EntryEditor.this.entry.getField(fieldEditor.getFieldName()) != null;
                } else {
                    boolean bl5 = bl4 = EntryEditor.this.entry.getField(fieldEditor.getFieldName()) == null || !string.equals(EntryEditor.this.entry.getField(fieldEditor.getFieldName()));
                }
                if (bl4) {
                    try {
                        if (string != null) {
                            new LatexFieldFormatter().format(string, fieldEditor.getFieldName());
                        }
                        String string6 = EntryEditor.this.entry.getField(fieldEditor.getFieldName());
                        if (string != null) {
                            EntryEditor.this.entry.setField(fieldEditor.getFieldName(), string);
                        } else {
                            EntryEditor.this.entry.clearField(fieldEditor.getFieldName());
                        }
                        fieldEditor.setValidBackgroundColor();
                        AutoCompleter autoCompleter = EntryEditor.this.panel.getAutoCompleters().get(fieldEditor.getFieldName());
                        if (autoCompleter != null) {
                            autoCompleter.addBibtexEntry(EntryEditor.this.entry);
                        }
                        UndoableFieldChange undoableFieldChange = new UndoableFieldChange(EntryEditor.this.entry, fieldEditor.getFieldName(), string6, string);
                        if (Util.updateTimeStampIsSet()) {
                            NamedCompound namedCompound = Util.doUpdateTimeStamp(EntryEditor.this.entry, undoableFieldChange);
                            EntryEditor.this.panel.undoManager.addEdit(namedCompound);
                        } else {
                            EntryEditor.this.panel.undoManager.addEdit(undoableFieldChange);
                        }
                        EntryEditor.this.updateSource();
                        EntryEditor.this.panel.markBaseChanged();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(EntryEditor.this.frame, Globals.lang("Error") + ": " + illegalArgumentException.getMessage(), Globals.lang("Error setting field"), 0);
                        fieldEditor.setInvalidBackgroundColor();
                    }
                } else {
                    fieldEditor.setValidBackgroundColor();
                }
                if (fieldEditor.getTextComponent().hasFocus()) {
                    fieldEditor.setBackground(GUIGlobals.activeEditor);
                }
            } else if (!EntryEditor.this.source.isEditable() || EntryEditor.this.source.getText().equals(EntryEditor.this.lastSourceStringAccepted) || (bl = EntryEditor.this.storeSource(true))) {
                // empty if block
            }
            if (!bl2 && EntryEditor.this.isShowing()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
                        if (n >= 0) {
                            EntryEditor.this.panel.mainTable.ensureVisible(n);
                        }
                    }
                });
            }
        }
    }

    class CopyKeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CopyKeyAction() {
            super("Copy BibTeX key to clipboard");
            this.putValue("ShortDescription", "Copy BibTeX key to clipboard (Ctrl-K)");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = EntryEditor.this.entry.getField("bibtexkey");
            StringSelection stringSelection = new StringSelection(string);
            if (string != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            super(Globals.lang("Close window"), GUIGlobals.getImage("close"));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EntryEditor.this.tabbed.getSelectedComponent() == EntryEditor.this.srcPanel) {
                EntryEditor.this.updateField(EntryEditor.this.source);
                if (EntryEditor.this.lastSourceAccepted) {
                    EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
                }
            } else {
                EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
            this.putValue("ShortDescription", Globals.lang("Delete entry"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EntryEditor.this.panel.showDeleteConfirmationDialog(1);
            if (!bl) {
                return;
            }
            EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            EntryEditor.this.panel.database.removeEntry(EntryEditor.this.entry.getId());
            EntryEditor.this.panel.markBaseChanged();
            EntryEditor.this.panel.undoManager.addEdit(new UndoableRemoveEntry(EntryEditor.this.panel.database, EntryEditor.this.entry, EntryEditor.this.panel));
            EntryEditor.this.panel.output(Globals.lang("Deleted") + ' ' + Globals.lang("entry"));
        }
    }

    private class TabListener
    implements ChangeListener {
        private TabListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EntryEditor.this.activateVisible();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object e = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
                    if (e instanceof EntryEditorTab) {
                        ((EntryEditorTab)e).updateAll();
                    }
                }
            });
        }
    }

    private class FieldListener
    extends FocusAdapter {
        private FieldListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                EntryEditor.this.updateField(focusEvent.getSource());
            }
        }
    }

    private class TypeLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public TypeLabel(String string) {
            super(string);
            this.setUI(new VerticalLabelUI(false));
            this.setForeground(GUIGlobals.entryEditorLabelColor);
            this.setHorizontalAlignment(4);
            this.setFont(GUIGlobals.typeNameFont);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                        this.handleTypeChange();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                        this.handleTypeChange();
                    }
                }

                private void handleTypeChange() {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    for (String string : BibtexEntryType.getAllTypes()) {
                        jPopupMenu.add(new ChangeTypeAction(BibtexEntryType.getType(string), EntryEditor.this.panel));
                    }
                    jPopupMenu.show(EntryEditor.this.ths, 0, 0);
                }
            });
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(graphics2D);
        }
    }

    private class TypeButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public TypeButton(String string) {
            super(GUIGlobals.getImage("edit"));
            this.setToolTipText(Globals.lang("Change entry type"));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    for (String string : BibtexEntryType.getAllTypes()) {
                        jPopupMenu.add(new ChangeTypeAction(BibtexEntryType.getType(string), EntryEditor.this.panel));
                    }
                    jPopupMenu.show(EntryEditor.this.ths, 0, 0);
                }
            });
        }
    }
}

