/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.util.MonthUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.util.YearUtil;

public class FieldComparator
implements Comparator<BibtexEntry> {
    private static Collator collator;
    private final String[] field;
    private final String fieldName;
    private final boolean isNameField;
    private final boolean isTypeHeader;
    private final boolean isYearField;
    private final boolean isMonthField;
    private final boolean isNumeric;
    private final int multiplier;

    public FieldComparator(String string) {
        this(string, false);
    }

    public FieldComparator(String string, boolean bl) {
        this.fieldName = string;
        this.field = string.split("/");
        this.multiplier = bl ? -1 : 1;
        this.isTypeHeader = this.field[0].equals("entrytype");
        this.isNameField = this.field[0].equals("author") || this.field[0].equals("editor");
        this.isYearField = this.field[0].equals("year");
        this.isMonthField = this.field[0].equals("month");
        this.isNumeric = BibtexFields.isNumeric(this.field[0]);
    }

    @Override
    public int compare(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (this.isTypeHeader) {
            object3 = bibtexEntry.getType().getName();
            object2 = bibtexEntry2.getType().getName();
        } else {
            object3 = this.getField(bibtexEntry);
            object2 = this.getField(bibtexEntry2);
        }
        int n2 = this.multiplier;
        if (this.isMonthField) {
            n2 = -n2;
        }
        if (object3 == null) {
            return object2 == null ? 0 : n2;
        }
        if (object2 == null) {
            return -n2;
        }
        if (this.isNameField) {
            object3 = AuthorList.fixAuthorForAlphabetization((String)object3);
            object2 = AuthorList.fixAuthorForAlphabetization((String)object2);
        } else if (this.isYearField) {
            object3 = YearUtil.toFourDigitYear((String)object3);
            object2 = YearUtil.toFourDigitYear((String)object2);
        } else if (this.isMonthField) {
            object3 = MonthUtil.getMonth((String)((String)object3)).number;
            object2 = MonthUtil.getMonth((String)((String)object2)).number;
        }
        if (this.isNumeric) {
            Integer n3 = null;
            object = null;
            try {
                n3 = Util.intValueOf((String)object3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                object = Util.intValueOf((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (object != null && n3 != null) {
                object3 = n3;
                object2 = object;
            } else if (n3 != null) {
                object3 = n3;
                object2 = n3 + 1;
            } else if (object != null) {
                object2 = object;
                object3 = (Integer)object + 1;
            }
        }
        if (object3 instanceof Integer && object2 instanceof Integer) {
            n = ((Integer)object3).compareTo((Integer)object2);
        } else if (object2 instanceof Integer) {
            object = new Integer(object3.toString());
            n = -((Integer)object).compareTo((Integer)object2);
        } else if (object3 instanceof Integer) {
            object = new Integer(object2.toString());
            n = -((Integer)object3).compareTo((Integer)object);
        } else {
            object = ((String)object3).toLowerCase();
            String string = ((String)object2).toLowerCase();
            n = collator.compare((String)object, string);
        }
        return n * n2;
    }

    private Object getField(BibtexEntry bibtexEntry) {
        for (String string : this.field) {
            String string2 = bibtexEntry.getFieldOrAlias(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    static {
        try {
            collator = new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replaceAll("<'_'", "<' '<'_'"));
        }
        catch (ParseException parseException) {
            collator = Collator.getInstance();
        }
    }
}

