/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRefPreferences;

class IncrementalSearcher {
    private final JabRefPreferences prefs;
    private String hitInField;

    public IncrementalSearcher(JabRefPreferences jabRefPreferences) {
        this.prefs = jabRefPreferences;
    }

    public String getField() {
        return this.hitInField;
    }

    public boolean search(String string, BibtexEntry bibtexEntry) {
        this.hitInField = null;
        return this.searchFields(bibtexEntry.getAllFields(), bibtexEntry, string);
    }

    private boolean searchFields(Set<String> set, BibtexEntry bibtexEntry, String string) {
        boolean bl = false;
        if (set != null) {
            for (String string2 : set) {
                try {
                    if (bibtexEntry.getField(string2) == null) continue;
                    if (this.prefs.getBoolean("caseSensitiveSearch")) {
                        if (bibtexEntry.getField(string2).contains(string)) {
                            bl = true;
                        }
                    } else if (bibtexEntry.getField(string2).toLowerCase().contains(string.toLowerCase())) {
                        bl = true;
                    }
                    if (!bl) continue;
                    this.hitInField = string2;
                    return true;
                }
                catch (Throwable throwable) {
                    System.err.println("Searching error: " + throwable);
                }
            }
        }
        return false;
    }
}

