/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class NetworkTab
extends JPanel
implements PrefsTab {
    private final JCheckBox useProxy;
    private final JTextField defProxyHostname;
    private final JTextField defProxyPort;
    private final JabRefPreferences _prefs;

    public NetworkTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this.setLayout(new BorderLayout());
        this.useProxy = new JCheckBox(Globals.lang("Use custom proxy configuration"));
        this.defProxyHostname = new JTextField();
        this.defProxyHostname.setEnabled(false);
        this.defProxyPort = new JTextField();
        this.defProxyPort.setEnabled(false);
        Insets insets = new Insets(0, 12, 3, 0);
        this.useProxy.setMargin(insets);
        this.defProxyPort.setMargin(insets);
        this.useProxy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NetworkTab.this.defProxyHostname.setEnabled(NetworkTab.this.useProxy.isSelected());
                NetworkTab.this.defProxyPort.setEnabled(NetworkTab.this.useProxy.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("Network"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.useProxy, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        JLabel jLabel = new JLabel(Globals.lang("Host") + ':');
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.defProxyHostname);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        JLabel jLabel2 = new JLabel(Globals.lang("Port") + ':');
        defaultFormBuilder.append(jLabel2);
        defaultFormBuilder.append(this.defProxyPort);
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.useProxy.setSelected(this._prefs.getBoolean("useProxy"));
        this.defProxyHostname.setText(this._prefs.get("proxyHostname"));
        this.defProxyPort.setText(this._prefs.get("proxyPort"));
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("useProxy", this.useProxy.isSelected());
        this._prefs.put("proxyHostname", this.defProxyHostname.getText().trim());
        this._prefs.put("proxyPort", this.defProxyPort.getText().trim());
    }

    @Override
    public boolean readyToClose() {
        boolean bl;
        if (this.useProxy.isSelected()) {
            String string = this.defProxyHostname.getText();
            String string2 = this.defProxyPort.getText();
            if (string == null || string.trim().isEmpty() || string2 == null || string2.trim().isEmpty()) {
                bl = false;
            } else {
                try {
                    Integer n = Integer.parseInt(string2);
                    bl = n > 0;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(null, Globals.lang("Please specify both hostname and port"), Globals.lang("Invalid setting"), 0);
        }
        return bl;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Network");
    }
}

