/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.undo.UndoablePreambleChange;

class PreambleEditor
extends JDialog {
    private final BibtexDatabase base;
    private final BasePanel panel;
    private final JabRefPreferences prefs;
    JLabel lab;
    private FieldEditor ed;
    private final StoreFieldAction storeFieldAction = new StoreFieldAction();
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final CloseAction closeAction = new CloseAction();

    public PreambleEditor(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexDatabase bibtexDatabase, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame);
        JabRefFrame jabRefFrame2 = jabRefFrame;
        this.panel = basePanel;
        this.base = bibtexDatabase;
        this.prefs = jabRefPreferences;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreambleEditor.this.closeAction.actionPerformed(null);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PreambleEditor.this.ed.requestFocus();
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component component) {
                return super.accept(component) && component instanceof FieldEditor;
            }
        });
        int n = (int)(2.0 * (double)GUIGlobals.FORM_HEIGHT[jabRefPreferences.getInt("entryTypeFormHeightFactor")]);
        this.setSize(GUIGlobals.FORM_WIDTH[jabRefPreferences.getInt("entryTypeFormWidth")], n);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        String string = bibtexDatabase.getPreamble();
        this.ed = new FieldTextArea(Globals.lang("Preamble"), string != null ? string : "");
        this.setupJTextComponent((FieldTextArea)this.ed);
        gridBagLayout.setConstraints(this.ed.getLabel(), gridBagConstraints);
        jPanel.add(this.ed.getLabel());
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.ed.getPane(), gridBagConstraints);
        jPanel.add(this.ed.getPane());
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        this.setTitle(Globals.lang("Edit preamble"));
    }

    private void setupJTextComponent(JTextComponent jTextComponent) {
        jTextComponent.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        jTextComponent.getActionMap().put("close", this.closeAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Preamble editor, store changes"), "store");
        jTextComponent.getActionMap().put("store", this.storeFieldAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Close preamble editor"), "close");
        jTextComponent.getActionMap().put("close", this.closeAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Undo"), "undo");
        jTextComponent.getActionMap().put("undo", this.undoAction);
        jTextComponent.getInputMap().put(this.prefs.getKey("Redo"), "redo");
        jTextComponent.getActionMap().put("redo", this.redoAction);
        jTextComponent.addFocusListener(new FieldListener());
    }

    public void updatePreamble() {
        this.ed.setText(this.base.getPreamble());
    }

    public FieldEditor getFieldEditor() {
        return this.ed;
    }

    public void storeCurrentEdit() {
        this.storeFieldAction.actionPerformed(null);
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreambleEditor.this.storeFieldAction.actionPerformed(null);
            PreambleEditor.this.panel.preambleEditorClosing();
            PreambleEditor.this.dispose();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PreambleEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PreambleEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            String string = null;
            if (!PreambleEditor.this.ed.getText().isEmpty()) {
                string = PreambleEditor.this.ed.getText();
            }
            if (string == null) {
                bl = PreambleEditor.this.base.getPreamble() != null;
            } else {
                boolean bl2 = bl = PreambleEditor.this.base.getPreamble() == null || !string.equals(PreambleEditor.this.base.getPreamble());
            }
            if (bl) {
                ((PreambleEditor)PreambleEditor.this).panel.undoManager.addEdit(new UndoablePreambleChange(PreambleEditor.this.base, PreambleEditor.this.panel, PreambleEditor.this.base.getPreamble(), string));
                PreambleEditor.this.base.setPreamble(string);
                if (string != null && !string.isEmpty()) {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.entryEditorLabelColor);
                    PreambleEditor.this.ed.setValidBackgroundColor();
                } else {
                    PreambleEditor.this.ed.setLabelColor(GUIGlobals.nullFieldColor);
                    PreambleEditor.this.ed.setValidBackgroundColor();
                }
                if (PreambleEditor.this.ed.getTextComponent().hasFocus()) {
                    PreambleEditor.this.ed.setActiveBackgroundColor();
                }
                PreambleEditor.this.panel.markBaseChanged();
            }
        }
    }

    private class FieldListener
    extends FocusAdapter {
        private FieldListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                PreambleEditor.this.storeFieldAction.actionPerformed(new ActionEvent(focusEvent.getSource(), 0, ""));
            }
        }
    }
}

