/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternPanel;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class TabLabelPattern
extends LabelPatternPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JCheckBox dontOverwrite = new JCheckBox(Globals.lang("Do not overwrite existing keys"));
    private final JCheckBox warnBeforeOverwriting = new JCheckBox(Globals.lang("Warn before overwriting existing keys"));
    private final JCheckBox generateOnSave = new JCheckBox(Globals.lang("Generate keys before saving (for entries without a key)"));
    private final JCheckBox autoGenerateOnImport = new JCheckBox(Globals.lang("Generate keys for imported entries"));
    private final JRadioButton letterStartA = new JRadioButton(Globals.lang("Ensure unique keys using letters (a, b, ...)"));
    private final JRadioButton letterStartB = new JRadioButton(Globals.lang("Ensure unique keys using letters (b, c, ...)"));
    private final JRadioButton alwaysAddLetter = new JRadioButton(Globals.lang("Always add letter (a, b, ...) to generated keys"));
    private final JTextField KeyPatternRegex = new JTextField(20);
    private final JTextField KeyPatternReplacement = new JTextField(20);

    public TabLabelPattern(JabRefPreferences jabRefPreferences, HelpDialog helpDialog) {
        super(helpDialog);
        this._prefs = jabRefPreferences;
        this.appendKeyGeneratorSettings();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("defaultLabelPattern", this.defaultPat.getText());
        Globals.prefs.putBoolean("warnBeforeOverwritingKey", this.warnBeforeOverwriting.isSelected());
        Globals.prefs.putBoolean("avoidOverwritingKey", this.dontOverwrite.isSelected());
        Globals.prefs.put("KeyPatternRegex", this.KeyPatternRegex.getText());
        Globals.prefs.put("KeyPatternReplacement", this.KeyPatternReplacement.getText());
        Globals.prefs.putBoolean("generateKeysAfterInspection", this.autoGenerateOnImport.isSelected());
        Globals.prefs.putBoolean("generateKeysBeforeSaving", this.generateOnSave.isSelected());
        if (this.alwaysAddLetter.isSelected()) {
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", true);
        } else if (this.letterStartA.isSelected()) {
            Globals.prefs.putBoolean("keyGenFirstLetterA", true);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        } else {
            Globals.prefs.putBoolean("keyGenFirstLetterA", false);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        }
        LabelPatternUtil.updateDefaultPattern();
        LabelPattern labelPattern = this._prefs.getKeyPattern().getParent();
        LabelPattern labelPattern2 = this.getLabelPattern();
        labelPattern2.setParent(labelPattern);
        this._prefs.putKeyPattern(labelPattern2);
    }

    private void appendKeyGeneratorSettings() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.letterStartA);
        buttonGroup.add(this.letterStartB);
        buttonGroup.add(this.alwaysAddLetter);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 8dlu, left:pref", "");
        JPanel jPanel = new JPanel();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("Key generator settings"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.autoGenerateOnImport);
        defaultFormBuilder.append(this.letterStartA);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.warnBeforeOverwriting);
        defaultFormBuilder.append(this.letterStartB);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.dontOverwrite);
        defaultFormBuilder.append(this.alwaysAddLetter);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.generateOnSave);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(Globals.lang("Replace (regular expression)") + ':');
        defaultFormBuilder.append(Globals.lang("by") + ':');
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.KeyPatternRegex);
        defaultFormBuilder.append(this.KeyPatternReplacement);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(defaultFormBuilder.getPanel(), this.con);
        this.add(defaultFormBuilder.getPanel());
        this.dontOverwrite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TabLabelPattern.this.warnBeforeOverwriting.setEnabled(!TabLabelPattern.this.dontOverwrite.isSelected());
            }
        });
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public void setValues() {
        super.setValues(this._prefs.getKeyPattern());
        this.defaultPat.setText(Globals.prefs.get("defaultLabelPattern"));
        this.dontOverwrite.setSelected(Globals.prefs.getBoolean("avoidOverwritingKey"));
        this.generateOnSave.setSelected(Globals.prefs.getBoolean("generateKeysBeforeSaving"));
        this.autoGenerateOnImport.setSelected(Globals.prefs.getBoolean("generateKeysAfterInspection"));
        this.warnBeforeOverwriting.setSelected(Globals.prefs.getBoolean("warnBeforeOverwritingKey"));
        boolean bl = Globals.prefs.getBoolean("keyGenAlwaysAddLetter");
        boolean bl2 = Globals.prefs.getBoolean("keyGenFirstLetterA");
        if (bl) {
            this.alwaysAddLetter.setSelected(true);
        } else if (bl2) {
            this.letterStartA.setSelected(true);
        } else {
            this.letterStartB.setSelected(true);
        }
        this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected());
        this.KeyPatternRegex.setText(Globals.prefs.get("KeyPatternRegex"));
        this.KeyPatternReplacement.setText(Globals.prefs.get("KeyPatternReplacement"));
    }

    @Override
    public String getTabName() {
        return Globals.lang("BibTeX key generator");
    }
}

