/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.help.HelpAction;

class TableColumnsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private boolean tableChanged = false;
    private final JTable colSetup;
    private int rowCount = -1;
    private int ncWidth = -1;
    private final Vector<TableRow> tableRows = new Vector(10);
    private final JabRefFrame frame;
    private final JCheckBox pdfColumn;
    private final JCheckBox urlColumn;
    private final JCheckBox fileColumn;
    private final JCheckBox arxivColumn;
    private final JCheckBox extraFileColumns;
    private JList listOfFileColumns;
    private final JRadioButton preferUrl;
    private final JRadioButton preferDoi;
    private final JCheckBox showOneLetterHeadingForIconColumns;
    private final JCheckBox specialFieldsEnabled;
    private JCheckBox rankingColumn;
    private JCheckBox compactRankingColumn;
    private JCheckBox qualityColumn;
    private JCheckBox priorityColumn;
    private JCheckBox relevanceColumn;
    private JCheckBox printedColumn;
    private JCheckBox readStatusColumn;
    private JRadioButton syncKeywords;
    private JRadioButton writeSpecialFields;
    private boolean oldSpecialFieldsEnabled;
    private boolean oldRankingColumn;
    private boolean oldCompcatRankingColumn;
    private boolean oldQualityColumn;
    private boolean oldPriorityColumn;
    private boolean oldRelevanceColumn;
    private boolean oldPrintedColumn;
    private boolean oldReadStatusColumn;
    private boolean oldSyncKeyWords;
    private boolean oldWriteSpecialFields;

    public TableColumnsTab(JabRefPreferences jabRefPreferences, JabRefFrame jabRefFrame) {
        this._prefs = jabRefPreferences;
        this.frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableColumnsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n == 0) {
                    return n2 == 0 ? "#" : "" + TableColumnsTab.this.ncWidth;
                }
                if (--n >= TableColumnsTab.this.tableRows.size()) {
                    return "";
                }
                Object e = TableColumnsTab.this.tableRows.elementAt(n);
                if (e == null) {
                    return "";
                }
                TableRow tableRow = (TableRow)e;
                switch (n2) {
                    case 0: {
                        return tableRow.name;
                    }
                    case 1: {
                        return tableRow.length > 0 ? Integer.toString(tableRow.length) : "";
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                return n == 0 ? Globals.lang("Field name") : Globals.lang("Column width");
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return String.class;
                }
                return Integer.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n != 0 || n2 != 0;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                TableColumnsTab.this.tableChanged = true;
                while (n >= TableColumnsTab.this.tableRows.size()) {
                    TableColumnsTab.this.tableRows.add(new TableRow("", -1));
                }
                if (n == 0 && n2 == 1) {
                    TableColumnsTab.this.ncWidth = Integer.parseInt(object.toString());
                    return;
                }
                TableRow tableRow = (TableRow)TableColumnsTab.this.tableRows.elementAt(n - 1);
                if (n2 == 0) {
                    tableRow.name = object.toString();
                    if (this.getValueAt(n, 1).equals("")) {
                        this.setValueAt("100", n, 1);
                    }
                } else {
                    tableRow.length = object == null ? -1 : Integer.parseInt(object.toString());
                }
            }
        };
        this.colSetup = new JTable(abstractTableModel);
        TableColumnModel tableColumnModel = this.colSetup.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.colSetup, 20, 31);
        this.colSetup.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        AddRowAction addRowAction = new AddRowAction();
        DeleteRowAction deleteRowAction = new DeleteRowAction();
        MoveRowUpAction moveRowUpAction = new MoveRowUpAction();
        MoveRowDownAction moveRowDownAction = new MoveRowDownAction();
        jToolBar.setBorder(null);
        jToolBar.add(addRowAction);
        jToolBar.add(deleteRowAction);
        jToolBar.addSeparator();
        jToolBar.add(moveRowUpAction);
        jToolBar.add(moveRowDownAction);
        jPanel2.add((Component)jToolBar, "East");
        this.showOneLetterHeadingForIconColumns = new JCheckBox(Globals.lang("Show one letter heading for icon columns"));
        this.fileColumn = new JCheckBox(Globals.lang("Show file column"));
        this.pdfColumn = new JCheckBox(Globals.lang("Show PDF/PS column"));
        this.urlColumn = new JCheckBox(Globals.lang("Show URL/DOI column"));
        this.preferUrl = new JRadioButton(Globals.lang("Show URL first"));
        this.preferDoi = new JRadioButton(Globals.lang("Show DOI first"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.preferUrl);
        buttonGroup.add(this.preferDoi);
        this.urlColumn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TableColumnsTab.this.preferUrl.setEnabled(TableColumnsTab.this.urlColumn.isSelected());
                TableColumnsTab.this.preferDoi.setEnabled(TableColumnsTab.this.urlColumn.isSelected());
            }
        });
        this.arxivColumn = new JCheckBox(Globals.lang("Show ArXiv column"));
        this.extraFileColumns = new JCheckBox(Globals.lang("Show Extra columns"));
        this.extraFileColumns.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TableColumnsTab.this.listOfFileColumns.setEnabled(TableColumnsTab.this.extraFileColumns.isSelected());
            }
        });
        ExternalFileType[] externalFileTypeArray = Globals.prefs.getExternalFileTypeSelection();
        String[] stringArray = new String[externalFileTypeArray.length];
        for (int i = 0; i < externalFileTypeArray.length; ++i) {
            stringArray[i] = externalFileTypeArray[i].getName();
        }
        this.listOfFileColumns = new JList<String>(stringArray);
        JScrollPane jScrollPane2 = new JScrollPane(this.listOfFileColumns);
        this.listOfFileColumns.setVisibleRowCount(3);
        HelpAction helpAction = new HelpAction(jabRefFrame.helpDiag, "SpecialFieldsHelp.html");
        JButton jButton = new JButton(GUIGlobals.getImage("helpSmall"));
        jButton.setToolTipText(Globals.lang("Help on special fields"));
        jButton.addActionListener(helpAction);
        this.specialFieldsEnabled = new JCheckBox(Globals.lang("Enable special fields"));
        this.specialFieldsEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = TableColumnsTab.this.specialFieldsEnabled.isSelected();
                TableColumnsTab.this.rankingColumn.setEnabled(bl);
                TableColumnsTab.this.compactRankingColumn.setEnabled(bl && TableColumnsTab.this.rankingColumn.isSelected());
                TableColumnsTab.this.qualityColumn.setEnabled(bl);
                TableColumnsTab.this.priorityColumn.setEnabled(bl);
                TableColumnsTab.this.relevanceColumn.setEnabled(bl);
                TableColumnsTab.this.printedColumn.setEnabled(bl);
                TableColumnsTab.this.readStatusColumn.setEnabled(bl);
                TableColumnsTab.this.syncKeywords.setEnabled(bl);
                TableColumnsTab.this.writeSpecialFields.setEnabled(bl);
            }
        });
        this.rankingColumn = new JCheckBox(Globals.lang("Show rank"));
        this.rankingColumn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TableColumnsTab.this.compactRankingColumn.setEnabled(TableColumnsTab.this.rankingColumn.isSelected());
            }
        });
        this.compactRankingColumn = new JCheckBox(Globals.lang("Compact rank"));
        this.qualityColumn = new JCheckBox(Globals.lang("Show quality"));
        this.priorityColumn = new JCheckBox(Globals.lang("Show priority"));
        this.relevanceColumn = new JCheckBox(Globals.lang("Show relevance"));
        this.printedColumn = new JCheckBox(Globals.lang("Show printed status"));
        this.readStatusColumn = new JCheckBox(Globals.lang("Show read status"));
        this.syncKeywords = new JRadioButton(Globals.lang("Synchronize with keywords"));
        this.writeSpecialFields = new JRadioButton(Globals.lang("Write values of special fields as separate fields to BibTeX"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.syncKeywords);
        buttonGroup2.add(this.writeSpecialFields);
        defaultFormBuilder.appendSeparator(Globals.lang("Special table columns"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("8dlu, 8dlu, 8cm, 8dlu, 8dlu, left:pref:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref"));
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder2.add((Component)this.specialFieldsEnabled, cellConstraints.xyw(1, 1, 3));
        defaultFormBuilder2.add((Component)this.rankingColumn, cellConstraints.xyw(2, 2, 2));
        defaultFormBuilder2.add((Component)this.compactRankingColumn, cellConstraints.xy(3, 3));
        defaultFormBuilder2.add((Component)this.relevanceColumn, cellConstraints.xyw(2, 4, 2));
        defaultFormBuilder2.add((Component)this.qualityColumn, cellConstraints.xyw(2, 5, 2));
        defaultFormBuilder2.add((Component)this.priorityColumn, cellConstraints.xyw(2, 6, 2));
        defaultFormBuilder2.add((Component)this.printedColumn, cellConstraints.xyw(2, 7, 2));
        defaultFormBuilder2.add((Component)this.readStatusColumn, cellConstraints.xyw(2, 8, 2));
        defaultFormBuilder2.add((Component)this.syncKeywords, cellConstraints.xyw(2, 10, 2));
        defaultFormBuilder2.add((Component)this.writeSpecialFields, cellConstraints.xyw(2, 11, 2));
        defaultFormBuilder2.add((Component)this.showOneLetterHeadingForIconColumns, cellConstraints.xyw(1, 12, 4));
        defaultFormBuilder2.add((Component)jButton, cellConstraints.xyw(1, 13, 2));
        defaultFormBuilder2.add((Component)this.fileColumn, cellConstraints.xyw(5, 1, 2));
        defaultFormBuilder2.add((Component)this.pdfColumn, cellConstraints.xyw(5, 2, 2));
        defaultFormBuilder2.add((Component)this.urlColumn, cellConstraints.xyw(5, 3, 2));
        defaultFormBuilder2.add((Component)this.preferUrl, cellConstraints.xy(6, 4));
        defaultFormBuilder2.add((Component)this.preferDoi, cellConstraints.xy(6, 5));
        defaultFormBuilder2.add((Component)this.arxivColumn, cellConstraints.xyw(5, 6, 2));
        defaultFormBuilder2.add((Component)this.extraFileColumns, cellConstraints.xyw(5, 7, 2));
        defaultFormBuilder2.add((Component)jScrollPane2, cellConstraints.xywh(5, 8, 2, 5));
        defaultFormBuilder.append(defaultFormBuilder2.getPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Entry table columns"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        JButton jButton2 = new JButton(new UpdateWidthsAction());
        JButton jButton3 = new JButton(new UpdateOrderAction());
        defaultFormBuilder.append(jButton2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jButton3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        int n;
        Object[] objectArray;
        this.fileColumn.setSelected(this._prefs.getBoolean("fileColumn"));
        this.pdfColumn.setSelected(this._prefs.getBoolean("pdfColumn"));
        this.urlColumn.setSelected(this._prefs.getBoolean("urlColumn"));
        this.preferUrl.setSelected(!this._prefs.getBoolean("preferUrlDoi"));
        this.preferDoi.setSelected(this._prefs.getBoolean("preferUrlDoi"));
        this.fileColumn.setSelected(this._prefs.getBoolean("fileColumn"));
        this.arxivColumn.setSelected(this._prefs.getBoolean("arxivColumn"));
        this.extraFileColumns.setSelected(this._prefs.getBoolean("extraFileColumns"));
        if (this.extraFileColumns.isSelected()) {
            String[] stringArray = this._prefs.getStringArray("listOfFileColumns");
            int n2 = this.listOfFileColumns.getModel().getSize();
            objectArray = new int[n2];
            block0: for (n = 0; n < n2; ++n) {
                objectArray[n] = n2 + 1;
                for (String string : stringArray) {
                    if (!this.listOfFileColumns.getModel().getElementAt(n).equals(string)) continue;
                    objectArray[n] = n;
                    continue block0;
                }
            }
            this.listOfFileColumns.setSelectedIndices((int[])objectArray);
        } else {
            this.listOfFileColumns.setSelectedIndices(new int[0]);
        }
        this.oldRankingColumn = this._prefs.getBoolean("showRankingColumn");
        this.rankingColumn.setSelected(this.oldRankingColumn);
        this.oldCompcatRankingColumn = this._prefs.getBoolean("compactRankingColumn");
        this.compactRankingColumn.setSelected(this.oldCompcatRankingColumn);
        this.oldQualityColumn = this._prefs.getBoolean("showQualityColumn");
        this.qualityColumn.setSelected(this.oldQualityColumn);
        this.oldPriorityColumn = this._prefs.getBoolean("showPriorityColumn");
        this.priorityColumn.setSelected(this.oldPriorityColumn);
        this.oldRelevanceColumn = this._prefs.getBoolean("showRelevanceColumn");
        this.relevanceColumn.setSelected(this.oldRelevanceColumn);
        this.oldPrintedColumn = this._prefs.getBoolean("showPrintedColumn");
        this.printedColumn.setSelected(this.oldPrintedColumn);
        this.oldReadStatusColumn = this._prefs.getBoolean("showReadColumn");
        this.readStatusColumn.setSelected(this.oldReadStatusColumn);
        this.oldSyncKeyWords = this._prefs.getBoolean("autoSyncSpecialFieldsToKeywords");
        this.syncKeywords.setSelected(this.oldSyncKeyWords);
        this.oldWriteSpecialFields = this._prefs.getBoolean("serializeSpecialFields");
        this.writeSpecialFields.setSelected(this.oldWriteSpecialFields);
        this.oldSpecialFieldsEnabled = this._prefs.getBoolean("specialFieldsEnabled");
        this.specialFieldsEnabled.setSelected(!this.oldSpecialFieldsEnabled);
        this.specialFieldsEnabled.setSelected(this.oldSpecialFieldsEnabled);
        boolean bl = this._prefs.getBoolean("showOneLetterHeadingForIconColumns");
        this.showOneLetterHeadingForIconColumns.setSelected(bl);
        this.tableRows.clear();
        String[] stringArray = this._prefs.getStringArray("columnNames");
        objectArray = this._prefs.getStringArray("columnWidths");
        for (n = 0; n < stringArray.length; ++n) {
            if (n < objectArray.length) {
                this.tableRows.add(new TableRow(stringArray[n], Integer.parseInt((String)objectArray[n])));
                continue;
            }
            this.tableRows.add(new TableRow(stringArray[n]));
        }
        this.rowCount = this.tableRows.size() + 5;
        this.ncWidth = this._prefs.getInt("numberColWidth");
    }

    @Override
    public void storeSettings() {
        int n;
        boolean bl;
        boolean bl2;
        this._prefs.putBoolean("fileColumn", this.fileColumn.isSelected());
        this._prefs.putBoolean("pdfColumn", this.pdfColumn.isSelected());
        this._prefs.putBoolean("urlColumn", this.urlColumn.isSelected());
        this._prefs.putBoolean("preferUrlDoi", this.preferDoi.isSelected());
        this._prefs.putBoolean("arxivColumn", this.arxivColumn.isSelected());
        this._prefs.putBoolean("extraFileColumns", this.extraFileColumns.isSelected());
        if (this.extraFileColumns.isSelected() && !this.listOfFileColumns.isSelectionEmpty()) {
            String[] stringArray = new String[this.listOfFileColumns.getSelectedIndices().length];
            for (bl2 = false; bl2 < stringArray.length; bl2 += 1) {
                stringArray[bl2] = (String)this.listOfFileColumns.getModel().getElementAt(this.listOfFileColumns.getSelectedIndices()[bl2]);
            }
            this._prefs.putStringArray("listOfFileColumns", stringArray);
        } else {
            this._prefs.putStringArray("listOfFileColumns", new String[0]);
        }
        this._prefs.putBoolean("showOneLetterHeadingForIconColumns", this.showOneLetterHeadingForIconColumns.isSelected());
        boolean bl3 = this.specialFieldsEnabled.isSelected();
        bl2 = this.rankingColumn.isSelected();
        boolean bl4 = this.compactRankingColumn.isSelected();
        boolean bl5 = this.qualityColumn.isSelected();
        boolean bl6 = this.priorityColumn.isSelected();
        boolean bl7 = this.relevanceColumn.isSelected();
        boolean bl8 = this.printedColumn.isSelected();
        boolean bl9 = this.readStatusColumn.isSelected();
        boolean bl10 = this.syncKeywords.isSelected();
        boolean bl11 = this.writeSpecialFields.isSelected();
        boolean bl12 = bl = this.oldSpecialFieldsEnabled != bl3 || this.oldRankingColumn != bl2 || this.oldCompcatRankingColumn != bl4 || this.oldQualityColumn != bl5 || this.oldPriorityColumn != bl6 || this.oldRelevanceColumn != bl7 || this.oldPrintedColumn != bl8 || this.oldReadStatusColumn != bl9 || this.oldSyncKeyWords != bl10 || this.oldWriteSpecialFields != bl11;
        if (bl) {
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed settings for special fields.").concat(" ").concat(Globals.lang("You must restart JabRef for this to come into effect.")), Globals.lang("Changed special field settings"), 2);
        }
        if (bl) {
            this._prefs.putBoolean("specialFieldsEnabled", bl3);
            this._prefs.putBoolean("showRankingColumn", bl2);
            this._prefs.putBoolean("compactRankingColumn", bl4);
            this._prefs.putBoolean("showPriorityColumn", bl6);
            this._prefs.putBoolean("showQualityColumn", bl5);
            this._prefs.putBoolean("showRelevanceColumn", bl7);
            this._prefs.putBoolean("showPrintedColumn", bl8);
            this._prefs.putBoolean("showReadColumn", bl9);
            this._prefs.putBoolean("autoSyncSpecialFieldsToKeywords", bl10);
            this._prefs.putBoolean("serializeSpecialFields", bl11);
        }
        if (this.colSetup.isEditing()) {
            n = this.colSetup.getEditingColumn();
            int n2 = this.colSetup.getEditingRow();
            this.colSetup.getCellEditor(n2, n).stopCellEditing();
        }
        if (this.tableChanged) {
            n = 0;
            while (n < this.tableRows.size()) {
                if (this.tableRows.elementAt((int)n).name.isEmpty()) {
                    this.tableRows.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            String[] stringArray = new String[this.tableRows.size()];
            String[] stringArray2 = new String[this.tableRows.size()];
            int[] nArray = new int[this.tableRows.size()];
            this._prefs.putInt("numberColWidth", this.ncWidth);
            for (n = 0; n < this.tableRows.size(); ++n) {
                TableRow tableRow = this.tableRows.elementAt(n);
                stringArray[n] = tableRow.name.toLowerCase();
                nArray[n] = tableRow.length;
                stringArray2[n] = "" + tableRow.length;
            }
            this._prefs.putStringArray("columnNames", stringArray);
            this._prefs.putStringArray("columnWidths", stringArray2);
        }
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry table columns");
    }

    class UpdateWidthsAction
    extends AbstractAction {
        public UpdateWidthsAction() {
            super(Globals.lang("Update to current column widths"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasePanel basePanel = TableColumnsTab.this.frame.basePanel();
            if (basePanel == null) {
                return;
            }
            TableColumnModel tableColumnModel = basePanel.mainTable.getColumnModel();
            TableColumnsTab.this.colSetup.setValueAt("" + tableColumnModel.getColumn(0).getWidth(), 0, 1);
            for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
                block6: {
                    try {
                        String string = basePanel.mainTable.getColumnName(i).toLowerCase();
                        int n = tableColumnModel.getColumn(i).getWidth();
                        if (i <= TableColumnsTab.this.tableRows.size() && ((String)TableColumnsTab.this.colSetup.getValueAt(i, 0)).toLowerCase().equals(string)) {
                            TableColumnsTab.this.colSetup.setValueAt("" + n, i, 1);
                            break block6;
                        }
                        for (int j = 0; j < TableColumnsTab.this.colSetup.getRowCount(); ++j) {
                            if (j >= TableColumnsTab.this.tableRows.size() || !((String)TableColumnsTab.this.colSetup.getValueAt(j, 0)).toLowerCase().equals(string)) continue;
                            TableColumnsTab.this.colSetup.setValueAt("" + n, j, 1);
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
            }
        }
    }

    class UpdateOrderAction
    extends AbstractAction {
        public UpdateOrderAction() {
            super(Globals.lang("Update to current column order"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasePanel basePanel = TableColumnsTab.this.frame.basePanel();
            if (basePanel == null) {
                return;
            }
            final HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 1; i < basePanel.mainTable.getColumnCount(); ++i) {
                String string = basePanel.mainTable.getColumnName(i);
                if (string == null || string.isEmpty()) continue;
                hashMap.put(string.toLowerCase(), i);
            }
            Collections.sort(TableColumnsTab.this.tableRows, new Comparator<TableRow>(){

                @Override
                public int compare(TableRow tableRow, TableRow tableRow2) {
                    Integer n = (Integer)hashMap.get(tableRow.name);
                    Integer n2 = (Integer)hashMap.get(tableRow2.name);
                    if (n == null || n2 == null) {
                        return 0;
                    }
                    return n.compareTo(n2);
                }
            });
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class MoveRowDownAction
    extends AbstractMoveRowAction {
        public MoveRowDownAction() {
            super("Down", GUIGlobals.getImage("down"));
            this.putValue("ShortDescription", Globals.lang("Down"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(nArray);
            int n = nArray.length - 1;
            boolean[] blArray = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
            if (nArray.length > 0 && nArray[n] < TableColumnsTab.this.tableRows.size()) {
                int n2;
                for (n2 = n; n2 >= 0; --n2) {
                    this.swap(nArray[n2] - 1, nArray[n2]);
                    blArray[nArray[n2] + 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (n2 = 0; n2 < TableColumnsTab.this.colSetup.getRowCount(); ++n2) {
                    if (blArray[n2]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(n2, n2);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    class MoveRowUpAction
    extends AbstractMoveRowAction {
        public MoveRowUpAction() {
            super("Up", GUIGlobals.getImage("up"));
            this.putValue("ShortDescription", Globals.lang("Move up"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(nArray);
            if (nArray.length > 0 && nArray[0] > 1) {
                boolean[] blArray = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
                for (int n : nArray) {
                    this.swap(n - 1, n - 2);
                    blArray[n - 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (int i = 0; i < TableColumnsTab.this.colSetup.getRowCount(); ++i) {
                    if (blArray[i]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(i, i);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    abstract class AbstractMoveRowAction
    extends AbstractAction {
        public AbstractMoveRowAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        void swap(int n, int n2) {
            if (n < 0 || n >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            if (n2 < 0 || n2 >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            TableRow tableRow = (TableRow)TableColumnsTab.this.tableRows.get(n);
            TableColumnsTab.this.tableRows.set(n, TableColumnsTab.this.tableRows.get(n2));
            TableColumnsTab.this.tableRows.set(n2, tableRow);
        }
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            if (nArray.length == 0) {
                TableColumnsTab.this.rowCount++;
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] + i - 1 >= TableColumnsTab.this.tableRows.size()) continue;
                TableColumnsTab.this.tableRows.add(Math.max(0, nArray[i] + i - 1), new TableRow(100));
            }
            TableColumnsTab.this.rowCount = TableColumnsTab.this.rowCount + nArray.length;
            if (nArray.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] > TableColumnsTab.this.tableRows.size() || nArray[i] == 0) continue;
                TableColumnsTab.this.tableRows.remove(nArray[i] - 1);
                ++n;
            }
            TableColumnsTab.this.rowCount = TableColumnsTab.this.rowCount - n;
            if (nArray.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    static class TableRow {
        String name;
        int length;

        public TableRow(String string) {
            this.name = string;
            this.length = 100;
        }

        public TableRow(int n) {
            this.length = n;
            this.name = "";
        }

        public TableRow(String string, int n) {
            this.name = string;
            this.length = n;
        }
    }
}

