/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class TablePrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JCheckBox autoResizeMode;
    private final JCheckBox priDesc;
    private final JCheckBox secDesc;
    private final JCheckBox terDesc;
    private final JCheckBox floatMarked;
    private final JRadioButton namesAsIs;
    private final JRadioButton namesFf;
    private final JRadioButton namesFl;
    private final JRadioButton namesNatbib;
    private final JRadioButton abbrNames;
    private final JRadioButton noAbbrNames;
    private final JRadioButton lastNamesOnly;
    private final JTextField priField;
    private final JTextField secField;
    private final JTextField terField;
    private final JTextField numericFields;
    private final JComboBox priSort;
    private final JComboBox secSort;
    private final JComboBox terSort;

    public TablePrefsTab(JabRefPreferences jabRefPreferences, JabRefFrame jabRefFrame) {
        this._prefs = jabRefPreferences;
        this.setLayout(new BorderLayout());
        Vector<String> vector = new Vector<String>(Arrays.asList(BibtexFields.getAllFieldNames()));
        vector.add("bibtexkey");
        Collections.sort(vector);
        String[] stringArray = vector.toArray(new String[vector.size()]);
        this.priSort = new JComboBox<String>(stringArray);
        this.secSort = new JComboBox<String>(stringArray);
        this.terSort = new JComboBox<String>(stringArray);
        this.autoResizeMode = new JCheckBox(Globals.lang("Fit table horizontally on screen"));
        this.namesAsIs = new JRadioButton(Globals.lang("Show names unchanged"));
        this.namesFf = new JRadioButton(Globals.lang("Show 'Firstname Lastname'"));
        this.namesFl = new JRadioButton(Globals.lang("Show 'Lastname, Firstname'"));
        this.namesNatbib = new JRadioButton(Globals.lang("Natbib style"));
        this.noAbbrNames = new JRadioButton(Globals.lang("Do not abbreviate names"));
        this.abbrNames = new JRadioButton(Globals.lang("Abbreviate names"));
        this.lastNamesOnly = new JRadioButton(Globals.lang("Show last names only"));
        this.floatMarked = new JCheckBox(Globals.lang("Float marked entries"));
        this.priField = new JTextField(10);
        this.secField = new JTextField(10);
        this.terField = new JTextField(10);
        this.numericFields = new JTextField(30);
        this.priSort.insertItemAt(Globals.lang("<select>"), 0);
        this.secSort.insertItemAt(Globals.lang("<select>"), 0);
        this.terSort.insertItemAt(Globals.lang("<select>"), 0);
        this.priSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TablePrefsTab.this.priSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.priField.setText(TablePrefsTab.this.priSort.getSelectedItem().toString());
                    TablePrefsTab.this.priSort.setSelectedIndex(0);
                }
            }
        });
        this.secSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TablePrefsTab.this.secSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.secField.setText(TablePrefsTab.this.secSort.getSelectedItem().toString());
                    TablePrefsTab.this.secSort.setSelectedIndex(0);
                }
            }
        });
        this.terSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TablePrefsTab.this.terSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.terField.setText(TablePrefsTab.this.terSort.getSelectedItem().toString());
                    TablePrefsTab.this.terSort.setSelectedIndex(0);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.namesAsIs);
        buttonGroup.add(this.namesNatbib);
        buttonGroup.add(this.namesFf);
        buttonGroup.add(this.namesFl);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.lastNamesOnly);
        buttonGroup2.add(this.abbrNames);
        buttonGroup2.add(this.noAbbrNames);
        this.priDesc = new JCheckBox(Globals.lang("Descending"));
        this.secDesc = new JCheckBox(Globals.lang("Descending"));
        this.terDesc = new JCheckBox(Globals.lang("Descending"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        defaultFormBuilder.appendSeparator(Globals.lang("Format of author and editor names"));
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, left:pref", ""));
        defaultFormBuilder2.append(this.namesAsIs);
        defaultFormBuilder2.append(this.noAbbrNames);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(this.namesFf);
        defaultFormBuilder2.append(this.abbrNames);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(this.namesFl);
        defaultFormBuilder2.append(this.lastNamesOnly);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(this.namesNatbib);
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(defaultFormBuilder2.getPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Default sort criteria"));
        FormLayout formLayout2 = new FormLayout("left:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        DefaultFormBuilder defaultFormBuilder3 = new DefaultFormBuilder(formLayout2);
        JLabel jLabel = new JLabel(Globals.lang("Primary sort criterion"));
        defaultFormBuilder3.append(jLabel);
        defaultFormBuilder3.append(this.priSort);
        defaultFormBuilder3.append(this.priField);
        defaultFormBuilder3.append(this.priDesc);
        defaultFormBuilder3.nextLine();
        jLabel = new JLabel(Globals.lang("Secondary sort criterion"));
        defaultFormBuilder3.append(jLabel);
        defaultFormBuilder3.append(this.secSort);
        defaultFormBuilder3.append(this.secField);
        defaultFormBuilder3.append(this.secDesc);
        defaultFormBuilder3.nextLine();
        jLabel = new JLabel(Globals.lang("Tertiary sort criterion"));
        defaultFormBuilder3.append(jLabel);
        defaultFormBuilder3.append(this.terSort);
        defaultFormBuilder3.append(this.terField);
        defaultFormBuilder3.append(this.terDesc);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(defaultFormBuilder3.getPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.floatMarked);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder3 = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, fill:pref", ""));
        defaultFormBuilder3.append(Globals.lang("Sort the following fields as numeric fields") + ':');
        defaultFormBuilder3.append(this.numericFields);
        defaultFormBuilder.append((Component)defaultFormBuilder3.getPanel(), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("General"));
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.autoResizeMode);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
        this.namesNatbib.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TablePrefsTab.this.abbrNames.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
                TablePrefsTab.this.lastNamesOnly.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
                TablePrefsTab.this.noAbbrNames.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
            }
        });
    }

    @Override
    public void setValues() {
        this.autoResizeMode.setSelected(this._prefs.getInt("autoResizeMode") == 4);
        this.priField.setText(this._prefs.get("priSort"));
        this.secField.setText(this._prefs.get("secSort"));
        this.terField.setText(this._prefs.get("terSort"));
        this.priSort.setSelectedIndex(0);
        this.secSort.setSelectedIndex(0);
        this.terSort.setSelectedIndex(0);
        if (this._prefs.getBoolean("namesAsIs")) {
            this.namesAsIs.setSelected(true);
        } else if (this._prefs.getBoolean("namesFf")) {
            this.namesFf.setSelected(true);
        } else if (this._prefs.getBoolean("namesNatbib")) {
            this.namesNatbib.setSelected(true);
        } else {
            this.namesFl.setSelected(true);
        }
        if (this._prefs.getBoolean("abbrAuthorNames")) {
            this.abbrNames.setSelected(true);
        } else if (this._prefs.getBoolean("namesLastOnly")) {
            this.lastNamesOnly.setSelected(true);
        } else {
            this.noAbbrNames.setSelected(true);
        }
        this.priDesc.setSelected(this._prefs.getBoolean("priDescending"));
        this.secDesc.setSelected(this._prefs.getBoolean("secDescending"));
        this.terDesc.setSelected(this._prefs.getBoolean("terDescending"));
        this.floatMarked.setSelected(this._prefs.getBoolean("floatMarkedEntries"));
        this.abbrNames.setEnabled(!this.namesNatbib.isSelected());
        this.lastNamesOnly.setEnabled(!this.namesNatbib.isSelected());
        this.noAbbrNames.setEnabled(!this.namesNatbib.isSelected());
        String string = this._prefs.get("numericFields");
        if (string == null) {
            this.numericFields.setText("");
        } else {
            this.numericFields.setText(string);
        }
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("namesAsIs", this.namesAsIs.isSelected());
        this._prefs.putBoolean("namesFf", this.namesFf.isSelected());
        this._prefs.putBoolean("namesNatbib", this.namesNatbib.isSelected());
        this._prefs.putBoolean("namesLastOnly", this.lastNamesOnly.isSelected());
        this._prefs.putBoolean("abbrAuthorNames", this.abbrNames.isSelected());
        this._prefs.putInt("autoResizeMode", this.autoResizeMode.isSelected() ? 4 : 0);
        this._prefs.putBoolean("priDescending", this.priDesc.isSelected());
        this._prefs.putBoolean("secDescending", this.secDesc.isSelected());
        this._prefs.putBoolean("terDescending", this.terDesc.isSelected());
        this._prefs.put("priSort", this.priField.getText().toLowerCase().trim());
        this._prefs.put("secSort", this.secField.getText().toLowerCase().trim());
        this._prefs.put("terSort", this.terField.getText().toLowerCase().trim());
        this._prefs.putBoolean("floatMarkedEntries", this.floatMarked.isSelected());
        String string = this._prefs.get("numericFields");
        String string2 = this.numericFields.getText().trim();
        if (string2.isEmpty()) {
            string2 = null;
        }
        if (string2 != null && string == null || string2 == null && string != null || string2 != null && !string2.equals(string)) {
            this._prefs.put("numericFields", string2);
            BibtexFields.setNumericFieldsFromPrefs();
        }
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry table");
    }
}

