/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

class NameFieldAutoCompleter
extends AbstractAutoCompleter {
    private final String[] fieldNames;
    private final boolean lastNameOnlyAndSeparationBySpace;
    private final boolean autoCompFF;
    private final boolean autoCompLF;
    private final boolean autoCompFullFirstOnly;
    private final boolean autoCompShortFirstOnly;
    private String prefix = "";

    NameFieldAutoCompleter(String string) {
        this(new String[]{string}, false);
    }

    public NameFieldAutoCompleter(String[] stringArray, boolean bl) {
        this.fieldNames = stringArray;
        this.lastNameOnlyAndSeparationBySpace = bl;
        if (Globals.prefs.getBoolean("autoCompFF")) {
            this.autoCompFF = true;
            this.autoCompLF = false;
        } else if (Globals.prefs.getBoolean("autoCompLF")) {
            this.autoCompFF = false;
            this.autoCompLF = true;
        } else {
            this.autoCompFF = true;
            this.autoCompLF = true;
        }
        this.autoCompShortFirstOnly = Globals.prefs.get("autoCompFirstNameMode").equals("abbrOnly");
        this.autoCompFullFirstOnly = Globals.prefs.get("autoCompFirstNameMode").equals("fullOnly");
    }

    @Override
    public boolean isSingleUnitField() {
        return !this.lastNameOnlyAndSeparationBySpace;
    }

    @Override
    public void addBibtexEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry == null) {
            return;
        }
        for (String string : this.fieldNames) {
            String string2 = bibtexEntry.getField(string);
            if (string2 == null) continue;
            AuthorList authorList = AuthorList.getAuthorList(string2);
            for (int i = 0; i < authorList.size(); ++i) {
                AuthorList.Author author = authorList.getAuthor(i);
                if (this.lastNameOnlyAndSeparationBySpace) {
                    this.addWordToIndex(author.getLastOnly());
                    continue;
                }
                if (this.autoCompLF) {
                    if (this.autoCompShortFirstOnly) {
                        this.addWordToIndex(author.getLastFirst(true));
                    } else if (this.autoCompFullFirstOnly) {
                        this.addWordToIndex(author.getLastFirst(false));
                    } else {
                        this.addWordToIndex(author.getLastFirst(true));
                        this.addWordToIndex(author.getLastFirst(false));
                    }
                }
                if (!this.autoCompFF) continue;
                if (this.autoCompShortFirstOnly) {
                    this.addWordToIndex(author.getFirstLast(true));
                    continue;
                }
                if (this.autoCompFullFirstOnly) {
                    this.addWordToIndex(author.getFirstLast(false));
                    continue;
                }
                this.addWordToIndex(author.getFirstLast(true));
                this.addWordToIndex(author.getFirstLast(false));
            }
        }
    }

    private String determinePrefixAndReturnRemainder(String string, String string2) {
        int n = string.toLowerCase().lastIndexOf(string2);
        if (n >= 0) {
            this.prefix = string.substring(0, n + string2.length());
            string = string.substring(n + string2.length());
        } else {
            this.prefix = "";
        }
        return string;
    }

    @Override
    public String[] complete(String string) {
        string = this.lastNameOnlyAndSeparationBySpace ? this.determinePrefixAndReturnRemainder(string, " ") : this.determinePrefixAndReturnRemainder(string, " and ");
        return super.complete(string);
    }

    public String getFieldName() {
        return this.fieldNames[0];
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }
}

