/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;

class EntryAddChange
extends Change {
    private final BibtexEntry diskEntry;
    private final JScrollPane sp;

    public EntryAddChange(BibtexEntry bibtexEntry) {
        super("Added entry");
        this.diskEntry = bibtexEntry;
        PreviewPanel previewPanel = new PreviewPanel(null, bibtexEntry, null, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(previewPanel);
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        this.diskEntry.setId(IdGenerator.next());
        basePanel.database().insertEntry(this.diskEntry);
        bibtexDatabase.insertEntry(this.diskEntry);
        namedCompound.addEdit(new UndoableInsertEntry(basePanel.database(), this.diskEntry, basePanel));
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

