/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;

class MetaDataChange
extends Change {
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int MODIFY = 3;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private final MetaData md;
    private final MetaData mdSecondary;
    private final ArrayList<MetaDataChangeUnit> changes = new ArrayList();

    public MetaDataChange(MetaData metaData, MetaData metaData2) {
        super(Globals.lang("Metadata change"));
        this.md = metaData;
        this.mdSecondary = metaData2;
        this.tp.setText("<html>" + Globals.lang("Metadata change") + "</html>");
    }

    public int getChangeCount() {
        return this.changes.size();
    }

    public void insertMetaDataAddition(String string, Vector<String> vector) {
        this.changes.add(new MetaDataChangeUnit(1, string, vector));
    }

    public void insertMetaDataRemoval(String string) {
        this.changes.add(new MetaDataChangeUnit(2, string, null));
    }

    public void insertMetaDataChange(String string, Vector<String> vector) {
        this.changes.add(new MetaDataChangeUnit(3, string, vector));
    }

    @Override
    JComponent description() {
        StringBuilder stringBuilder = new StringBuilder("<html>" + Globals.lang("Changes have been made to the following metadata elements") + ":<p>");
        for (MetaDataChangeUnit metaDataChangeUnit : this.changes) {
            stringBuilder.append("<br>&nbsp;&nbsp;");
            stringBuilder.append(metaDataChangeUnit.key);
        }
        stringBuilder.append("</html>");
        this.tp.setText(stringBuilder.toString());
        return this.sp;
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        for (MetaDataChangeUnit metaDataChangeUnit : this.changes) {
            switch (metaDataChangeUnit.type) {
                case 1: {
                    this.md.putData(metaDataChangeUnit.key, metaDataChangeUnit.value);
                    this.mdSecondary.putData(metaDataChangeUnit.key, metaDataChangeUnit.value);
                    break;
                }
                case 2: {
                    this.md.remove(metaDataChangeUnit.key);
                    this.mdSecondary.remove(metaDataChangeUnit.key);
                    break;
                }
                case 3: {
                    this.md.putData(metaDataChangeUnit.key, metaDataChangeUnit.value);
                    this.mdSecondary.putData(metaDataChangeUnit.key, metaDataChangeUnit.value);
                }
            }
        }
        return true;
    }

    static class MetaDataChangeUnit {
        final int type;
        final String key;
        final Vector<String> value;

        public MetaDataChangeUnit(int n, String string, Vector<String> vector) {
            this.type = n;
            this.key = string;
            this.value = vector;
        }
    }
}

