/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.util.Vector;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.export.FieldFormatter;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class LatexFieldFormatter
implements FieldFormatter {
    private StringBuffer sb;
    private final boolean neverFailOnHashes;
    private final boolean resolveStringsAllFields;
    private final char valueDelimitersZero;
    private final char valueDelimitersOne;
    private final boolean writefieldWrapfield;
    private final String[] doNotResolveStringsFors;

    public static LatexFieldFormatter buildIgnoreHashes() {
        return new LatexFieldFormatter(true);
    }

    public LatexFieldFormatter() {
        this(true);
    }

    private LatexFieldFormatter(boolean bl) {
        this.neverFailOnHashes = bl;
        this.resolveStringsAllFields = Globals.prefs.getBoolean("resolveStringsAllFields");
        this.valueDelimitersZero = Globals.prefs.getValueDelimiters(0);
        this.valueDelimitersOne = Globals.prefs.getValueDelimiters(1);
        this.doNotResolveStringsFors = Globals.prefs.getStringArray("doNotResolveStringsFor");
        this.writefieldWrapfield = Globals.prefs.getBoolean("wrapFieldLine");
    }

    @Override
    public String format(String string, String string2) throws IllegalArgumentException {
        int n;
        int n2;
        if (string == null) {
            return this.valueDelimitersZero + "" + this.valueDelimitersOne;
        }
        if (Globals.prefs.putBracesAroundCapitals(string2) && !"__string".equals(string2)) {
            string = Util.putBracesAroundCapitals(string);
        }
        if (!string.contains(Globals.NEWLINE) && string.contains("\n")) {
            string = string.replaceAll("\n", Globals.NEWLINE);
        }
        boolean bl = true;
        if (this.resolveStringsAllFields) {
            String[] stringArray;
            String[] stringArray2 = stringArray = this.doNotResolveStringsFors;
            n2 = stringArray2.length;
            for (n = 0; n < n2; ++n) {
                String string3 = stringArray2[n];
                if (!string3.equals(string2)) continue;
                bl = false;
                break;
            }
        } else {
            boolean bl2 = bl = BibtexFields.isStandardField(string2) || "__string".equals(string2);
        }
        if (!bl) {
            int n3 = 0;
            boolean bl3 = true;
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = string.charAt(n2);
                if (n == 123) {
                    ++n3;
                }
                if (n == 125) {
                    --n3;
                }
                if (n3 >= 0) continue;
                bl3 = false;
                break;
            }
            if (n3 > 0) {
                bl3 = false;
            }
            if (!bl3) {
                throw new IllegalArgumentException("Curly braces { and } must be balanced.");
            }
            this.sb = new StringBuffer(this.valueDelimitersZero + "");
            if (this.writefieldWrapfield && !Globals.prefs.isNonWrappableField(string2)) {
                this.sb.append(StringUtil.wrap(string, 65));
            } else {
                this.sb.append(string);
            }
            this.sb.append(this.valueDelimitersOne);
            return this.sb.toString();
        }
        this.sb = new StringBuffer();
        int n4 = 0;
        this.checkBraces(string);
        while (n4 < string.length()) {
            n = n4;
            int n5 = n4;
            while (n == n5) {
                n5 = string.indexOf(35, n);
                if (n5 > 0 && string.charAt(n5 - 1) == '\\') {
                    n = n5 + 1;
                    ++n5;
                    continue;
                }
                n = n5 - 1;
            }
            if (n5 == -1) {
                n5 = string.length();
                n2 = -1;
            } else {
                n2 = string.indexOf(35, n5 + 1);
                if (n2 == -1) {
                    if (!this.neverFailOnHashes) {
                        throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX strings unless escaped as in '\\#'.") + '\n' + Globals.lang("In JabRef, use pairs of # characters to indicate a string.") + '\n' + Globals.lang("Note that the entry causing the problem has been selected."));
                    }
                    n5 = string.length();
                }
            }
            if (n5 > n4) {
                this.writeText(string, n4, n5);
            }
            if (n5 < string.length() && n2 - 1 > n5) {
                this.writeStringLabel(string, n5 + 1, n2, n5 == n4, n2 + 1 == string.length());
            }
            if (n2 > -1) {
                n4 = n2 + 1;
                continue;
            }
            n4 = n5 + 1;
        }
        if (this.writefieldWrapfield && !Globals.prefs.isNonWrappableField(string2)) {
            return StringUtil.wrap(this.sb.toString(), 65);
        }
        return this.sb.toString();
    }

    private void writeText(String string, int n, int n2) {
        this.sb.append(this.valueDelimitersZero);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) && (bl || bl2)) {
                bl2 = true;
                if (!bl4) {
                    stringBuilder.append(c);
                }
            } else if ((!Character.isWhitespace(c) || !bl3 && !bl4) && bl2) {
                if (c == '[') {
                    bl4 = true;
                } else if (bl4 && c == ']') {
                    bl4 = false;
                } else if (!bl4 && c == '{') {
                    bl2 = false;
                    bl3 = true;
                } else {
                    stringBuilder.delete(0, stringBuilder.length());
                    bl2 = false;
                }
            }
            if (bl3 && c == '}') {
                if (stringBuilder.toString().equals("begin")) {
                    ++n3;
                }
                if (n3 > 0 && stringBuilder.toString().equals("end")) {
                    --n3;
                }
                stringBuilder.delete(0, stringBuilder.length());
                bl3 = false;
            }
            if (!(c != '&' || bl || bl3 && stringBuilder.toString().equals("url") || n3 != 0)) {
                this.sb.append("\\&");
            } else {
                this.sb.append(c);
            }
            bl = c == '\\';
        }
        this.sb.append(this.valueDelimitersOne);
    }

    private void writeStringLabel(String string, int n, int n2, boolean bl, boolean bl2) {
        this.putIn((bl ? "" : " # ") + string.substring(n, n2) + (bl2 ? "" : " # "));
    }

    private void putIn(String string) {
        this.sb.append(StringUtil.wrap(string, 65));
    }

    private void checkBraces(String string) throws IllegalArgumentException {
        Vector<Integer> vector = new Vector<Integer>(5, 3);
        Vector<Integer> vector2 = new Vector<Integer>(5, 3);
        int n = -1;
        while ((n = string.indexOf(123, n + 1)) != -1) {
            vector.add(n);
        }
        while ((n = string.indexOf(125, n + 1)) != -1) {
            vector2.add(n);
        }
        if (!vector2.isEmpty() && vector.isEmpty()) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (!vector2.isEmpty() && (Integer)vector2.elementAt(0) < (Integer)vector.elementAt(0)) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("Braces don't match.");
        }
    }
}

