/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.GUIGlobals;

public class ExternalFileType
implements Comparable<ExternalFileType> {
    private String name;
    String extension;
    private String openWith;
    private String iconName;
    private String mimeType;
    private ImageIcon icon;
    private final JLabel label = new JLabel();

    public ExternalFileType(String string, String string2, String string3, String string4, String string5) {
        this.label.setText(null);
        this.name = string;
        this.label.setToolTipText(this.name);
        this.extension = string2;
        this.mimeType = string3;
        this.openWith = string4;
        this.setIconName(string5);
    }

    public ExternalFileType(String[] stringArray) {
        if (stringArray == null || stringArray.length < 4) {
            throw new IllegalArgumentException("Cannot contruct ExternalFileType without four elements in String[] argument.");
        }
        this.name = stringArray[0];
        this.label.setToolTipText(this.name);
        this.extension = stringArray[1];
        this.label.setText(null);
        if (stringArray.length == 4) {
            this.openWith = stringArray[2];
            this.setIconName(stringArray[3]);
        } else if (stringArray.length == 5) {
            this.mimeType = stringArray[2];
            this.openWith = stringArray[3];
            this.setIconName(stringArray[4]);
        }
    }

    public String[] getStringArrayRepresentation() {
        return new String[]{this.name, this.extension, this.mimeType, this.openWith, this.iconName};
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.label.setToolTipText(this.name);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getFieldName() {
        return this.extension;
    }

    public String getOpenWith() {
        return this.openWith;
    }

    public void setOpenWith(String string) {
        this.openWith = string;
    }

    public void setIconName(String string) {
        this.iconName = string;
        try {
            this.icon = GUIGlobals.getImage(this.iconName);
        }
        catch (NullPointerException nullPointerException) {
            this.icon = null;
        }
        this.label.setIcon(this.icon);
    }

    public JLabel getIconLabel() {
        return this.label;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ExternalFileType externalFileType) {
        return this.getName().compareTo(externalFileType.getName());
    }

    public ExternalFileType copy() {
        return new ExternalFileType(this.name, this.extension, this.mimeType, this.openWith, this.iconName);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        ExternalFileType externalFileType = (ExternalFileType)object;
        if (externalFileType == null) {
            return false;
        }
        return (this.name == null ? externalFileType.name == null : this.name.equals(externalFileType.name)) && (this.extension == null ? externalFileType.extension == null : this.extension.equals(externalFileType.extension)) && (this.mimeType == null ? externalFileType.mimeType == null : this.mimeType.equals(externalFileType.mimeType)) && (this.openWith == null ? externalFileType.openWith == null : this.openWith.equals(externalFileType.openWith)) && (this.iconName == null ? externalFileType.iconName == null : this.iconName.equals(externalFileType.iconName));
    }
}

