/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.external.ACSPdfDownload;
import net.sf.jabref.external.FullTextFinder;
import net.sf.jabref.external.ScienceDirectPdfDownload;
import net.sf.jabref.external.SpringerLinkPdfDownload;
import net.sf.jabref.util.DOIUtil;

public class FindFullText {
    private static final int FOUND_PDF = 0;
    public static final int WRONG_MIME_TYPE = 1;
    public static final int UNKNOWN_DOMAIN = 2;
    public static final int LINK_NOT_FOUND = 3;
    public static final int IO_EXCEPTION = 4;
    public static final int NO_URLS_DEFINED = 5;
    private final List<FullTextFinder> finders = new ArrayList<FullTextFinder>();

    public FindFullText() {
        this.finders.add(new ScienceDirectPdfDownload());
        this.finders.add(new SpringerLinkPdfDownload());
        this.finders.add(new ACSPdfDownload());
    }

    public FindResult findFullText(BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getField("url");
        String string2 = bibtexEntry.getField("doi");
        if (string2 != null && string2.trim().length() > 0) {
            string2 = DOIUtil.getDOI(string2);
            FindResult findResult = this.lookForFullTextAtURL("http://dx.doi.org/" + string2);
            if (findResult.status == 0) {
                return findResult;
            }
            if (string != null && string.trim().length() > 0) {
                FindResult findResult2 = this.lookForFullTextAtURL(string);
                if (findResult2.status == 0) {
                    return findResult2;
                }
                return findResult;
            }
            return findResult;
        }
        if (string != null && string.trim().length() > 0) {
            return this.lookForFullTextAtURL(string);
        }
        return new FindResult(5, null);
    }

    /*
     * Exception decompiling
     */
    private FindResult lookForFullTextAtURL(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 7[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL resolveRedirects(URL uRL, int n) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            String string = httpURLConnection.getHeaderField("location");
            httpURLConnection.disconnect();
            if (n2 == 302 && n < 5) {
                try {
                    URL uRL2 = new URL(string);
                    return this.resolveRedirects(uRL2, n + 1);
                }
                catch (MalformedURLException malformedURLException) {
                    return uRL;
                }
            }
            return uRL;
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadPage(URL uRL) throws IOException {
        Reader reader = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                int n;
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.connect();
                reader = new InputStreamReader(httpURLConnection.getInputStream());
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = reader.read()) != -1) {
                    stringBuilder.append((char)n);
                }
                String string = stringBuilder.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void dumpToFile(String string, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static class FindResult {
        public final URL url;
        public String host = null;
        public final int status;

        public FindResult(URL uRL, URL uRL2) {
            this.url = uRL;
            this.status = 0;
            if (uRL2 != null) {
                this.host = uRL2.getHost();
            }
        }

        public FindResult(int n, URL uRL) {
            this.url = null;
            this.status = n;
            if (uRL != null) {
                this.host = uRL.getHost();
            }
        }
    }
}

