/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.IOException;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.FindFullText;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.UndoableFieldChange;

public class FindFullTextAction
extends AbstractWorker {
    private final BasePanel basePanel;
    private BibtexEntry entry = null;
    private FindFullText.FindResult result = null;

    public FindFullTextAction(BasePanel basePanel) {
        this.basePanel = basePanel;
    }

    @Override
    public void init() throws Throwable {
        this.basePanel.output(Globals.lang("Looking for full text document..."));
    }

    @Override
    public void run() {
        this.entry = this.basePanel.getSelectedEntries()[0];
        FindFullText findFullText = new FindFullText();
        this.result = findFullText.findFullText(this.entry);
    }

    @Override
    public void update() {
        if (this.result.url != null) {
            String string = this.entry.getCiteKey();
            String[] stringArray = this.basePanel.metaData().getFileDirectory("file");
            if (stringArray.length == 0) {
                return;
            }
            DownloadExternalFile downloadExternalFile = new DownloadExternalFile(this.basePanel.frame(), this.basePanel.metaData(), string);
            try {
                downloadExternalFile.download(this.result.url, new DownloadExternalFile.DownloadCallback(){

                    @Override
                    public void downloadComplete(FileListEntry fileListEntry) {
                        System.out.println("finished");
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        String string = FindFullTextAction.this.entry.getField("file");
                        fileListTableModel.setContent(string);
                        fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
                        String string2 = fileListTableModel.getStringRepresentation();
                        UndoableFieldChange undoableFieldChange = new UndoableFieldChange(FindFullTextAction.this.entry, "file", string, string2);
                        FindFullTextAction.this.entry.setField("file", string2);
                        ((FindFullTextAction)FindFullTextAction.this).basePanel.undoManager.addEdit(undoableFieldChange);
                        FindFullTextAction.this.basePanel.markBaseChanged();
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.basePanel.output(Globals.lang("Finished downloading full text document"));
        } else {
            String string = null;
            switch (this.result.status) {
                case 2: {
                    string = Globals.lang("Unable to find full text article. No search algorithm defined for the '%0' web site.", this.result.host);
                    break;
                }
                case 1: {
                    string = Globals.lang("Found pdf link, but received the wrong MIME type. This could indicate that you don't have access to the fulltext article.");
                    break;
                }
                case 3: {
                    string = Globals.lang("Unable to find full text document in the linked web page.");
                    break;
                }
                case 4: {
                    string = Globals.lang("Connection error when trying to find full text document.");
                    break;
                }
                case 5: {
                    string = Globals.lang("This entry provides no URL or DOI links.");
                }
            }
            this.basePanel.output(Globals.lang("Full text article download failed"));
            JOptionPane.showMessageDialog(this.basePanel.frame(), string, Globals.lang("Full text article download failed"), 0);
        }
    }
}

