/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToEmacs
implements PushToApplication {
    private JPanel settings = null;
    private final JTextField citeCommand = new JTextField(30);
    private final JTextField emacsPath = new JTextField(30);
    private final JTextField additionalParams = new JTextField(30);
    private final JCheckBox useEmacs23 = new JCheckBox();
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    @Override
    public String getName() {
        return Globals.menuTitle("Insert selected citations into Emacs");
    }

    @Override
    public String getApplicationName() {
        return "Emacs";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to Emacs");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("emacs");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to Emacs";
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.citeCommand.setText(Globals.prefs.get("citeCommandEmacs"));
        this.emacsPath.setText(Globals.prefs.get("emacsPath"));
        this.additionalParams.setText(Globals.prefs.get("emacsParameters"));
        this.useEmacs23.setSelected(Globals.prefs.getBoolean("emacsUseV23InsertString"));
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("citeCommandEmacs", this.citeCommand.getText());
        Globals.prefs.put("emacsPath", this.emacsPath.getText());
        Globals.prefs.put("emacsParameters", this.additionalParams.getText());
        Globals.prefs.putBoolean("emacsUseV23InsertString", this.useEmacs23.isSelected());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append(new JLabel(Globals.lang("Path to gnuclient or emacsclient").concat(":")));
        defaultFormBuilder.append(this.emacsPath);
        BrowseAction browseAction = BrowseAction.buildForFile(this.emacsPath);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(browseAction);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Additional parameters").concat(":"));
        defaultFormBuilder.append(this.additionalParams);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Use EMACS 23 insertion string").concat(":"));
        defaultFormBuilder.append(this.useEmacs23);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Cite command") + ":");
        defaultFormBuilder.append(this.citeCommand);
        this.settings = defaultFormBuilder.getPanel();
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        String string2 = Globals.prefs.get("emacsPath");
        String[] stringArray = Globals.prefs.get("emacsParameters").split(" ");
        try {
            String string3;
            String string4;
            String[] stringArray2 = new String[stringArray.length + 2];
            stringArray2[0] = string2;
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            if (Globals.prefs.getBoolean("emacsUseV23InsertString")) {
                string4 = "(with-current-buffer (window-buffer) (insert ";
                string3 = "))";
            } else {
                string4 = "(insert ";
                string3 = ")";
            }
            stringArray2[stringArray2.length - 1] = Globals.ON_WIN ? string4.concat("\\\"\\" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + string + "}\\\"").concat(string3) : string4.concat("\"" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + string + "}\"").concat(string3);
            final Process process = Runtime.getRuntime().exec(stringArray2);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = process.getErrorStream();
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        int n;
                        while ((n = inputStream.read()) != -1) {
                            stringBuilder.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (stringBuilder.toString().trim().length() > 0) {
                        System.out.println(stringBuilder.toString());
                        PushToEmacs.this.couldNotConnect = true;
                    }
                }
            };
            JabRefExecutorService.INSTANCE.executeAndWait(runnable);
        }
        catch (IOException iOException) {
            this.couldNotRunClient = true;
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(basePanel.frame(), "<HTML>" + Globals.lang("Could not connect to a running gnuserv process. Make sure that Emacs or XEmacs is running,<BR>and that the server has been started (by running the command 'server-start'/'gnuserv-start').") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(basePanel.frame(), Globals.lang("Could not run the gnuclient/emacsclient program. Make sure you have the emacsclient/gnuclient program installed and available in the PATH."), Globals.lang("Error"), 0);
        } else {
            basePanel.output(Globals.lang("Pushed citations to Emacs"));
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }
}

