/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;

public class TransferableFileLinkSelection
implements Transferable {
    private final List<File> fileList = new ArrayList<File>();

    public TransferableFileLinkSelection(BasePanel basePanel, BibtexEntry[] bibtexEntryArray) {
        String string = bibtexEntryArray[0].getField("file");
        FileListTableModel fileListTableModel = new FileListTableModel();
        if (string != null) {
            fileListTableModel.setContent(string);
        }
        if (fileListTableModel.getRowCount() > 0) {
            String[] stringArray = basePanel.metaData().getFileDirectory("file");
            File file = FileUtil.expandFilename(fileListTableModel.getEntry(0).getLink(), stringArray);
            this.fileList.add(file);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        System.out.println("Query: " + dataFlavor.getHumanPresentableName() + " , " + dataFlavor.getDefaultRepresentationClass() + " , " + dataFlavor.getMimeType());
        return dataFlavor.equals(DataFlavor.javaFileListFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.fileList;
    }
}

