/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.groups.structure.SearchGroup;
import net.sf.jabref.util.StringUtil;

public class GroupTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final int MAX_DISPLAYED_LETTERS = 35;
    private Object highlight1Cell = null;
    private Object[] highlight2Cells = null;
    private Object[] highlight3Cells = null;
    private Object highlightBorderCell = null;
    private static final ImageIcon groupRefiningIcon = GUIGlobals.getImage("groupRefining");
    private static final ImageIcon groupIncludingIcon = GUIGlobals.getImage("groupIncluding");
    private static final ImageIcon groupRegularIcon = null;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component;
        block30: {
            JLabel jLabel;
            block29: {
                String string;
                Object object222;
                if (object == this.highlight1Cell) {
                    bl = true;
                }
                component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (!(object instanceof GroupTreeNode)) {
                    return component;
                }
                AbstractGroup abstractGroup = ((GroupTreeNode)object).getGroup();
                if (abstractGroup == null || !(component instanceof JLabel)) {
                    return component;
                }
                jLabel = (JLabel)component;
                if (this.highlightBorderCell != null && this.highlightBorderCell == object) {
                    jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                } else {
                    jLabel.setBorder(BorderFactory.createEmptyBorder());
                }
                boolean bl5 = Globals.prefs.getBoolean("groupShowDynamic") && abstractGroup.isDynamic();
                boolean bl6 = false;
                if (this.highlight2Cells != null) {
                    for (Object object222 : this.highlight2Cells) {
                        if (object222 != object) continue;
                        bl6 = true;
                        break;
                    }
                }
                boolean bl7 = false;
                if (this.highlight3Cells != null) {
                    for (Object iterator : this.highlight3Cells) {
                        if (iterator != object) continue;
                        bl7 = true;
                        break;
                    }
                }
                if ((string = abstractGroup.getName()).length() > 35) {
                    string = string.substring(0, 33) + "...";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                if (bl6) {
                    stringBuilder.append("<font color=\"#FF0000\">");
                }
                if (bl7) {
                    stringBuilder.append("<u>");
                }
                if (bl5) {
                    stringBuilder.append("<i>");
                }
                stringBuilder.append(StringUtil.quoteForHTML(string));
                if (Globals.prefs.getBoolean("groupShowNumberOfElements")) {
                    if (abstractGroup instanceof ExplicitGroup) {
                        stringBuilder.append(" [").append(((ExplicitGroup)abstractGroup).getNumEntries()).append("]");
                    } else if (abstractGroup instanceof KeywordGroup || abstractGroup instanceof SearchGroup) {
                        int n2 = 0;
                        for (BibtexEntry bibtexEntry : JabRef.jrf.basePanel().getDatabase().getEntries()) {
                            if (!abstractGroup.contains(bibtexEntry)) continue;
                            ++n2;
                        }
                        stringBuilder.append(" [").append(n2).append("]");
                    }
                }
                if (bl5) {
                    stringBuilder.append("</i>");
                }
                if (bl7) {
                    stringBuilder.append("</u>");
                }
                if (bl6) {
                    stringBuilder.append("</font>");
                }
                stringBuilder.append("</html>");
                object222 = stringBuilder.toString();
                if (!jLabel.getText().equals(object222)) {
                    jLabel.setText((String)object222);
                }
                jLabel.setToolTipText("<html>" + abstractGroup.getShortDescription() + "</html>");
                if (!Globals.prefs.getBoolean("groupShowIcons")) break block29;
                switch (abstractGroup.getHierarchicalContext()) {
                    case REFINING: {
                        if (jLabel.getIcon() != groupRefiningIcon) {
                            jLabel.setIcon(groupRefiningIcon);
                            break;
                        }
                        break block30;
                    }
                    case INCLUDING: {
                        if (jLabel.getIcon() != groupIncludingIcon) {
                            jLabel.setIcon(groupIncludingIcon);
                            break;
                        }
                        break block30;
                    }
                    default: {
                        if (jLabel.getIcon() != groupRegularIcon) {
                            jLabel.setIcon(groupRegularIcon);
                            break;
                        }
                        break block30;
                    }
                }
                break block30;
            }
            jLabel.setIcon(null);
        }
        return component;
    }

    void setHighlight1Cell(Object object) {
        this.highlight1Cell = object;
    }

    void setHighlight2Cells(Object[] objectArray) {
        this.highlight2Cells = objectArray;
    }

    void setHighlight3Cells(Object[] objectArray) {
        this.highlight3Cells = objectArray;
    }

    void setHighlightBorderCell(Object object) {
        this.highlightBorderCell = object;
    }
}

