/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.util.Util;

public class RemoveFromGroupAction
extends AbstractAction {
    private GroupTreeNode m_node;
    private BasePanel m_panel;

    public RemoveFromGroupAction(GroupTreeNode groupTreeNode, BasePanel basePanel) {
        super(groupTreeNode.getGroup().getName());
        this.m_node = groupTreeNode;
        this.m_panel = basePanel;
    }

    public RemoveFromGroupAction() {
        super(Globals.lang("Remove entry selection from this group"));
    }

    public void setNode(GroupTreeNode groupTreeNode) {
        this.m_node = groupTreeNode;
    }

    public void setBasePanel(BasePanel basePanel) {
        this.m_panel = basePanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_node.getGroup()}, this.m_panel.getSelectedEntries(), this.m_panel.getDatabase(), this.m_panel.frame())) {
            return;
        }
        AbstractUndoableEdit abstractUndoableEdit = this.m_node.removeFromGroup(this.m_panel.getSelectedEntries());
        if (abstractUndoableEdit == null) {
            return;
        }
        this.m_panel.undoManager.addEdit(abstractUndoableEdit);
        this.m_panel.markBaseChanged();
        this.m_panel.updateEntryEditorIfShowing();
        this.m_panel.getGroupSelector().valueChanged(null);
    }
}

