/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

class UndoableMoveGroup
extends AbstractUndoableEdit {
    private final GroupSelector m_groupSelector;
    private final GroupTreeNode m_groupsRootHandle;
    private final int[] m_pathToNewParent;
    private final int m_newChildIndex;
    private final int[] m_pathToOldParent;
    private final int m_oldChildIndex;

    public UndoableMoveGroup(GroupSelector groupSelector, GroupTreeNode groupTreeNode, GroupTreeNode groupTreeNode2, GroupTreeNode groupTreeNode3, int n) {
        this.m_groupSelector = groupSelector;
        this.m_groupsRootHandle = groupTreeNode;
        this.m_pathToNewParent = groupTreeNode3.getIndexedPath();
        this.m_newChildIndex = n;
        this.m_pathToOldParent = ((GroupTreeNode)groupTreeNode2.getParent()).getIndexedPath();
        this.m_oldChildIndex = groupTreeNode2.getParent().getIndex(groupTreeNode2);
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("move group");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("move group");
    }

    @Override
    public void undo() {
        super.undo();
        GroupTreeNode groupTreeNode = this.m_groupsRootHandle.getDescendant(this.m_pathToNewParent);
        groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(this.m_newChildIndex);
        this.m_groupsRootHandle.getDescendant(this.m_pathToOldParent).insert(groupTreeNode, this.m_oldChildIndex);
        this.m_groupSelector.revalidateGroups();
    }

    @Override
    public void redo() {
        super.redo();
        GroupTreeNode groupTreeNode = this.m_groupsRootHandle.getDescendant(this.m_pathToOldParent);
        groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(this.m_oldChildIndex);
        this.m_groupsRootHandle.getDescendant(this.m_pathToNewParent).insert(groupTreeNode, this.m_newChildIndex);
        this.m_groupSelector.revalidateGroups();
    }
}

