/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.structure;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.UnsupportedVersionException;
import net.sf.jabref.search.SearchRule;

public class AllEntriesGroup
extends AbstractGroup {
    public static final String ID = "AllEntriesGroup:";

    public AllEntriesGroup() {
        super(Globals.lang("All Entries"), GroupHierarchyType.INDEPENDENT);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: AllEntriesGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new AllEntriesGroup();
            }
        }
        throw new UnsupportedVersionException("AllEntriesGroup", n);
    }

    @Override
    public SearchRule getSearchRule() {
        return new SearchRule(){

            @Override
            public boolean applyRule(String string, BibtexEntry bibtexEntry) {
                return true;
            }

            @Override
            public boolean validateSearchStrings(String string) {
                return true;
            }
        };
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    @Override
    public boolean contains(String string, BibtexEntry bibtexEntry) {
        return true;
    }

    @Override
    public AbstractGroup deepCopy() {
        return new AllEntriesGroup();
    }

    public boolean equals(Object object) {
        return object instanceof AllEntriesGroup;
    }

    public String toString() {
        return ID;
    }

    @Override
    public boolean contains(BibtexEntry bibtexEntry) {
        return true;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String getDescription() {
        return Globals.lang("This group contains all entries. It cannot be edited or removed.");
    }

    @Override
    public String getShortDescription() {
        return Globals.lang("<b>All Entries</b> (this group cannot be edited or removed)");
    }

    @Override
    public String getTypeId() {
        return ID;
    }
}

