/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.UnsupportedVersionException;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.util.QuotedStringTokenizer;
import net.sf.jabref.util.StringUtil;

public class ExplicitGroup
extends AbstractGroup {
    public static final String ID = "ExplicitGroup:";
    private final Set<BibtexEntry> entries = new HashSet<BibtexEntry>();

    public ExplicitGroup(String string, GroupHierarchyType groupHierarchyType) {
        super(string, groupHierarchyType);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: ExplicitGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                ExplicitGroup explicitGroup = new ExplicitGroup(quotedStringTokenizer.nextToken(), GroupHierarchyType.INDEPENDENT);
                explicitGroup.addEntries(quotedStringTokenizer, bibtexDatabase);
                return explicitGroup;
            }
            case 3: {
                String string2 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                ExplicitGroup explicitGroup = new ExplicitGroup(string2, GroupHierarchyType.getByNumber(n2));
                explicitGroup.addEntries(quotedStringTokenizer, bibtexDatabase);
                return explicitGroup;
            }
        }
        throw new UnsupportedVersionException("ExplicitGroup", n);
    }

    private void addEntries(QuotedStringTokenizer quotedStringTokenizer, BibtexDatabase bibtexDatabase) {
        while (quotedStringTokenizer.hasMoreTokens()) {
            BibtexEntry[] bibtexEntryArray = bibtexDatabase.getEntriesByKey(StringUtil.unquote(quotedStringTokenizer.nextToken(), '\\'));
            Collections.addAll(this.entries, bibtexEntryArray);
        }
    }

    @Override
    public SearchRule getSearchRule() {
        return new SearchRule(){

            @Override
            public boolean applyRule(String string, BibtexEntry bibtexEntry) {
                return ExplicitGroup.this.contains(string, bibtexEntry);
            }

            @Override
            public boolean validateSearchStrings(String string) {
                return true;
            }
        };
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        if (bibtexEntryArray.length == 0) {
            return null;
        }
        HashSet<BibtexEntry> hashSet = new HashSet<BibtexEntry>(this.entries);
        Collections.addAll(this.entries, bibtexEntryArray);
        return new UndoableChangeAssignment(hashSet, this.entries);
    }

    public boolean addEntry(BibtexEntry bibtexEntry) {
        return this.entries.add(bibtexEntry);
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        if (bibtexEntryArray.length == 0) {
            return null;
        }
        HashSet<BibtexEntry> hashSet = new HashSet<BibtexEntry>(this.entries);
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            this.entries.remove(bibtexEntry);
        }
        return new UndoableChangeAssignment(hashSet, this.entries);
    }

    public boolean removeEntry(BibtexEntry bibtexEntry) {
        return this.entries.remove(bibtexEntry);
    }

    @Override
    public boolean contains(BibtexEntry bibtexEntry) {
        return this.entries.contains(bibtexEntry);
    }

    @Override
    public boolean contains(String string, BibtexEntry bibtexEntry) {
        return this.contains(bibtexEntry);
    }

    @Override
    public AbstractGroup deepCopy() {
        ExplicitGroup explicitGroup = new ExplicitGroup(this.name, this.context);
        explicitGroup.entries.addAll(this.entries);
        return explicitGroup;
    }

    public boolean equals(Object object) {
        String string;
        BibtexEntry bibtexEntry;
        if (!(object instanceof ExplicitGroup)) {
            return false;
        }
        ExplicitGroup explicitGroup = (ExplicitGroup)object;
        if (this.entries.size() != explicitGroup.entries.size()) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (BibtexEntry bibtexEntry2 : this.entries) {
            bibtexEntry = bibtexEntry2;
            string = bibtexEntry.getCiteKey();
            if (string == null) continue;
            hashSet.add(string);
        }
        for (BibtexEntry bibtexEntry2 : explicitGroup.entries) {
            bibtexEntry = bibtexEntry2;
            string = bibtexEntry.getCiteKey();
            if (string == null || hashSet.remove(string)) continue;
            return false;
        }
        if (!hashSet.isEmpty()) {
            return false;
        }
        return explicitGroup.name.equals(this.name) && explicitGroup.getHierarchicalContext() == this.getHierarchicalContext();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ID).append(StringUtil.quote(this.name, ";", '\\')).append(";").append(this.context.ordinal()).append(";");
        TreeSet<String> treeSet = new TreeSet<String>();
        for (BibtexEntry object : this.entries) {
            String string = object.getCiteKey();
            if (string == null || string.isEmpty()) continue;
            treeSet.add(string);
        }
        for (String string : treeSet) {
            stringBuilder.append(StringUtil.quote(string, ";", '\\')).append(";");
        }
        return stringBuilder.toString();
    }

    public void clearAssignments() {
        this.entries.clear();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String getDescription() {
        return ExplicitGroup.getDescriptionForPreview();
    }

    public static String getDescriptionForPreview() {
        return Globals.lang("This group contains entries based on manual assignment. Entries can be assigned to this group by selecting them then using either drag and drop or the context menu. Entries can be removed from this group by selecting them then using the context menu. Every entry assigned to this group must have a unique key. The key may be changed at any time as long as it remains unique.");
    }

    @Override
    public String getShortDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>").append(this.getName()).append("</b> -").append(Globals.lang("static group"));
        switch (this.getHierarchicalContext()) {
            case INCLUDING: {
                stringBuilder.append(", ").append(Globals.lang("includes subgroups"));
                break;
            }
            case REFINING: {
                stringBuilder.append(", ").append(Globals.lang("refines supergroup"));
                break;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void refreshForNewDatabase(BibtexDatabase bibtexDatabase) {
        HashSet<BibtexEntry> hashSet = new HashSet<BibtexEntry>();
        for (BibtexEntry bibtexEntry : this.entries) {
            BibtexEntry bibtexEntry2 = bibtexDatabase.getEntryByKey(bibtexEntry.getCiteKey());
            hashSet.add(bibtexEntry2);
        }
        this.entries.clear();
        this.entries.addAll(hashSet);
    }

    public Set<BibtexEntry> getEntries() {
        return this.entries;
    }

    @Override
    public String getTypeId() {
        return ID;
    }

    public int getNumEntries() {
        return this.entries.size();
    }
}

