/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.GUIGlobals;

class DragDropPane
extends JTabbedPane {
    private boolean draggingState = false;
    private int indexDraggedTab = -1;
    private final MarkerPane markerPane = new MarkerPane();

    DragDropPane() {
        this.markerPane.setVisible(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = DragDropPane.this.getUI().tabForCoordinate(DragDropPane.this, mouseEvent.getX(), mouseEvent.getY());
                if (!DragDropPane.this.draggingState) {
                    if (n >= 0) {
                        DragDropPane.this.draggingState = true;
                        DragDropPane.this.indexDraggedTab = n;
                        DragDropPane.this.repaint();
                    }
                } else if (DragDropPane.this.indexDraggedTab >= 0 && n >= 0) {
                    boolean bl = (double)mouseEvent.getX() <= DragDropPane.this.getUI().getTabBounds(DragDropPane.this, n).getCenterX();
                    DragDropPane.this.getRootPane().setGlassPane(DragDropPane.this.markerPane);
                    Rectangle rectangle = SwingUtilities.convertRectangle(DragDropPane.this, DragDropPane.this.getBoundsAt(n), DragDropPane.this.markerPane);
                    if (bl) {
                        DragDropPane.this.markerPane.setPicLocation(new Point(rectangle.x, rectangle.y + rectangle.height));
                    } else {
                        DragDropPane.this.markerPane.setPicLocation(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
                    }
                    DragDropPane.this.markerPane.setVisible(true);
                    DragDropPane.this.markerPane.repaint();
                    DragDropPane.this.repaint();
                } else {
                    DragDropPane.this.markerPane.setVisible(false);
                    DragDropPane.this.markerPane.repaint();
                }
                super.mouseDragged(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DragDropPane.this.markerPane.setVisible(false);
                int n = DragDropPane.this.getUI().tabForCoordinate(DragDropPane.this, mouseEvent.getX(), mouseEvent.getY());
                if (DragDropPane.this.indexDraggedTab >= 0 && n >= 0 && DragDropPane.this.indexDraggedTab != n && DragDropPane.this.draggingState) {
                    boolean bl = (double)mouseEvent.getX() <= DragDropPane.this.getUI().getTabBounds(DragDropPane.this, n).getCenterX();
                    DragDropPane.this.markerPane.setVisible(false);
                    Component component = DragDropPane.this.getComponentAt(DragDropPane.this.indexDraggedTab);
                    String string = DragDropPane.this.getTitleAt(DragDropPane.this.indexDraggedTab);
                    DragDropPane.this.removeTabAt(DragDropPane.this.indexDraggedTab);
                    int n2 = n < DragDropPane.this.indexDraggedTab ? (bl && n < DragDropPane.this.getTabCount() ? n : n + 1) : (bl && n > 0 ? n - 1 : n);
                    DragDropPane.this.insertTab(string, null, component, null, n2);
                    DragDropPane.this.setSelectedIndex(n2);
                }
                DragDropPane.this.draggingState = false;
            }
        });
    }

    class MarkerPane
    extends JPanel {
        private Point locationP;
        private final Image markerImg;

        public MarkerPane() {
            this.setOpaque(false);
            this.markerImg = Toolkit.getDefaultToolkit().getImage(GUIGlobals.getIconUrl("dragNdropArrow"));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics.drawImage(this.markerImg, this.locationP.x - this.markerImg.getWidth(null) / 2, this.locationP.y, null);
        }

        public void setPicLocation(Point point) {
            this.locationP = point;
        }
    }
}

