/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.gui.TableFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.SpecialFieldValue;
import net.sf.jabref.util.StringUtil;

public class MainTableFormat
implements TableFormat<BibtexEntry> {
    public static final String COL_DEFINITION_FIELD_SEPARATOR = "/";
    public static final String ICON_COLUMN_PREFIX = "iconcol:";
    private static final String[] PDF = new String[]{"pdf", "ps"};
    private static final String[] URL_FIRST = new String[]{"url", "doi"};
    private static final String[] DOI_FIRST = new String[]{"doi", "url"};
    public static final String[] CITESEER = new String[]{"citeseerurl"};
    private static final String[] ARXIV = new String[]{"eprint"};
    private static final String[] RANKING = new String[]{"ranking"};
    private static final String[] PRIORITY = new String[]{"priority"};
    private static final String[] RELEVANCE = new String[]{"relevance"};
    private static final String[] QUALITY = new String[]{"qualityassured"};
    private static final String[] PRINTED = new String[]{"printed"};
    private static final String[] READ = new String[]{"readstatus"};
    public static final String[] FILE = new String[]{"file"};
    private final BasePanel panel;
    private String[][] columns;
    public int padleft = -1;
    private final HashMap<Integer, String[]> iconCols = new HashMap();
    private int[][] nameCols = null;
    private boolean namesAsIs;
    private boolean abbr_names;
    private boolean namesNatbib;
    private boolean namesFf;
    private boolean namesLf;
    private boolean namesLastOnly;

    public MainTableFormat(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public int getColumnCount() {
        return this.padleft + this.columns.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "#";
        }
        if (this.getIconTypeForColumn(n) != null) {
            if (Globals.prefs.getBoolean("showOneLetterHeadingForIconColumns")) {
                return this.getIconTypeForColumn(n)[0].substring(0, 1).toUpperCase();
            }
            return null;
        }
        String[] stringArray = this.columns[n - this.padleft];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i > 0) {
                stringBuilder.append('/');
            }
            if ((string = BibtexFields.getFieldDisplayName(stringArray[i])) != null) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(StringUtil.nCase(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public String getColumnType(int n) {
        String string = this.getColumnName(n);
        if (string != null) {
            return string;
        }
        String[] stringArray = this.getIconTypeForColumn(n);
        if (stringArray != null && stringArray.length > 0) {
            return ICON_COLUMN_PREFIX + stringArray[0];
        }
        return null;
    }

    public String[] getIconTypeForColumn(int n) {
        String[] stringArray = this.iconCols.get(new Integer(n));
        if (stringArray != null) {
            return stringArray;
        }
        return null;
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i][0].equalsIgnoreCase(string)) continue;
            return i + this.padleft;
        }
        return -1;
    }

    public boolean isRankingColumn(int n) {
        return this.iconCols.get(n) != null && this.iconCols.get(n)[0].equals(RANKING[0]);
    }

    private Object modifyIconForMultipleLinks(JLabel jLabel) {
        Icon icon = jLabel.getIcon();
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(new Font("Serif", 0, 12));
        ((Graphics)graphics2D).drawString("m", bufferedImage.getWidth() - graphics2D.getFontMetrics().stringWidth("m"), bufferedImage.getHeight());
        graphics2D.dispose();
        return new JLabel(new ImageIcon(bufferedImage));
    }

    @Override
    public Object getColumnValue(BibtexEntry bibtexEntry, int n) {
        Object object = null;
        String[] stringArray = this.getIconTypeForColumn(n);
        if (n == 0) {
            object = "#";
        } else if (stringArray != null) {
            int[] nArray = this.hasField(bibtexEntry, stringArray);
            int n2 = nArray[0];
            if (n2 < 0) {
                return null;
            }
            if (stringArray[n2].equals("file")) {
                object = FileListTableModel.getFirstLabel(bibtexEntry.getField("file"));
                if (nArray[1] > 1) {
                    object = this.modifyIconForMultipleLinks((JLabel)object);
                }
            } else if (stringArray[n2].equals(PRIORITY[0])) {
                SpecialFieldValue specialFieldValue = Priority.getInstance().parse(bibtexEntry.getField("priority"));
                if (specialFieldValue != null) {
                    object = specialFieldValue.createLabel();
                }
            } else if (stringArray[n2].equals(RANKING[0])) {
                SpecialFieldValue specialFieldValue = Rank.getInstance().parse(bibtexEntry.getField("ranking"));
                if (specialFieldValue != null) {
                    object = specialFieldValue.createLabel();
                }
            } else if (stringArray[n2].equals(READ[0])) {
                SpecialFieldValue specialFieldValue = ReadStatus.getInstance().parse(bibtexEntry.getField("readstatus"));
                if (specialFieldValue != null) {
                    object = specialFieldValue.createLabel();
                }
            } else {
                object = GUIGlobals.getTableIcon(stringArray[n2]);
                if (nArray[1] > 1) {
                    object = this.modifyIconForMultipleLinks((JLabel)object);
                }
            }
        } else {
            String[] stringArray2 = this.columns[n - this.padleft];
            int n3 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equals("entrytype")) {
                    object = bibtexEntry.getType().getName();
                } else {
                    object = bibtexEntry.getFieldOrAlias(stringArray2[i]);
                    if (this.getColumnName(n).equals("Author") && object != null) {
                        object = this.panel.database().resolveForStrings((String)object);
                    }
                }
                if (object == null) continue;
                n3 = i;
                break;
            }
            for (int[] nArray : this.nameCols) {
                if (n - this.padleft != nArray[0] || nArray[1] != n3) continue;
                return this.formatName(object);
            }
        }
        return object;
    }

    public Object formatName(Object object) {
        if (object == null) {
            return null;
        }
        if (this.namesAsIs) {
            return object;
        }
        if (this.namesNatbib) {
            object = AuthorList.fixAuthor_Natbib((String)object);
        } else if (this.namesLastOnly) {
            object = AuthorList.fixAuthor_lastNameOnlyCommas((String)object, false);
        } else if (this.namesFf) {
            object = AuthorList.fixAuthor_firstNameFirstCommas((String)object, this.abbr_names, false);
        } else if (this.namesLf) {
            object = AuthorList.fixAuthor_lastNameFirstCommas((String)object, this.abbr_names, false);
        }
        return object;
    }

    private boolean hasField(BibtexEntry bibtexEntry, String string) {
        return bibtexEntry != null && bibtexEntry.getFieldOrAlias(string) != null;
    }

    private int[] hasField(BibtexEntry bibtexEntry, String[] stringArray) {
        if (bibtexEntry == null || stringArray == null || stringArray.length < 1) {
            return new int[]{-1, -1};
        }
        int n = -1;
        if (!stringArray[0].equals("file")) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!this.hasField(bibtexEntry, stringArray[i])) continue;
                n = i;
            }
            return new int[]{n, -1};
        }
        String string = bibtexEntry.getField("file");
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.setContent(string);
        if (stringArray.length == 1) {
            if (fileListTableModel.getRowCount() == 0) {
                return new int[]{-1, -1};
            }
            return new int[]{0, fileListTableModel.getRowCount()};
        }
        int n2 = -1;
        int n3 = 0;
        for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 0; j < fileListTableModel.getRowCount(); ++j) {
                FileListEntry fileListEntry = fileListTableModel.getEntry(j);
                if (!fileListEntry.getType().toString().equals(stringArray[i])) continue;
                n2 = i;
                ++n3;
            }
        }
        return new int[]{n2, n3};
    }

    public void updateTableFormat() {
        int n;
        int n2;
        Object object;
        int n3;
        String[] stringArray = Globals.prefs.getStringArray("columnNames");
        this.columns = new String[stringArray.length][];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            String[] stringArray2 = stringArray[n3].split(COL_DEFINITION_FIELD_SEPARATOR);
            this.columns[n3] = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, this.columns[n3], 0, stringArray2.length);
        }
        n3 = Globals.prefs.getBoolean("showShort") ? 1 : 0;
        this.namesNatbib = Globals.prefs.getBoolean("namesNatbib");
        this.namesLastOnly = Globals.prefs.getBoolean("namesLastOnly");
        this.namesAsIs = Globals.prefs.getBoolean("namesAsIs");
        this.abbr_names = Globals.prefs.getBoolean("abbrAuthorNames");
        this.namesFf = Globals.prefs.getBoolean("namesFf");
        this.namesLf = !this.namesAsIs && !this.namesFf && !this.namesNatbib && !this.namesLastOnly;
        this.iconCols.clear();
        int n4 = 1;
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                this.iconCols.put(n4, RANKING);
                ++n4;
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.iconCols.put(n4, RELEVANCE);
                ++n4;
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.iconCols.put(n4, QUALITY);
                ++n4;
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                this.iconCols.put(n4, PRIORITY);
                ++n4;
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.iconCols.put(n4, PRINTED);
                ++n4;
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                this.iconCols.put(n4, READ);
                ++n4;
            }
        }
        if (Globals.prefs.getBoolean("fileColumn")) {
            this.iconCols.put(n4, FILE);
            ++n4;
        }
        if (Globals.prefs.getBoolean("pdfColumn")) {
            this.iconCols.put(n4, PDF);
            ++n4;
        }
        if (Globals.prefs.getBoolean("urlColumn")) {
            if (Globals.prefs.getBoolean("preferUrlDoi")) {
                this.iconCols.put(n4, DOI_FIRST);
                ++n4;
            } else {
                this.iconCols.put(n4, URL_FIRST);
                ++n4;
            }
        }
        if (Globals.prefs.getBoolean("arxivColumn")) {
            this.iconCols.put(n4, ARXIV);
            ++n4;
        }
        if (Globals.prefs.getBoolean("extraFileColumns")) {
            object = Globals.prefs.getStringArray("listOfFileColumns");
            String[] stringArray3 = object;
            n2 = stringArray3.length;
            for (int i = 0; i < n2; ++i) {
                String string = stringArray3[i];
                this.iconCols.put(n4, new String[]{"file", string});
                ++n4;
            }
        }
        this.padleft = 1 + this.iconCols.size();
        object = new Vector(2, 1);
        for (n = 0; n < this.columns.length; ++n) {
            for (n2 = 0; n2 < this.columns[n].length; ++n2) {
                if (!this.columns[n][n2].equals("author") && !this.columns[n][n2].equals("editor")) continue;
                ((Vector)object).add(new int[]{n, n2});
            }
        }
        this.nameCols = new int[((Vector)object).size()][];
        for (n = 0; n < this.nameCols.length; ++n) {
            this.nameCols[n] = (int[])((Vector)object).elementAt(n);
        }
    }
}

