/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;

class PreventDraggingJTableHeader
extends JTableHeader {
    public PreventDraggingJTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    @Override
    public void setDraggedColumn(TableColumn tableColumn) {
        if (tableColumn != null) {
            if (tableColumn.getModelIndex() == 0) {
                return;
            }
            if (PreventDraggingJTableHeader.isUnnamed(tableColumn)) {
                return;
            }
            String string = tableColumn.getHeaderValue().toString();
            if (string.equals("P") || string.equals("Q") || string.equals("R")) {
                return;
            }
            if (string.equals("F") || string.equals("U")) {
                return;
            }
        }
        super.setDraggedColumn(tableColumn);
    }

    @Override
    public TableColumn getDraggedColumn() {
        TableColumn tableColumn = super.getDraggedColumn();
        if (tableColumn != null) {
            PreventDraggingJTableHeader.preventDragBeforeIndex(this.getTable(), tableColumn.getModelIndex(), this.getSpecialColumnsCount());
        }
        return tableColumn;
    }

    private int getSpecialColumnsCount() {
        int n = 0;
        if (Globals.prefs.getBoolean("fileColumn")) {
            ++n;
        }
        if (Globals.prefs.getBoolean("pdfColumn")) {
            ++n;
        }
        if (Globals.prefs.getBoolean("urlColumn")) {
            ++n;
        }
        if (Globals.prefs.getBoolean("arxivColumn")) {
            ++n;
        }
        if (Globals.prefs.getBoolean("extraFileColumns")) {
            n += Globals.prefs.getStringArray("listOfFileColumns").length;
        }
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                ++n;
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                ++n;
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                ++n;
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                ++n;
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                ++n;
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                ++n;
            }
        }
        return n;
    }

    private static boolean isUnnamed(TableColumn tableColumn) {
        return tableColumn.getHeaderValue() == null || tableColumn.getHeaderValue().toString() != null && tableColumn.getHeaderValue().toString().isEmpty();
    }

    private static void preventDragBeforeIndex(JTable jTable, int n, int n2) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            if (tableColumn.getModelIndex() != n || i > n2) continue;
            jTable.getColumnModel().moveColumn(n2, n2 + 1);
            return;
        }
    }
}

