/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class SysTray {
    private final JabRefFrame frame;
    private final TrayIcon icon;
    private SystemTray tray = null;

    public SysTray(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SysTray.this.frame.showIfMinimizedToSysTray();
                    }
                });
            }
        };
        MenuItem menuItem = new MenuItem(Globals.lang("Show"));
        menuItem.addActionListener(actionListener);
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.add(menuItem);
        ImageIcon imageIcon = new ImageIcon(GUIGlobals.class.getResource("/images/JabRef-icon-48.png"));
        this.icon = new TrayIcon(imageIcon.getImage(), "JabRef", popupMenu);
        this.icon.setImageAutoSize(true);
        this.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                actionListener.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, ""));
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
            }
        });
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
        }
    }

    public void show() {
        if (this.tray == null) {
            return;
        }
        try {
            this.tray.add(this.icon);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    public void hide() {
        if (this.tray == null) {
            return;
        }
        this.tray.remove(this.icon);
    }
}

