/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.help.HelpContent;
import net.sf.jabref.util.Util;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private final JabRefFrame frame;
    private final HelpContent content;
    private final BackAction back = new BackAction();
    private final ForwardAction forward = new ForwardAction();

    public HelpDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("JabRef help"), false);
        this.frame = jabRefFrame;
        this.content = new HelpContent(jabRefFrame.prefs());
        this.content.addHyperlinkListener(this);
        this.setSize(GUIGlobals.helpSize);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.back);
        jToolBar.add(this.forward);
        jToolBar.addSeparator();
        ContentsAction contentsAction = new ContentsAction();
        jToolBar.add(contentsAction);
        jToolBar.setFloatable(false);
        InputMap inputMap = jToolBar.getInputMap(2);
        ActionMap actionMap = jToolBar.getActionMap();
        inputMap.put(jabRefFrame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", new CloseAction());
        inputMap.put(jabRefFrame.prefs().getKey("Back, help dialog"), "left");
        actionMap.put("left", this.back);
        inputMap.put(jabRefFrame.prefs().getKey("Forward, help dialog"), "right");
        actionMap.put("right", this.forward);
        inputMap = this.content.getInputMap(0);
        actionMap = this.content.getActionMap();
        inputMap.put(jabRefFrame.prefs().getKey("Back, help dialog"), "left");
        actionMap.put("left", this.back);
        inputMap.put(jabRefFrame.prefs().getKey("Forward, help dialog"), "right");
        actionMap.put("right", this.forward);
        this.getContentPane().add((Component)jToolBar, "North");
        this.getContentPane().add(this.content.getPane());
        this.forward.setEnabled(false);
        this.back.setEnabled(false);
    }

    public void showPage(String string) {
        this.showPage(string, JabRef.class);
    }

    public void showPage(String string, Class clazz) {
        if (!this.isVisible()) {
            Util.placeDialog(this, this.frame);
            this.content.reset();
            this.back.setEnabled(false);
            this.setVisible(true);
        } else {
            this.back.setEnabled(true);
        }
        this.forward.setEnabled(false);
        this.content.setPage(string, clazz);
        this.content.requestFocus();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.content.setPage(hyperlinkEvent.getURL());
            this.back.setEnabled(true);
            this.forward.setEnabled(false);
        }
    }

    class ContentsAction
    extends AbstractAction {
        public ContentsAction() {
            super("Contents", GUIGlobals.getImage("helpContents"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog.this.content.setPage("Contents.html", JabRef.class);
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward", GUIGlobals.getImage("right"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(HelpDialog.this.content.forward());
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back", GUIGlobals.getImage("left"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(HelpDialog.this.content.back());
            HelpDialog.this.forward.setEnabled(true);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close"));
            this.putValue("ShortDescription", Globals.lang("Close the help window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog.this.dispose();
        }
    }
}

