/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.help.HTMLParagraphView;

class LargeHTMLEditorKit
extends HTMLEditorKit {
    private final ViewFactory factory = new MyViewFactory();

    LargeHTMLEditorKit() {
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    private static class HTMLBlockView
    extends BlockView {
        public HTMLBlockView(Element element) {
            super(element, 1);
        }

        @Override
        protected void layout(int n, int n2) {
            if (n < Integer.MAX_VALUE) {
                super.layout(new Double((double)n / this.getZoomFactor()).intValue(), new Double((double)n2 * this.getZoomFactor()).intValue());
            }
        }

        public double getZoomFactor() {
            Double d = (Double)this.getDocument().getProperty("ZOOM_FACTOR");
            if (d == null) {
                return GUIGlobals.zoomLevel;
            }
            return d;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = this.getZoomFactor();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(d, d);
            super.paint(graphics2D, shape);
            graphics2D.setTransform(affineTransform);
        }

        @Override
        public float getMinimumSpan(int n) {
            float f = super.getMinimumSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public float getMaximumSpan(int n) {
            float f = super.getMaximumSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public float getPreferredSpan(int n) {
            float f = super.getPreferredSpan(n);
            f = (float)((double)f * this.getZoomFactor());
            return f;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            double d = this.getZoomFactor();
            Rectangle rectangle = shape.getBounds();
            Shape shape2 = super.modelToView(n, rectangle, bias);
            rectangle = shape2.getBounds();
            rectangle.x = (int)((double)rectangle.x * d);
            rectangle.y = (int)((double)rectangle.y * d);
            rectangle.width = (int)((double)rectangle.width * d);
            rectangle.height = (int)((double)rectangle.height * d);
            return rectangle;
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            double d = this.getZoomFactor();
            Rectangle rectangle = shape.getBounds();
            f = (float)((double)f / d);
            f2 = (float)((double)f2 / d);
            rectangle.x = (int)((double)rectangle.x / d);
            rectangle.y = (int)((double)rectangle.y / d);
            rectangle.width = (int)((double)rectangle.width / d);
            rectangle.height = (int)((double)rectangle.height / d);
            return super.viewToModel(f, f2, rectangle, biasArray);
        }
    }

    private class MyViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyViewFactory() {
        }

        @Override
        public View create(Element element) {
            Object object;
            AttributeSet attributeSet = element.getAttributes();
            Object object2 = attributeSet.getAttribute("$ename");
            Object object3 = object = object2 != null ? null : attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.HTML) {
                    return new HTMLBlockView(element);
                }
                if (tag == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string != null && string.equals("pre")) {
                        return super.create(element);
                    }
                    return new HTMLParagraphView(element);
                }
                if (tag == HTML.Tag.P || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6 || tag == HTML.Tag.DT) {
                    return new HTMLParagraphView(element);
                }
            }
            return super.create(element);
        }
    }
}

