/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.sf.jabref.help.LargeHTMLEditorKit;

class MyEditorKit
extends LargeHTMLEditorKit {
    private Action[] myActions;

    MyEditorKit() {
    }

    @Override
    public Action[] getActions() {
        if (this.myActions == null) {
            Action[] actionArray = super.getActions();
            Action[] actionArray2 = new Action[2];
            for (Action action : actionArray) {
                String string = (String)action.getValue("Name");
                if (string.equals("caret-up")) {
                    actionArray2[0] = new MyNextVisualPositionAction(action, 1);
                    continue;
                }
                if (!string.equals("caret-down")) continue;
                actionArray2[1] = new MyNextVisualPositionAction(action, 5);
            }
            this.myActions = TextAction.augmentList(actionArray, actionArray2);
        }
        return this.myActions;
    }

    public static class MyNextVisualPositionAction
    extends TextAction {
        private final Action textActn;
        private final int direction;

        private MyNextVisualPositionAction(Action action, int n) {
            super((String)action.getValue("Name"));
            this.textActn = action;
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)jTextComponent.getParent();
                Point point = jViewport.getViewPosition();
                if (this.direction == 1) {
                    jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
                } else {
                    point.y += jViewport.getExtentSize().height;
                    jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
                }
            }
            this.textActn.actionPerformed(actionEvent);
        }
    }
}

