/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MergeDialog;
import net.sf.jabref.MetaData;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.util.Util;

public class AppendDatabaseAction
implements BaseAction {
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final List<File> filesToOpen = new ArrayList<File>();

    public AppendDatabaseAction(JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
    }

    @Override
    public void action() {
        this.filesToOpen.clear();
        final MergeDialog mergeDialog = new MergeDialog(this.frame, Globals.lang("Append database"), true);
        Util.placeDialog(mergeDialog, this.panel);
        mergeDialog.setVisible(true);
        if (mergeDialog.isOkPressed()) {
            String[] stringArray = FileDialogs.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), null, false);
            if (stringArray == null) {
                return;
            }
            for (String string : stringArray) {
                this.filesToOpen.add(new File(string));
            }
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    AppendDatabaseAction.this.openIt(mergeDialog.importEntries(), mergeDialog.importStrings(), mergeDialog.importGroups(), mergeDialog.importSelectorWords());
                }
            });
        }
    }

    private void openIt(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.filesToOpen.size() == 0) {
            return;
        }
        for (File file : this.filesToOpen) {
            try {
                Globals.prefs.put("workingDirectory", file.getPath());
                String string = Globals.prefs.get("defaultEncoding");
                ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, string);
                AppendDatabaseAction.mergeFromBibtex(this.frame, this.panel, parserResult, bl, bl2, bl3, bl4);
                this.panel.output(Globals.lang("Imported from database") + " '" + file.getPath() + "'");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                JOptionPane.showMessageDialog(this.panel, throwable.getMessage(), "Open database", 0);
            }
        }
    }

    private static void mergeFromBibtex(JabRefFrame jabRefFrame, BasePanel basePanel, ParserResult parserResult, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws KeyCollisionException {
        GroupTreeNode groupTreeNode;
        Object object;
        BibtexDatabase bibtexDatabase = parserResult.getDatabase();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<BibtexEntry> arrayList2 = new ArrayList<BibtexEntry>();
        BibtexDatabase bibtexDatabase2 = basePanel.database();
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Append database"));
        MetaData metaData = parserResult.getMetaData();
        if (bl) {
            boolean bl5 = Globals.prefs.getBoolean("overwriteOwner");
            boolean bl6 = Globals.prefs.getBoolean("overwriteTimeStamp");
            for (String object2 : bibtexDatabase.getKeySet()) {
                BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(object2);
                object = (BibtexEntry)bibtexEntry.clone();
                ((BibtexEntry)object).setId(IdGenerator.next());
                Util.setAutomaticFields((BibtexEntry)object, bl5, bl6);
                bibtexDatabase2.insertEntry((BibtexEntry)object);
                arrayList.add(object);
                arrayList2.add(bibtexEntry);
                namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase2, (BibtexEntry)object, basePanel));
            }
        }
        if (bl2) {
            for (BibtexString bibtexString : bibtexDatabase.getStringValues()) {
                if (bibtexDatabase2.hasStringLabel(bibtexString.getName())) continue;
                bibtexDatabase2.addString(bibtexString);
                namedCompound.addEdit(new UndoableInsertString(basePanel, bibtexDatabase2, bibtexString));
            }
        }
        if (bl3 && (groupTreeNode = metaData.getGroups()) != null) {
            if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
                ExplicitGroup explicitGroup = new ExplicitGroup("Imported", GroupHierarchyType.INDEPENDENT);
                groupTreeNode.setGroup(explicitGroup);
                for (BibtexEntry bibtexEntry : arrayList) {
                    explicitGroup.addEntry(bibtexEntry);
                }
            }
            jabRefFrame.groupSelector.addGroups(groupTreeNode, namedCompound);
            object = groupTreeNode.preorderEnumeration();
            while (object.hasMoreElements()) {
                GroupTreeNode groupTreeNode2 = object.nextElement();
                if (!(groupTreeNode2.getGroup() instanceof ExplicitGroup)) continue;
                ExplicitGroup explicitGroup = (ExplicitGroup)groupTreeNode2.getGroup();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    BibtexEntry bibtexEntry = (BibtexEntry)arrayList2.get(i);
                    if (!explicitGroup.contains(bibtexEntry)) continue;
                    explicitGroup.removeEntry(bibtexEntry);
                    explicitGroup.addEntry((BibtexEntry)arrayList.get(i));
                }
            }
            jabRefFrame.groupSelector.revalidateGroups();
        }
        if (bl4) {
            for (String string : metaData) {
                if (!string.startsWith("selector_")) continue;
                basePanel.metaData().putData(string, metaData.getData(string));
            }
        }
        namedCompound.end();
        basePanel.undoManager.addEdit(namedCompound);
        basePanel.markBaseChanged();
    }
}

