/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JOptionPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PostOpenAction;

public class CheckForNewEntryTypesAction
implements PostOpenAction {
    @Override
    public boolean isActionNecessary(ParserResult parserResult) {
        Iterator<String> iterator = parserResult.getEntryTypes().keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toLowerCase();
            if (BibtexEntryType.getType(string) == null) continue;
            iterator.remove();
        }
        return parserResult.getEntryTypes().size() > 0;
    }

    @Override
    public void performAction(BasePanel basePanel, ParserResult parserResult) {
        StringBuilder stringBuilder = new StringBuilder(Globals.lang("Custom entry types found in file") + ": ");
        Object[] objectArray = parserResult.getEntryTypes().keySet().toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            stringBuilder.append(object.toString()).append(", ");
        }
        String string = stringBuilder.toString();
        int n = JOptionPane.showConfirmDialog(basePanel.frame(), string.substring(0, string.length() - 2) + ".\n" + Globals.lang("Remember these entry types?"), Globals.lang("Custom entry types"), 0, 3);
        if (n == 0) {
            for (BibtexEntryType bibtexEntryType : parserResult.getEntryTypes().values()) {
                BibtexEntryType.addOrModifyCustomEntryType((CustomEntryType)bibtexEntryType);
            }
        }
    }
}

