/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.DBLPHelper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class DBLPFetcher
implements EntryFetcher {
    private static final String URL_START = "http://www.dblp.org/search/api/";
    private static final String URL_PART1 = "?q=";
    private static final String URL_END = "&h=1000&c=4&f=0&format=json";
    private volatile boolean shouldContinue = false;
    private String query;
    private final DBLPHelper helper = new DBLPHelper();

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        boolean bl = false;
        this.query = string;
        this.shouldContinue = true;
        try {
            String string2 = this.makeSearchURL();
            URL uRL = new URL(string2);
            String string3 = this.readFromURL(uRL);
            String[] stringArray = string3.split("\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string4 : stringArray) {
                if (!string4.startsWith("\"url\"")) continue;
                String string5 = string4.replace("\"url\":\"", "");
                string5 = string5.substring(0, string5.length() - 2);
                arrayList.add(string5);
            }
            double d = DuplicateCheck.duplicateThreshold;
            DuplicateCheck.duplicateThreshold = Double.MAX_VALUE;
            int n = 1;
            for (String string5 : arrayList) {
                String[] stringArray2;
                if (!this.shouldContinue) break;
                URL uRL2 = new URL(string5);
                String string6 = this.readFromURL(uRL2);
                for (String string7 : stringArray2 = string6.split("\n")) {
                    if (!string7.contains("biburl")) continue;
                    int n2 = string7.indexOf("{");
                    int n3 = string7.indexOf("}");
                    String string8 = string7.substring(n2 + 1, n3);
                    string8 = string8.replace("dblp.uni-trier.de", "www.dblp.org");
                    URL uRL3 = new URL(string8);
                    String string9 = this.readFromURL(uRL3);
                    Collection<BibtexEntry> collection = BibtexParser.fromString(string9);
                    for (BibtexEntry bibtexEntry : collection) {
                        if (hashMap.containsKey(bibtexEntry.getCiteKey())) continue;
                        importInspector.addEntry(bibtexEntry);
                        hashMap.put(bibtexEntry.getCiteKey(), true);
                    }
                }
                importInspector.setProgress(n, arrayList.size());
                ++n;
            }
            DuplicateCheck.duplicateThreshold = d;
            bl = true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            outputPrinter.showMessage(iOException.getMessage());
        }
        return bl;
    }

    private String readFromURL(URL uRL) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[256];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    private String makeSearchURL() {
        StringBuilder stringBuilder = new StringBuilder(URL_START).append(URL_PART1);
        String string = this.helper.cleanDBLPQuery(this.query);
        stringBuilder.append(string);
        stringBuilder.append(URL_END);
        return stringBuilder.toString();
    }

    @Override
    public String getTitle() {
        return "DBLP";
    }

    @Override
    public String getKeyName() {
        return "DBLP";
    }

    @Override
    public String getHelpPage() {
        return null;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

