/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.util.Util;

public class EndnoteImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Refer/Endnote";
    }

    @Override
    public String getCLIId() {
        return "refer";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("%A .*");
        Pattern pattern2 = Pattern.compile("%E .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).matches() && !pattern2.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string2 = "__EOREOR__";
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).indexOf("%0") == 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string);
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append("\n");
        }
        String[] stringArray = stringBuilder.toString().split(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            hashMap.clear();
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            boolean bl2 = false;
            String[] stringArray2 = string3.trim().substring(1).split("\n%");
            for (String string8 : stringArray2) {
                String[] stringArray3;
                if (string8.length() < 3) continue;
                String string9 = string8.substring(0, 1);
                String[] stringArray4 = string8.substring(2);
                if (string9.equals("A")) {
                    if (string4.equals("")) {
                        string4 = stringArray4;
                        continue;
                    }
                    string4 = string4 + " and " + (String)stringArray4;
                    continue;
                }
                if (string9.equals("E")) {
                    if (string6.equals("")) {
                        string6 = stringArray4;
                        continue;
                    }
                    string6 = string6 + " and " + (String)stringArray4;
                    continue;
                }
                if (string9.equals("T")) {
                    hashMap.put("title", (String)stringArray4);
                    continue;
                }
                if (string9.equals("0")) {
                    if (stringArray4.indexOf("Journal") == 0) {
                        string5 = "article";
                        continue;
                    }
                    if (stringArray4.indexOf("Book Section") == 0) {
                        string5 = "incollection";
                        continue;
                    }
                    if (stringArray4.indexOf("Book") == 0) {
                        string5 = "book";
                        continue;
                    }
                    if (stringArray4.indexOf("Edited Book") == 0) {
                        string5 = "book";
                        bl2 = true;
                        continue;
                    }
                    if (stringArray4.indexOf("Conference") == 0) {
                        string5 = "inproceedings";
                        continue;
                    }
                    if (stringArray4.indexOf("Report") == 0) {
                        string5 = "techreport";
                        continue;
                    }
                    if (stringArray4.indexOf("Review") == 0) {
                        string5 = "article";
                        continue;
                    }
                    if (stringArray4.indexOf("Thesis") == 0) {
                        string5 = "phdthesis";
                        continue;
                    }
                    string5 = "misc";
                    continue;
                }
                if (string9.equals("7")) {
                    hashMap.put("edition", (String)stringArray4);
                    continue;
                }
                if (string9.equals("C")) {
                    hashMap.put("address", (String)stringArray4);
                    continue;
                }
                if (string9.equals("D")) {
                    hashMap.put("year", (String)stringArray4);
                    continue;
                }
                if (string9.equals("8")) {
                    hashMap.put("date", (String)stringArray4);
                    continue;
                }
                if (string9.equals("J")) {
                    if (hashMap.get("journal") != null) continue;
                    hashMap.put("journal", (String)stringArray4);
                    continue;
                }
                if (string9.equals("B")) {
                    if (string5.equals("article")) {
                        hashMap.put("journal", (String)stringArray4);
                        continue;
                    }
                    if (string5.equals("book") || string5.equals("inbook")) {
                        hashMap.put("series", (String)stringArray4);
                        continue;
                    }
                    hashMap.put("booktitle", (String)stringArray4);
                    continue;
                }
                if (string9.equals("I")) {
                    if (string5.equals("phdthesis")) {
                        hashMap.put("school", (String)stringArray4);
                        continue;
                    }
                    hashMap.put("publisher", (String)stringArray4);
                    continue;
                }
                if (string9.equals("P")) {
                    hashMap.put("pages", stringArray4.replaceAll("([0-9]) *- *([0-9])", "$1--$2"));
                    continue;
                }
                if (string9.equals("V")) {
                    hashMap.put("volume", (String)stringArray4);
                    continue;
                }
                if (string9.equals("N")) {
                    hashMap.put("number", (String)stringArray4);
                    continue;
                }
                if (string9.equals("U")) {
                    hashMap.put("url", (String)stringArray4);
                    continue;
                }
                if (string9.equals("R")) {
                    stringArray3 = stringArray4;
                    if (stringArray3.startsWith("doi:")) {
                        stringArray3 = stringArray3.substring(4);
                    }
                    hashMap.put("doi", (String)stringArray3);
                    continue;
                }
                if (string9.equals("O")) {
                    if (stringArray4.startsWith("Artn")) {
                        stringArray3 = stringArray4.split("\\s");
                        string7 = stringArray3[1];
                        continue;
                    }
                    hashMap.put("note", (String)stringArray4);
                    continue;
                }
                if (string9.equals("K")) {
                    hashMap.put("keywords", (String)stringArray4);
                    continue;
                }
                if (string9.equals("X")) {
                    hashMap.put("abstract", (String)stringArray4);
                    continue;
                }
                if (string9.equals("9")) {
                    if (stringArray4.indexOf("Ph.D.") == 0) {
                        string5 = "phdthesis";
                    }
                    if (stringArray4.indexOf("Masters") != 0) continue;
                    string5 = "mastersthesis";
                    continue;
                }
                if (!string9.equals("F")) continue;
                hashMap.put("bibtexkey", Util.checkLegalKey((String)stringArray4));
            }
            if (bl2 && string6.equals("")) {
                string6 = string4;
                string4 = "";
            }
            if (!string4.equals("")) {
                hashMap.put("author", this.fixAuthor(string4));
            }
            if (!string6.equals("")) {
                hashMap.put("editor", this.fixAuthor(string6));
            }
            if ((hashMap.get("pages") == null || ((String)hashMap.get("pages")).equals("-")) && !string7.equals("")) {
                hashMap.put("pages", string7);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string5));
            bibtexEntry.setField(hashMap);
            if (bibtexEntry.getAllFields().size() <= 0) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private String fixAuthor(String string) {
        int n = string.indexOf(" and ");
        if (n >= 0) {
            return AuthorList.fixAuthor_lastNameFirst(string);
        }
        n = string.lastIndexOf(",");
        if (n == string.length() - 1) {
            String string2 = string.substring(0, string.length() - 1).replaceAll(", ", " and ");
            return AuthorList.fixAuthor_lastNameFirst(string2);
        }
        return AuthorList.fixAuthor_lastNameFirst(string);
    }
}

