/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.util.EncryptionNotSupportedException;
import net.sf.jabref.util.XMPUtil;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import spl.PdfImporter;

public class EntryFromPDFCreator
extends EntryFromFileCreator {
    public EntryFromPDFCreator() {
        super(EntryFromPDFCreator.getPDFExternalFileType());
    }

    private static ExternalFileType getPDFExternalFileType() {
        ExternalFileType externalFileType = JabRefPreferences.getInstance().getExternalFileTypeByExt("pdf");
        if (externalFileType == null) {
            return new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall");
        }
        return externalFileType;
    }

    @Override
    public boolean accept(File file) {
        return file != null && file.getName().toUpperCase().endsWith(".PDF");
    }

    @Override
    protected BibtexEntry createBibtexEntry(File file) {
        if (!this.accept(file)) {
            return null;
        }
        PdfImporter pdfImporter = new PdfImporter(JabRef.jrf, JabRef.jrf.basePanel(), JabRef.jrf.basePanel().mainTable, -1);
        String[] stringArray = new String[]{file.toString()};
        PdfImporter.ImportPdfFilesResult importPdfFilesResult = pdfImporter.importPdfFiles(stringArray, (OutputPrinter)JabRef.jrf);
        assert (importPdfFilesResult.entries.size() == 1);
        return importPdfFilesResult.entries.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntryDataFromPDDocumentInformation(File file, BibtexEntry bibtexEntry) {
        PDDocument pDDocument = null;
        try {
            BibtexEntry bibtexEntry2;
            pDDocument = PDDocument.load(file.getAbsoluteFile());
            PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
            if (pDDocumentInformation != null && (bibtexEntry2 = XMPUtil.getBibtexEntryFromDocumentInformation(pDDocument.getDocumentInformation())) != null) {
                this.addEntryDataToEntry(bibtexEntry, bibtexEntry2);
                Calendar calendar = pDDocumentInformation.getCreationDate();
                if (calendar != null) {
                    String string = new SimpleDateFormat("yyyy.MM.dd").format(calendar.getTime());
                    this.appendToField(bibtexEntry, "timestamp", string);
                }
                if (pDDocumentInformation.getCustomMetadataValue("bibtex/bibtexkey") != null) {
                    bibtexEntry.setId(pDDocumentInformation.getCustomMetadataValue("bibtex/bibtexkey"));
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (pDDocument != null) {
                try {
                    pDDocument.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addEntyDataFromXMP(File file, BibtexEntry bibtexEntry) {
        try {
            List<BibtexEntry> list = XMPUtil.readXMP(file.getAbsoluteFile());
            this.addEntrysToEntry(bibtexEntry, list);
        }
        catch (EncryptionNotSupportedException encryptionNotSupportedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getFormatName() {
        return "PDF";
    }
}

