/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ZipFileChooser;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportCustomizationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JabRefFrame frame;
    private JTable customImporterTable;
    private final JabRefPreferences prefs = Globals.prefs;
    private final ImportCustomizationDialog importCustomizationDialog = this;
    private static final Log LOGGER = LogFactory.getLog(ImportCustomizationDialog.class);

    @Override
    public Dimension getSize() {
        int n = 680;
        return new Dimension(n, n / 2);
    }

    private String pathToClass(File file, File file2) {
        String string = null;
        while (!file2.equals(file)) {
            string = file2.getName() + (string != null ? "." + string : "");
            file2 = file2.getParentFile();
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        string = string.substring(0, n);
        return string;
    }

    void addOrReplaceImporter(CustomImportList.Importer importer) {
        this.prefs.customImports.replaceImporter(importer);
        Globals.importFormatReader.resetImportFormats();
        ((ImportTableModel)this.customImporterTable.getModel()).fireTableDataChanged();
    }

    public ImportCustomizationDialog(JabRefFrame jabRefFrame) throws HeadlessException {
        super(jabRefFrame, Globals.lang("Manage custom imports"), false);
        this.frame = jabRefFrame;
        JButton jButton = new JButton(Globals.lang("Add from folder"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                CustomImportList.Importer importer = ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.new CustomImportList.Importer();
                importer.setBasePath(FileDialogs.getNewDir(ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), "", Globals.lang("Select Classpath of New Importer"), 2, false));
                if (importer.getBasePath() != null) {
                    string = FileDialogs.getNewFile((JFrame)ImportCustomizationDialog.this.frame, importer.getFileFromBasePath(), ".class", Globals.lang("Select new ImportFormat Subclass"), 2, false);
                }
                if (string != null) {
                    try {
                        importer.setClassName(ImportCustomizationDialog.this.pathToClass(importer.getFileFromBasePath(), new File(string)));
                        importer.setName(importer.getInstance().getFormatName());
                        importer.setCliId(importer.getInstance().getCLIId());
                        ImportCustomizationDialog.this.addOrReplaceImporter(importer);
                        ImportCustomizationDialog.this.customImporterTable.revalidate();
                        ImportCustomizationDialog.this.customImporterTable.repaint();
                        ImportCustomizationDialog.this.frame.setUpImportMenus();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0", string));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0. Have you chosen the correct package path?", string));
                    }
                }
            }
        });
        jButton.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a class path. \nThe path need not be on the classpath of JabRef."));
        JButton jButton2 = new JButton(Globals.lang("Add from jar"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FileDialogs.getNewFile((JFrame)ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), ".zip,.jar", Globals.lang("Select a Zip-archive"), 2, false);
                ZipFile zipFile = null;
                if (string != null) {
                    try {
                        zipFile = new ZipFile(new File(string), 1);
                    }
                    catch (IOException iOException) {
                        LOGGER.info("Could not open Zip-archive: \n" + iOException.getMessage(), iOException);
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not open %0", string) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                        return;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        noClassDefFoundError.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0", string) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                    }
                }
                if (zipFile != null) {
                    ZipFileChooser zipFileChooser = new ZipFileChooser(ImportCustomizationDialog.this.importCustomizationDialog, zipFile);
                    zipFileChooser.setVisible(true);
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint(10L);
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                }
            }
        });
        jButton2.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a Zip-archive.\nThe Zip-archive need not be on the classpath of JabRef."));
        JButton jButton3 = new JButton(Globals.lang("Show description"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (n != -1) {
                    CustomImportList.Importer importer = ((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(n);
                    try {
                        ImportFormat importFormat = importer.getInstance();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, importFormat.getDescription());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1", importer.getName() + ":\n", exception.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer."));
                }
            }
        });
        JButton jButton4 = new JButton(Globals.lang("Remove"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (n != -1) {
                    ImportCustomizationDialog.this.customImporterTable.removeRowSelectionInterval(n, n);
                    ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.remove(((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(n));
                    Globals.importFormatReader.resetImportFormats();
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint();
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer."));
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportCustomizationDialog.this.dispose();
            }
        };
        JButton jButton5 = new JButton(Globals.lang("Close"));
        jButton5.addActionListener(abstractAction);
        JButton jButton6 = new JButton(Globals.lang("Help"));
        jButton6.addActionListener(new HelpAction(this.frame.helpDiag, "CustomImports.html", "Help"));
        ImportTableModel importTableModel = new ImportTableModel();
        this.customImporterTable = new JTable(importTableModel);
        TableColumnModel tableColumnModel = this.customImporterTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        tableColumnModel.getColumn(2).setPreferredWidth(200);
        tableColumnModel.getColumn(3).setPreferredWidth(200);
        JScrollPane jScrollPane = new JScrollPane(this.customImporterTable, 20, 31);
        this.customImporterTable.setSelectionMode(0);
        this.customImporterTable.setPreferredScrollableViewportSize(this.getSize());
        if (this.customImporterTable.getRowCount() > 0) {
            this.customImporterTable.setRowSelectionInterval(0, 0);
        }
        JPanel jPanel = new JPanel();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addButton((JComponent)jButton4);
        buttonBarBuilder.addButton((JComponent)jButton5);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addButton((JComponent)jButton6);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setSize(this.getSize());
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.customImporterTable);
    }

    class ImportTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{Globals.lang("Import name"), Globals.lang("Command line id"), Globals.lang("ImportFormat class"), Globals.lang("Contained in")};

        ImportTableModel() {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            CustomImportList.Importer importer = this.getImporter(n);
            if (n2 == 0) {
                object = importer.getName();
            } else if (n2 == 1) {
                object = importer.getClidId();
            } else if (n2 == 2) {
                object = importer.getClassName();
            } else if (n2 == 3) {
                object = importer.getFileFromBasePath();
            }
            return object;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Globals.prefs.customImports.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public CustomImportList.Importer getImporter(int n) {
            CustomImportList.Importer[] importerArray = Globals.prefs.customImports.toArray(new CustomImportList.Importer[Globals.prefs.customImports.size()]);
            return importerArray[n];
        }
    }
}

